/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.xsr.ManagementPane;
import com.apple.xsr.ManagementPerformanceModel;
import com.apple.xsr.OperationManager;
import com.apple.xsr.RadioButtonGroup;
import com.apple.xsr.Resources;
import com.apple.xsr.SetupPane;
import com.apple.xsr.SizeLinkedPanel;
import com.apple.xsr.som.RaidSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ManagementPerformancePane
extends JPanel {
    static final int CHANNEL_COUNT = 2;
    static final int CONTROL_HSPACE = 5;
    static final int CONTROL_VSPACE = 16;
    static final int GROUP_SPACING = 16;
    private static final Color COLOR_TEXT_DISABLED = new JTextArea().getDisabledTextColor();
    SizeLinkedPanel[] lunGroup = new SizeLinkedPanel[2];
    JCheckBox[] controllerCacheCheckBox = new JCheckBox[2];
    JCheckBox[] syncCacheCheckBox = new JCheckBox[2];
    JCheckBox[] diskCacheCheckBox = new JCheckBox[2];
    JCheckBox[] slowReadBypassCheckBox = new JCheckBox[2];
    RadioButtonGroup[] prefetchGroup = new RadioButtonGroup[2];
    JRadioButton[][] prefetchRadio = new JRadioButton[2][3];
    JTextPane[] diskCacheMessageLabel = new JTextPane[2];
    JTextPane[] syncCacheMessageLabel = new JTextPane[2];
    JTextPane[] slowReadBypassMessageLabel = new JTextPane[2];
    SetupPane parent;
    boolean populated = false;
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$ManagementPerformancePane == null ? (class$com$apple$xsr$ManagementPerformancePane = ManagementPerformancePane.class$("com.apple.xsr.ManagementPerformancePane")) : class$com$apple$xsr$ManagementPerformancePane);
    static /* synthetic */ Class class$com$apple$xsr$ManagementPerformancePane;

    public ManagementPerformancePane(SetupPane setupPane) {
        GUIFactory.configureComponentForPlatform(this);
        this.parent = setupPane;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ManagementPerformancePane.this.populated) {
                    ManagementPerformancePane.this.validate(null);
                    ManagementPerformancePane.this.parent.setModified();
                }
            }
        };
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (ManagementPerformancePane.this.populated) {
                    ManagementPerformancePane.this.validate(null);
                    ManagementPerformancePane.this.parent.setModified();
                }
            }
        };
        Insets insets = new Insets(0, 0, 0, 0);
        this.setBorder(ManagementPane.DEFAULT_BORDER);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        for (int i = 0; i < 2; ++i) {
            int n = 0;
            this.lunGroup[i] = new SizeLinkedPanel();
            this.lunGroup[i].setFont(GUIFactory.FONT_SMALL);
            String string = " ";
            string = string + Resources.getString(i == 0 ? "management.performance.drives1thru7" : "management.performance.drives8thru14");
            string = string + " ";
            TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
            titledBorder.setTitleFont(GUIFactory.FONT_SMALL);
            this.lunGroup[i].setBorder(new CompoundBorder(titledBorder, ManagementPane.DEFAULT_GROUP_BOX_BORDER));
            this.lunGroup[i].setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.fill = 2;
            this.controllerCacheCheckBox[i] = GUIFactory.newCheckBox(Resources.getString("management.performance.controllerCache"));
            this.controllerCacheCheckBox[i].setFont(GUIFactory.FONT_SMALL);
            this.controllerCacheCheckBox[i].addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    JCheckBox jCheckBox = (JCheckBox)changeEvent.getSource();
                    int n = jCheckBox == ManagementPerformancePane.this.controllerCacheCheckBox[0] ? 0 : 1;
                    ManagementPerformancePane.this.syncCacheCheckBox[n].setEnabled(jCheckBox.isSelected());
                }
            });
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = n++;
            gridBagConstraints2.insets = new Insets(0, 0, 4, 0);
            this.lunGroup[i].add((Component)this.controllerCacheCheckBox[i], gridBagConstraints2);
            JTextPane jTextPane = GUIFactory.newTextPane(Resources.getString("management.performance.controllerCacheMessage"));
            jTextPane.setFont(GUIFactory.FONT_TINY);
            jTextPane.setEditable(false);
            jTextPane.setOpaque(false);
            gridBagConstraints2.gridy = n++;
            gridBagConstraints2.insets = new Insets(0, 0, 8, 0);
            this.lunGroup[i].add((Component)jTextPane, gridBagConstraints2);
            this.syncCacheCheckBox[i] = GUIFactory.newCheckBox(Resources.getString("management.performance.syncCache"));
            this.syncCacheCheckBox[i].setFont(GUIFactory.FONT_SMALL);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = n++;
            gridBagConstraints2.insets = new Insets(0, 20, 4, 0);
            this.lunGroup[i].add((Component)this.syncCacheCheckBox[i], gridBagConstraints2);
            this.syncCacheMessageLabel[i] = GUIFactory.newTextPane(Resources.getString("management.performance.syncCacheMessage"));
            this.syncCacheMessageLabel[i].setFont(GUIFactory.FONT_TINY);
            this.syncCacheMessageLabel[i].setEditable(false);
            this.syncCacheMessageLabel[i].setOpaque(false);
            gridBagConstraints2.insets = new Insets(0, 20, 16, 0);
            gridBagConstraints2.gridy = n++;
            this.lunGroup[i].add((Component)this.syncCacheMessageLabel[i], gridBagConstraints2);
            this.diskCacheCheckBox[i] = GUIFactory.newCheckBox(Resources.getString("management.performance.diskCache"));
            this.diskCacheCheckBox[i].setFont(GUIFactory.FONT_SMALL);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = n++;
            gridBagConstraints2.insets = new Insets(0, 0, 4, 0);
            this.lunGroup[i].add((Component)this.diskCacheCheckBox[i], gridBagConstraints2);
            this.diskCacheMessageLabel[i] = GUIFactory.newTextPane(Resources.getString("management.performance.diskCacheMessage"));
            this.diskCacheMessageLabel[i].setFont(GUIFactory.FONT_TINY);
            this.diskCacheMessageLabel[i].setEditable(false);
            this.diskCacheMessageLabel[i].setOpaque(false);
            gridBagConstraints2.gridy = n++;
            gridBagConstraints2.insets = new Insets(0, 0, 16, 0);
            this.lunGroup[i].add((Component)this.diskCacheMessageLabel[i], gridBagConstraints2);
            this.slowReadBypassCheckBox[i] = GUIFactory.newCheckBox(Resources.getString("management.performance.slowReadBypass"));
            this.slowReadBypassCheckBox[i].setFont(GUIFactory.FONT_SMALL);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = n++;
            gridBagConstraints2.insets = new Insets(0, 0, 4, 0);
            this.lunGroup[i].add((Component)this.slowReadBypassCheckBox[i], gridBagConstraints2);
            this.slowReadBypassMessageLabel[i] = GUIFactory.newTextPane(Resources.getString("management.performance.slowReadBypassMessage"));
            this.slowReadBypassMessageLabel[i].setFont(GUIFactory.FONT_TINY);
            this.slowReadBypassMessageLabel[i].setEditable(false);
            this.slowReadBypassMessageLabel[i].setOpaque(false);
            gridBagConstraints2.insets = new Insets(0, 0, 16, 0);
            gridBagConstraints2.gridy = n++;
            this.lunGroup[i].add((Component)this.slowReadBypassMessageLabel[i], gridBagConstraints2);
            JLabel jLabel = new JLabel(Resources.getString("management.performance.prefetch"));
            jLabel.setFont(GUIFactory.FONT_SMALL);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = n++;
            gridBagConstraints2.insets = new Insets(0, 4, 8, 5);
            this.lunGroup[i].add((Component)jLabel, gridBagConstraints2);
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            this.prefetchGroup[i] = new RadioButtonGroup();
            for (int j = 0; j < 3; ++j) {
                String string2 = j == 0 ? Resources.getString("management.performance.prefetch.1") : (j == 1 ? Resources.getString("management.performance.prefetch.8") : Resources.getString("management.performance.prefetch.128"));
                this.prefetchRadio[i][j] = GUIFactory.newRadioButton(string2, true);
                this.prefetchRadio[i][j].addActionListener(actionListener);
                this.prefetchRadio[i][j].setFont(GUIFactory.FONT_SMALL);
                this.prefetchGroup[i].add(this.prefetchRadio[i][j]);
                gridBagConstraints2.gridx = 0;
                gridBagConstraints2.gridy = n++;
                gridBagConstraints2.insets = new Insets(0, 20, j == 2 ? 16 : 0, 0);
                this.lunGroup[i].add((Component)this.prefetchRadio[i][j], gridBagConstraints2);
            }
            gridBagConstraints.gridx = i;
            gridBagConstraints.insets = new Insets(0, i > 0 ? 16 : 0, 0, 0);
            this.add((Component)this.lunGroup[i], gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.add(Box.createVerticalStrut(0), gridBagConstraints);
        this.lunGroup[0].linkPanel(this.lunGroup[1]);
    }

    public void populate(ManagementPerformanceModel managementPerformanceModel) {
        RaidSystem raidSystem = managementPerformanceModel.getRaidSystem();
        for (int i = 0; i < 2; ++i) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            ManagementPerformanceModel.ManagementPerformanceControllerModel managementPerformanceControllerModel = i == 0 ? managementPerformanceModel.getUpperPerformanceModel() : managementPerformanceModel.getLowerPerformanceModel();
            int n = managementPerformanceControllerModel.getControllerCache();
            int n2 = managementPerformanceControllerModel.getSyncCache();
            int n3 = managementPerformanceControllerModel.getDiskCache();
            int n4 = managementPerformanceControllerModel.getSlowReadBypass();
            int n5 = managementPerformanceControllerModel.getPrefetch();
            this.controllerCacheCheckBox[i].setSelected(n == 0);
            this.prefetchRadio[i][n5].setSelected(true);
            try {
                bl3 = OperationManager.isSupported(raidSystem, OperationManager.OP_CONFIGURE_DISK_CACHE);
            }
            catch (Exception exception) {
                bl3 = true;
                logger.error(exception);
            }
            try {
                bl2 = OperationManager.isSupported(raidSystem, OperationManager.OP_CONFIGURE_SYNC_CACHE);
            }
            catch (Exception exception) {
                bl2 = true;
                logger.error(exception);
            }
            try {
                bl = OperationManager.isSupported(raidSystem, OperationManager.OP_CONFIGURE_SLOW_READ_BYPASS);
            }
            catch (Exception exception) {
                bl = true;
                logger.error(exception);
            }
            this.diskCacheCheckBox[i].setEnabled(bl3);
            this.diskCacheMessageLabel[i].setEnabled(bl3);
            if (bl3) {
                this.diskCacheCheckBox[i].setSelected(n3 == 0);
            } else if (COLOR_TEXT_DISABLED != null) {
                this.diskCacheMessageLabel[i].setForeground(COLOR_TEXT_DISABLED);
            }
            this.syncCacheCheckBox[i].setEnabled(bl2);
            this.syncCacheMessageLabel[i].setEnabled(bl2);
            if (bl2) {
                this.syncCacheCheckBox[i].setSelected(n2 == 0);
            } else if (COLOR_TEXT_DISABLED != null) {
                this.syncCacheMessageLabel[i].setForeground(COLOR_TEXT_DISABLED);
            }
            this.slowReadBypassCheckBox[i].setEnabled(bl);
            this.slowReadBypassMessageLabel[i].setEnabled(bl);
            if (bl) {
                this.slowReadBypassCheckBox[i].setSelected(n4 == 0);
                continue;
            }
            if (COLOR_TEXT_DISABLED == null) continue;
            this.slowReadBypassMessageLabel[i].setForeground(COLOR_TEXT_DISABLED);
        }
        this.validate(null);
        this.populated = true;
    }

    public boolean validate(ManagementPerformanceModel managementPerformanceModel) {
        boolean bl = true;
        int n = this.parent.tabbedPane.indexOfComponent(this);
        if (!bl && this.parent.tabbedPane.getSelectedIndex() != n) {
            this.parent.tabbedPane.setIconAt(n, new ImageIcon(Resources.getImage("icon.validate")));
        } else {
            this.parent.tabbedPane.setIconAt(n, null);
        }
        if (bl && managementPerformanceModel != null) {
            for (int i = 0; i < 2; ++i) {
                ManagementPerformanceModel.ManagementPerformanceControllerModel managementPerformanceControllerModel = i == 0 ? managementPerformanceModel.getUpperPerformanceModel() : managementPerformanceModel.getLowerPerformanceModel();
                int n2 = this.controllerCacheCheckBox[i].isSelected() ? 0 : 1;
                int n3 = this.syncCacheCheckBox[i].isSelected() ? 0 : 1;
                int n4 = this.diskCacheCheckBox[i].isSelected() ? 0 : 1;
                int n5 = this.slowReadBypassCheckBox[i].isSelected() ? 0 : 1;
                int n6 = this.prefetchGroup[i].getSelectedIndex();
                managementPerformanceControllerModel.setControllerCache(n2);
                managementPerformanceControllerModel.setSyncCache(n3);
                managementPerformanceControllerModel.setDiskCache(n4);
                managementPerformanceControllerModel.setSlowReadBypass(n5);
                managementPerformanceControllerModel.setPrefetch(n6);
            }
        }
        return bl;
    }

    public SizeLinkedPanel getGroupBox(int n) {
        return this.lunGroup[n];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

