/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.gui.RestrictedTextField;
import com.apple.xsr.ManagementFibreModel;
import com.apple.xsr.ManagementPane;
import com.apple.xsr.RadioButtonGroup;
import com.apple.xsr.Resources;
import com.apple.xsr.SetupPane;
import com.apple.xsr.SizeLinkedPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class ManagementFibrePane
extends JPanel {
    SizeLinkedPanel[] lunGroup;
    JLabel[] wwpnValue;
    JLabel[] wwnnValue;
    RadioButtonGroup[] speedGroup;
    JRadioButton[][] speedRadio;
    RadioButtonGroup[] topologyGroup;
    JRadioButton[][] topologyRadio;
    JCheckBox[] hardLoopCheckBox;
    JLabel[] hardLoopIDLabel;
    RestrictedTextField[] hardLoopText;
    JLabel[] validateLabel;
    SetupPane parent;
    boolean populated = false;
    static final int CHANNEL_COUNT = 2;
    static final int CONTROL_HSPACE = 5;
    static final int CONTROL_VSPACE = 16;
    static final int GROUP_SPACING = 16;

    public ManagementFibrePane(SetupPane setupPane) {
        GUIFactory.configureComponentForPlatform(this);
        this.parent = setupPane;
        this.lunGroup = new SizeLinkedPanel[2];
        this.wwpnValue = new JLabel[2];
        this.wwnnValue = new JLabel[2];
        this.speedGroup = new RadioButtonGroup[2];
        this.speedRadio = new JRadioButton[2][3];
        this.topologyGroup = new RadioButtonGroup[2];
        this.topologyRadio = new JRadioButton[2][3];
        this.hardLoopCheckBox = new JCheckBox[2];
        this.hardLoopIDLabel = new JLabel[2];
        this.hardLoopText = new RestrictedTextField[2];
        this.validateLabel = new JLabel[2];
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                if (ManagementFibrePane.this.populated) {
                    ManagementFibrePane.this.validate(null);
                }
            }
        };
        CaretListener caretListener = new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                if (ManagementFibrePane.this.populated) {
                    ManagementFibrePane.this.parent.setModified();
                }
            }
        };
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ManagementFibrePane.this.populated) {
                    ManagementFibrePane.this.validate(null);
                    ManagementFibrePane.this.parent.setModified();
                }
            }
        };
        this.setBorder(ManagementPane.DEFAULT_BORDER);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        for (int i = 0; i < 2; ++i) {
            Object object;
            int n = 0;
            this.lunGroup[i] = new SizeLinkedPanel();
            this.lunGroup[i].setFont(GUIFactory.FONT_SMALL);
            String string = Resources.getString(i == 0 ? "management.fibre.drives1thru7" : "management.fibre.drives8thru14");
            TitledBorder titledBorder = BorderFactory.createTitledBorder(" " + string + " ");
            titledBorder.setTitleFont(GUIFactory.FONT_SMALL);
            this.lunGroup[i].setBorder(new CompoundBorder(titledBorder, ManagementPane.DEFAULT_GROUP_BOX_BORDER));
            this.lunGroup[i].setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.fill = 2;
            JLabel jLabel = new JLabel(Resources.getString("management.fibre.wwnn"));
            jLabel.setFont(GUIFactory.FONT_SMALL);
            jLabel.setHorizontalAlignment(4);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = n;
            gridBagConstraints2.insets = new Insets(0, 0, 16, 5);
            this.lunGroup[i].add((Component)jLabel, gridBagConstraints2);
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            this.wwnnValue[i] = new JLabel();
            this.wwnnValue[i].setFont(GUIFactory.FONT_SMALL);
            this.wwnnValue[i].setHorizontalAlignment(4);
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = n++;
            gridBagConstraints2.insets = new Insets(0, 0, 16, 0);
            this.lunGroup[i].add((Component)this.wwnnValue[i], gridBagConstraints2);
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            JLabel jLabel2 = new JLabel(Resources.getString("management.fibre.wwpn"));
            jLabel2.setFont(GUIFactory.FONT_SMALL);
            jLabel2.setHorizontalAlignment(4);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = n;
            gridBagConstraints2.insets = new Insets(0, 0, 16, 5);
            this.lunGroup[i].add((Component)jLabel2, gridBagConstraints2);
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            this.wwpnValue[i] = new JLabel();
            this.wwpnValue[i].setFont(GUIFactory.FONT_SMALL);
            this.wwpnValue[i].setHorizontalAlignment(4);
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = n++;
            gridBagConstraints2.insets = new Insets(0, 0, 16, 0);
            this.lunGroup[i].add((Component)this.wwpnValue[i], gridBagConstraints2);
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            JLabel jLabel3 = new JLabel(Resources.getString("management.fibre.speed"));
            jLabel3.setFont(GUIFactory.FONT_SMALL);
            jLabel3.setHorizontalAlignment(4);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = n;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 5);
            this.lunGroup[i].add((Component)jLabel3, gridBagConstraints2);
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            this.speedGroup[i] = new RadioButtonGroup();
            for (int j = 0; j < 3; ++j) {
                object = j == 1 ? Resources.getString("management.fibre.speed.1Gbps") : (j == 2 ? Resources.getString("management.fibre.speed.2Gbps") : Resources.getString("management.fibre.speed.auto"));
                this.speedRadio[i][j] = GUIFactory.newRadioButton((String)object, true);
                this.speedRadio[i][j].addActionListener(actionListener);
                this.speedRadio[i][j].setFont(GUIFactory.FONT_SMALL);
                this.speedGroup[i].add(this.speedRadio[i][j]);
                gridBagConstraints2.gridx = 1;
                gridBagConstraints2.gridy = n++;
                gridBagConstraints2.insets = new Insets(0, 0, j == 2 ? 16 : 0, 0);
                this.lunGroup[i].add((Component)this.speedRadio[i][j], gridBagConstraints2);
                gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            }
            JLabel jLabel4 = new JLabel(Resources.getString("management.fibre.topology"));
            jLabel4.setFont(GUIFactory.FONT_SMALL);
            jLabel4.setHorizontalAlignment(4);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = n;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 5);
            this.lunGroup[i].add((Component)jLabel4, gridBagConstraints2);
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            this.topologyGroup[i] = new RadioButtonGroup();
            for (int j = 0; j < 3; ++j) {
                String string2 = j == 1 ? Resources.getString("management.fibre.topology.pointtopoint") : (j == 2 ? Resources.getString("management.fibre.topology.arbitratedloop") : Resources.getString("management.fibre.topology.auto"));
                this.topologyRadio[i][j] = GUIFactory.newRadioButton(string2, true);
                this.topologyRadio[i][j].addActionListener(actionListener);
                this.topologyRadio[i][j].setFont(GUIFactory.FONT_SMALL);
                this.topologyGroup[i].add(this.topologyRadio[i][j]);
                gridBagConstraints2.gridx = 1;
                gridBagConstraints2.gridy = n++;
                gridBagConstraints2.insets = new Insets(0, 0, j == 2 ? 16 : 0, 0);
                this.lunGroup[i].add((Component)this.topologyRadio[i][j], gridBagConstraints2);
                gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            }
            this.hardLoopCheckBox[i] = GUIFactory.newCheckBox(Resources.getString("management.fibre.hardloop.enable"));
            this.hardLoopCheckBox[i].addActionListener(actionListener);
            this.hardLoopCheckBox[i].setFont(GUIFactory.FONT_SMALL);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = n++;
            gridBagConstraints2.gridwidth = 2;
            this.lunGroup[i].add((Component)this.hardLoopCheckBox[i], gridBagConstraints2);
            gridBagConstraints2.gridwidth = 1;
            this.hardLoopIDLabel[i] = new JLabel(Resources.getString("management.fibre.hardloop.id"));
            this.hardLoopIDLabel[i].setFont(GUIFactory.FONT_SMALL);
            this.hardLoopIDLabel[i].setHorizontalAlignment(4);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = n;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 5);
            this.lunGroup[i].add((Component)this.hardLoopIDLabel[i], gridBagConstraints2);
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            this.hardLoopText[i] = GUIFactory.newRestrictedTextField("");
            this.hardLoopText[i].setFont(GUIFactory.FONT_SMALL);
            this.hardLoopText[i].addFocusListener(focusAdapter);
            this.hardLoopText[i].addCaretListener(caretListener);
            this.hardLoopText[i].addActionListener(actionListener);
            this.hardLoopText[i].setRestrictedCharacterSet(Resources.getString("aquaTextField.validNumericCharacters"));
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = n;
            this.lunGroup[i].add((Component)this.hardLoopText[i], gridBagConstraints2);
            this.hardLoopCheckBox[i].addActionListener(new HardLoopIdListener(i));
            object = new ImageIcon(Resources.getImage("icon.validate"));
            this.validateLabel[i] = new JLabel((Icon)object);
            this.validateLabel[i].setVisible(false);
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.gridy = n++;
            gridBagConstraints2.insets = new Insets(0, 2, 0, 0);
            this.lunGroup[i].add((Component)this.validateLabel[i], gridBagConstraints2);
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.gridy = n++;
            this.lunGroup[i].add(Box.createHorizontalStrut(16), gridBagConstraints2);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = n++;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.gridwidth = 3;
            gridBagConstraints2.fill = 1;
            this.lunGroup[i].add(Box.createGlue(), gridBagConstraints2);
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.weighty = 0.0;
            gridBagConstraints2.gridwidth = 0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints.gridx = i;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(0, i > 0 ? 16 : 0, 0, 0);
            this.add((Component)this.lunGroup[i], gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        }
        this.lunGroup[0].linkPanel(this.lunGroup[1]);
    }

    public void populate(ManagementFibreModel managementFibreModel) {
        for (int i = 0; i < 2; ++i) {
            ManagementFibreModel.ManagementFibreControllerModel managementFibreControllerModel = i == 0 ? managementFibreModel.getUpperControllerModel() : managementFibreModel.getLowerControllerModel();
            String string = managementFibreControllerModel.getWWPName();
            String string2 = managementFibreControllerModel.getWWNName();
            int n = managementFibreControllerModel.getSpeed();
            int n2 = managementFibreControllerModel.getTopology();
            boolean bl = managementFibreControllerModel.getHardLoopEnabled();
            String string3 = managementFibreControllerModel.getHardLoopID();
            this.wwpnValue[i].setText(string);
            this.wwnnValue[i].setText(string2);
            this.speedRadio[i][n].setSelected(true);
            this.topologyRadio[i][n2].setSelected(true);
            this.setHardLoopIdEnabled(bl, i);
            this.hardLoopText[i].setText(string3);
        }
        this.validate(null);
        this.populated = true;
    }

    public boolean validate(ManagementFibreModel managementFibreModel) {
        int n;
        boolean bl = true;
        for (n = 0; n < 2; ++n) {
            boolean bl2 = this.hardLoopCheckBox[n].isSelected();
            String string = this.hardLoopText[n].getText();
            int n2 = string.length();
            if (bl2 && n2 == 0 || n2 > 3) {
                this.validateLabel[n].setVisible(true);
                bl = false;
                continue;
            }
            this.validateLabel[n].setVisible(false);
        }
        n = this.parent.tabbedPane.indexOfComponent(this);
        if (!bl && this.parent.tabbedPane.getSelectedIndex() != n) {
            this.parent.tabbedPane.setIconAt(n, new ImageIcon(Resources.getImage("icon.validate")));
        } else {
            this.parent.tabbedPane.setIconAt(n, null);
        }
        if (bl && managementFibreModel != null) {
            for (int i = 0; i < 2; ++i) {
                ManagementFibreModel.ManagementFibreControllerModel managementFibreControllerModel = i == 0 ? managementFibreModel.getUpperControllerModel() : managementFibreModel.getLowerControllerModel();
                String string = this.wwpnValue[i].getText();
                String string2 = this.wwnnValue[i].getText();
                int n3 = this.speedGroup[i].getSelectedIndex();
                int n4 = this.topologyGroup[i].getSelectedIndex();
                boolean bl3 = this.hardLoopCheckBox[i].isSelected();
                String string3 = this.hardLoopText[i].getText();
                int n5 = string3.length();
                managementFibreControllerModel.setWWPName(string);
                managementFibreControllerModel.setWWNName(string2);
                managementFibreControllerModel.setSpeed(n3);
                managementFibreControllerModel.setTopology(n4);
                managementFibreControllerModel.setHardLoopEnabled(bl3);
                managementFibreControllerModel.setHardLoopID(n5 > 0 ? string3 : "0");
            }
        }
        return bl;
    }

    public SizeLinkedPanel getGroupBox(int n) {
        return this.lunGroup[n];
    }

    private void setHardLoopIdEnabled(boolean bl, int n) {
        this.hardLoopCheckBox[n].setSelected(bl);
        this.hardLoopIDLabel[n].setEnabled(bl);
        this.hardLoopText[n].setEnabled(bl);
    }

    private class HardLoopIdListener
    implements ActionListener {
        int group;

        public HardLoopIdListener(int n) {
            this.group = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
            ManagementFibrePane.this.setHardLoopIdEnabled(bl, this.group);
        }
    }
}

