/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.net.acp.AcpPropertyCode;
import com.apple.util.StringUtilities;
import com.apple.util.plist.PropertyListUtilities;
import com.apple.xsr.AquaAlert;
import com.apple.xsr.AquaAlertListener;
import com.apple.xsr.AquaProgressClock;
import com.apple.xsr.ArraySelectionPanel;
import com.apple.xsr.CreateArrayModel;
import com.apple.xsr.CreateArrayPane;
import com.apple.xsr.DataModel;
import com.apple.xsr.DeleteArrayModel;
import com.apple.xsr.DeleteArrayPane;
import com.apple.xsr.DriveSelectionPanel;
import com.apple.xsr.EmailNotifications;
import com.apple.xsr.LunMaskSetting;
import com.apple.xsr.ManagementFibreModel;
import com.apple.xsr.ManagementNetworkModel;
import com.apple.xsr.ManagementPane;
import com.apple.xsr.ManagementPerformanceModel;
import com.apple.xsr.ManagementSystemModel;
import com.apple.xsr.ManagementWindow;
import com.apple.xsr.NotificationsModel;
import com.apple.xsr.NotificationsPane;
import com.apple.xsr.OperationManager;
import com.apple.xsr.RaidAdmin;
import com.apple.xsr.Resources;
import com.apple.xsr.SOMLocalizer;
import com.apple.xsr.SetupPane;
import com.apple.xsr.TestEmail;
import com.apple.xsr.Utilities;
import com.apple.xsr.advanced.AdvancedExpansionModel;
import com.apple.xsr.advanced.AdvancedExpansionPane;
import com.apple.xsr.advanced.AdvancedMaskingModel;
import com.apple.xsr.advanced.AdvancedMaskingPane;
import com.apple.xsr.advanced.AdvancedSlicingModel;
import com.apple.xsr.advanced.AdvancedSlicingPane;
import com.apple.xsr.firstaid.AbstractFirstAidPane;
import com.apple.xsr.firstaid.FirstAidDataModel;
import com.apple.xsr.net.CommunicationHandler;
import com.apple.xsr.net.IPAddress;
import com.apple.xsr.net.MessageFactory;
import com.apple.xsr.net.RequestMessage;
import com.apple.xsr.net.Response;
import com.apple.xsr.som.Disk;
import com.apple.xsr.som.DiskSlot;
import com.apple.xsr.som.FibreChannelInterface;
import com.apple.xsr.som.NetworkInterface;
import com.apple.xsr.som.RaidController;
import com.apple.xsr.som.RaidSet;
import com.apple.xsr.som.RaidSystem;
import com.apple.xsr.som.Slice;
import com.apple.xsr.som.SystemController;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InvocationEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

class ManagementController
implements ActionListener {
    private static final int SYSTEM_SETUP_MODEL = 0;
    private static final int NETWORK_SETUP_MODEL = 1;
    private static final int FIBRE_SETUP_MODEL = 2;
    private static final int PERFORMANCE_SETUP_MODEL = 3;
    private static final int SLICING_MODEL = 0;
    private static final int EXPANSION_MODEL = 1;
    private static final int MASKING_MODEL = 2;
    private static final int PROGRESS_ALERT_DISPLAY_SECS = 4;
    private static final int RESTART_UPPER_RAID_MASK = 1;
    private static final int RESTART_LOWER_RAID_MASK = 2;
    private static final int RESTART_UPPER_COPROCESSOR_MASK = 4;
    private static final int RESTART_LOWER_COPROCESSOR_MASK = 8;
    private static final int SYNC_NVRAM_UPPER_RAID_MASK = 16;
    private static final int SYNC_NVRAM_LOWER_RAID_MASK = 32;
    private static final int SYNC_NVRAM_UPPER_COPROCESSOR_MASK = 64;
    private static final int SYNC_NVRAM_LOWER_COPROCESSOR_MASK = 128;
    private static final int SYSTEM_NAME_MAX_LENGTH_BYTES = 255;
    private static final String SYSTEM_NAME_UNIQUIFIER = "-2";
    private ManagementWindow managementWindow;
    private RaidSystem managedSystem;
    private DataModel createDataModel = new CreateArrayModel();
    private DataModel deleteDataModel = new DeleteArrayModel();
    private DataModel notificationsModel = new NotificationsModel();
    private DataModel firstAidDataModel = new FirstAidDataModel();
    private DataModel[] setupDataModels = new DataModel[]{new ManagementSystemModel(), new ManagementNetworkModel(), new ManagementFibreModel(), new ManagementPerformanceModel()};
    private DataModel[] advancedDataModels = new DataModel[]{new AdvancedSlicingModel(), new AdvancedExpansionModel(), new AdvancedMaskingModel()};
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$ManagementController == null ? (class$com$apple$xsr$ManagementController = ManagementController.class$("com.apple.xsr.ManagementController")) : class$com$apple$xsr$ManagementController);
    static /* synthetic */ Class class$com$apple$xsr$ManagementController;
    static /* synthetic */ Class class$com$apple$xsr$ManagementController$RaidSetCreator;
    static /* synthetic */ Class class$com$apple$xsr$ManagementController$Slicer;
    static /* synthetic */ Class class$com$apple$xsr$ManagementController$LunMapper;
    static /* synthetic */ Class class$com$apple$xsr$ManagementController$LunMapRepairer;

    public boolean showManagementWindow(RaidSystem raidSystem, String string, Component component) {
        if (raidSystem == null) {
            throw new NullPointerException("selected system cannot be null");
        }
        if (string == null) {
            throw new NullPointerException("pane cannot be null");
        }
        boolean bl = true;
        if (this.managedSystem == null) {
            this.managedSystem = raidSystem;
            this.initManagementWindow(string);
            this.populatePane(string);
            bl = true;
            Utilities.setWindowLocationRelativeToComponent(this.managementWindow, component);
        }
        this.managementWindow.setVisible(true);
        return bl;
    }

    public void managementWindowToFront() {
        this.managementWindow.toFront();
    }

    public void closeManagementWindow() {
        this.managementWindow.dispose();
    }

    public RaidSystem getManagedSystem() {
        return this.managedSystem;
    }

    public String getManagementPaneType() {
        String string = "";
        if (this.managementWindow != null) {
            string = this.managementWindow.getManagementPaneType();
        }
        return string;
    }

    public boolean aSystemIsBeingManaged() {
        boolean bl = this.getManagedSystem() != null;
        return bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof TestEmail) {
            this.handleTestEmail((TestEmail)actionEvent.getSource());
            return;
        }
        if (!(actionEvent.getSource() instanceof ManagementPane)) {
            logger.warn("Action event source not a ManagementPane: " + actionEvent.getSource().getClass());
            return;
        }
        ManagementPane managementPane = (ManagementPane)actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals("APPLY")) {
            if (managementPane instanceof SetupPane) {
                boolean bl = managementPane.validateUI(this.setupDataModels);
                if (bl) {
                    this.handleSetup();
                }
            } else if (managementPane instanceof CreateArrayPane) {
                boolean bl = managementPane.validateUI(this.createDataModel);
                if (bl) {
                    this.handleCreate();
                } else {
                    logger.error("Create array validation failed");
                }
            } else if (managementPane instanceof DeleteArrayPane) {
                boolean bl = managementPane.validateUI(this.deleteDataModel);
                if (bl) {
                    this.handleDelete();
                }
            } else if (managementPane instanceof NotificationsPane) {
                boolean bl = managementPane.validateUI(this.notificationsModel);
                if (bl) {
                    this.handleNotifications();
                }
            } else if (managementPane instanceof AbstractFirstAidPane) {
                boolean bl = managementPane.validateUI(this.firstAidDataModel);
                if (bl) {
                    this.handleFirstAid();
                }
            } else if (managementPane instanceof AdvancedSlicingPane) {
                boolean bl = managementPane.validateUI(this.advancedDataModels[0]);
                if (bl) {
                    this.handleSlicing();
                }
            } else if (managementPane instanceof AdvancedExpansionPane) {
                boolean bl = managementPane.validateUI(this.advancedDataModels[1]);
                if (bl) {
                    this.handleExpansion();
                }
            } else if (managementPane instanceof AdvancedMaskingPane) {
                boolean bl = managementPane.validateUI(this.advancedDataModels[2]);
                if (bl) {
                    this.handleMasking();
                }
            } else {
                logger.error("Unknown management pane \"" + managementPane.getClass() + "\"");
            }
        } else if (string.equals("CANCEL")) {
            this.closeManagementWindow();
        } else {
            logger.error("Unknown action command \"" + string + "\" received in actionPerformed");
        }
    }

    private void populatePane(String string) {
        if (string == "setup_pane") {
            this.populateSystemSetup((ManagementSystemModel)this.setupDataModels[0]);
            this.populateNetworkSetup((ManagementNetworkModel)this.setupDataModels[1]);
            this.populateFibreSetup((ManagementFibreModel)this.setupDataModels[2]);
            this.populatePerformance((ManagementPerformanceModel)this.setupDataModels[3]);
            this.managementWindow.populateUI(string, this.setupDataModels);
        } else if (string == "create_array_pane") {
            this.populateCreateArray((CreateArrayModel)this.createDataModel);
            this.managementWindow.populateUI(string, this.createDataModel);
        } else if (string == "delete_array_pane") {
            this.populateDeleteArray((DeleteArrayModel)this.deleteDataModel);
            this.managementWindow.populateUI(string, this.deleteDataModel);
        } else if (string == "notifications_pane") {
            this.populateNotifications((NotificationsModel)this.notificationsModel);
            this.managementWindow.populateUI(string, this.notificationsModel);
        } else if (string == "first_aid") {
            this.populateFirstAid((FirstAidDataModel)this.firstAidDataModel);
            this.managementWindow.populateUI(string, this.firstAidDataModel);
        } else if (string == "advanced_pane") {
            this.populateSlicing((AdvancedSlicingModel)this.advancedDataModels[0]);
            this.populateExpansion((AdvancedExpansionModel)this.advancedDataModels[1]);
            this.populateMasking((AdvancedMaskingModel)this.advancedDataModels[2]);
            this.managementWindow.populateUI(string, this.advancedDataModels);
        }
    }

    private void populateSystemSetup(ManagementSystemModel managementSystemModel) {
        managementSystemModel.reset();
        managementSystemModel.setSystemName(this.managedSystem.getName());
        managementSystemModel.setLocation(this.managedSystem.getLocation());
        managementSystemModel.setContact(this.managedSystem.getContact());
        managementSystemModel.setXserveRAIDTime(this.managedSystem.getTime());
        MessageFactory messageFactory = this.managedSystem.getMessageFactory();
        RequestMessage requestMessage = messageFactory.newGetPropertyRequest(AcpPropertyCode.NTP_CONFIG);
        String string = ".";
        string = this.managedSystem.getNtpServerAddress();
        if (string.equals(".") || string.equals("")) {
            managementSystemModel.setTimeSynchronizationMethod(1);
            managementSystemModel.setNTPServer("");
        } else {
            managementSystemModel.setTimeSynchronizationMethod(3);
            managementSystemModel.setNTPServer(string);
        }
        boolean bl = this.managedSystem.getAudibleAlarmState() != 0;
        managementSystemModel.setEnableAudibleAlerts(bl);
        bl = this.managedSystem.getAutoRebootState() == 1;
        managementSystemModel.setRestartAutomatically(bl);
        bl = false;
        Iterator iterator = this.managedSystem.getSystemControllers().iterator();
        while (iterator.hasNext()) {
            SystemController systemController = (SystemController)iterator.next();
            if (systemController.getSnmpState() != 1 && systemController.getSnmpState() != -1) continue;
            bl = true;
            break;
        }
        managementSystemModel.setEnableSnmp(bl);
        managementSystemModel.setAdminPassword("");
        managementSystemModel.setGuestPassword("");
    }

    private void populateNetworkSetup(ManagementNetworkModel managementNetworkModel) {
        managementNetworkModel.reset();
        for (int i = 1; i <= 2; ++i) {
            NetworkInterface networkInterface = this.managedSystem.getSystemController(i).getNetworkInterface();
            ManagementNetworkModel.ManagementNetworkControllerModel managementNetworkControllerModel = i == 1 ? managementNetworkModel.getUpperControllerModel() : managementNetworkModel.getLowerControllerModel();
            managementNetworkControllerModel.reset();
            if (networkInterface.getConfigurationMethod() == 512) {
                managementNetworkControllerModel.setNetworkConfigurationMethod(1);
            } else {
                managementNetworkControllerModel.setNetworkConfigurationMethod(2);
            }
            managementNetworkControllerModel.setIPAddress(networkInterface.getAddress() + "");
            managementNetworkControllerModel.setSubnetMask(networkInterface.getSubnetMask() + "");
            managementNetworkControllerModel.setRouter(networkInterface.getGateway() + "");
            managementNetworkControllerModel.setDHCPClientID(networkInterface.getDhcpClientId());
            IPAddress[] iPAddressArray = networkInterface.getDns();
            if (iPAddressArray.length >= 1 && iPAddressArray[0] != null && !iPAddressArray[0].isAllZero()) {
                managementNetworkControllerModel.setDNS1(iPAddressArray[0] + "");
            } else {
                managementNetworkControllerModel.setDNS1("");
            }
            if (iPAddressArray.length >= 2 && iPAddressArray[1] != null && !iPAddressArray[1].isAllZero()) {
                managementNetworkControllerModel.setDNS2(iPAddressArray[1] + "");
            } else {
                managementNetworkControllerModel.setDNS2("");
            }
            if (iPAddressArray.length >= 3 && iPAddressArray[2] != null && !iPAddressArray[2].isAllZero()) {
                managementNetworkControllerModel.setDNS3(iPAddressArray[2] + "");
            } else {
                managementNetworkControllerModel.setDNS3("");
            }
            managementNetworkControllerModel.setEthernetMACAddress(networkInterface.getMacAddress());
        }
    }

    private void populateFibreSetup(ManagementFibreModel managementFibreModel) {
        managementFibreModel.reset();
        for (int i = 1; i <= 2; ++i) {
            RaidController raidController = this.managedSystem.getRaidController(i);
            FibreChannelInterface fibreChannelInterface = (FibreChannelInterface)raidController.getHostInterface(1);
            ManagementFibreModel.ManagementFibreControllerModel managementFibreControllerModel = i == 1 ? managementFibreModel.getUpperControllerModel() : managementFibreModel.getLowerControllerModel();
            managementFibreControllerModel.reset();
            managementFibreControllerModel.setWWPName(fibreChannelInterface.getWorldWidePortName());
            managementFibreControllerModel.setWWNName(fibreChannelInterface.getWorldWideNodeName());
            if (fibreChannelInterface.getSpeed() == 1) {
                managementFibreControllerModel.setSpeed(1);
            } else if (fibreChannelInterface.getSpeed() == 2) {
                managementFibreControllerModel.setSpeed(2);
            } else {
                managementFibreControllerModel.setSpeed(0);
            }
            if (fibreChannelInterface.getTopology() == 0) {
                managementFibreControllerModel.setTopology(2);
            } else if (fibreChannelInterface.getTopology() == 1) {
                managementFibreControllerModel.setTopology(1);
            } else {
                managementFibreControllerModel.setTopology(0);
            }
            managementFibreControllerModel.setHardLoopEnabled(fibreChannelInterface.getHardLoopIdEnabled() == 1);
            managementFibreControllerModel.setHardLoopID(fibreChannelInterface.getHardLoopId() + "");
        }
    }

    private void populatePerformance(ManagementPerformanceModel managementPerformanceModel) {
        managementPerformanceModel.reset();
        managementPerformanceModel.setRaidSystem(this.managedSystem);
        for (int i = 1; i <= 2; ++i) {
            ManagementPerformanceModel.ManagementPerformanceControllerModel managementPerformanceControllerModel = i == 1 ? managementPerformanceModel.getUpperPerformanceModel() : managementPerformanceModel.getLowerPerformanceModel();
            managementPerformanceControllerModel.reset();
            RaidController raidController = this.managedSystem.getRaidController(i);
            managementPerformanceControllerModel.setControllerCache(raidController.getWriteCacheState() == 1 ? 0 : 1);
            managementPerformanceControllerModel.setSyncCache(raidController.getSyncCacheState() == 1 ? 0 : 1);
            int n = 0;
            Iterator iterator = raidController.getDiskSlots().iterator();
            while (iterator.hasNext()) {
                DiskSlot diskSlot = (DiskSlot)iterator.next();
                if (!diskSlot.isPopulated() || diskSlot.getDisk().getCacheState() != 0) continue;
                n = 1;
                break;
            }
            managementPerformanceControllerModel.setDiskCache(n);
            managementPerformanceControllerModel.setSlowReadBypass(raidController.getSlowReadBypassModeState() == 1 ? 0 : 1);
            int n2 = 1 << raidController.getPrefetchSize();
            if (n2 < 8) {
                managementPerformanceControllerModel.setPrefetch(0);
                continue;
            }
            if (n2 == 8) {
                managementPerformanceControllerModel.setPrefetch(1);
                continue;
            }
            managementPerformanceControllerModel.setPrefetch(2);
        }
    }

    private void populateCreateArray(CreateArrayModel createArrayModel) {
        createArrayModel.reset();
        createArrayModel.setLevel(3);
        createArrayModel.setBackgroundInitEnabled(true);
        createArrayModel.setRaidSystem(this.managedSystem);
        createArrayModel.setDriveStates(DriveSelectionPanel.getDriveStatesFromRaidSystem(this.managedSystem));
        createArrayModel.setDriveArrays(DriveSelectionPanel.getDriveArraysFromRaidSystem(this.managedSystem));
        createArrayModel.setDriveCapacities(DriveSelectionPanel.getDriveCapacitiesFromRaidSystem(this.managedSystem));
        createArrayModel.setArrayDescriptions(ArraySelectionPanel.getArrayDescriptionsFromRaidSystem(this.managedSystem));
    }

    private void populateDeleteArray(DeleteArrayModel deleteArrayModel) {
        deleteArrayModel.reset();
        deleteArrayModel.setRaidSystem(this.managedSystem);
        deleteArrayModel.setDriveStates(DriveSelectionPanel.getDriveStatesFromRaidSystem(this.managedSystem));
        deleteArrayModel.setDriveArrays(DriveSelectionPanel.getDriveArraysFromRaidSystem(this.managedSystem));
        deleteArrayModel.setDriveCapacities(DriveSelectionPanel.getDriveCapacitiesFromRaidSystem(this.managedSystem));
        deleteArrayModel.setArrayDescriptions(ArraySelectionPanel.getArrayDescriptionsFromRaidSystem(this.managedSystem));
    }

    private void populateNotifications(NotificationsModel notificationsModel) {
        SystemController systemController = this.managedSystem.getPrimarySystemController();
        EmailNotifications emailNotifications = systemController.getEmailNotificationsData();
        notificationsModel.reset();
        if (emailNotifications != null) {
            notificationsModel.setSMTPFromEmailAddress(emailNotifications.getSMTPEmailAddress());
            notificationsModel.setSMTPServer(emailNotifications.getSMTPServer());
            if (this.isValidString(emailNotifications.getSMTPUsername()) && this.isValidString(emailNotifications.getSMTPPassword())) {
                notificationsModel.setSMTPUsername(emailNotifications.getSMTPUsername());
                notificationsModel.setSMTPPassword(emailNotifications.getSMTPPassword());
                notificationsModel.setSMTPServerRequiresAuthentication(true);
            } else {
                notificationsModel.setSMTPUsername("");
                notificationsModel.setSMTPPassword("");
                notificationsModel.setSMTPServerRequiresAuthentication(false);
            }
            notificationsModel.setEmailAddressList(emailNotifications.getEmailAddressList());
        } else {
            notificationsModel.setSMTPFromEmailAddress("");
            notificationsModel.setSMTPServer("");
            notificationsModel.setSMTPUsername("");
            notificationsModel.setSMTPPassword("");
            notificationsModel.setSMTPServerRequiresAuthentication(false);
            notificationsModel.setEmailAddressList(null);
        }
    }

    private void populateFirstAid(FirstAidDataModel firstAidDataModel) {
        firstAidDataModel.reset();
        firstAidDataModel.setRaidSystem(this.managedSystem);
        firstAidDataModel.setConditioningPriority(50);
    }

    private void populateSlicing(AdvancedSlicingModel advancedSlicingModel) {
        advancedSlicingModel.reset();
        advancedSlicingModel.setRaidSystem(this.managedSystem);
        advancedSlicingModel.setDriveStates(DriveSelectionPanel.getDriveStatesFromRaidSystem(this.managedSystem));
        advancedSlicingModel.setDriveArrays(DriveSelectionPanel.getDriveArraysFromRaidSystem(this.managedSystem));
        advancedSlicingModel.setDriveCapacities(DriveSelectionPanel.getDriveCapacitiesFromRaidSystem(this.managedSystem));
        advancedSlicingModel.setArrayDescriptions(ArraySelectionPanel.getArrayDescriptionsFromRaidSystem(this.managedSystem));
        advancedSlicingModel.setArrayLevels(ArraySelectionPanel.getArrayLevelsFromRaidSystem(this.managedSystem));
        Collection collection = this.managedSystem.getRaidSets();
        int[][] nArray = new int[collection.size()][8];
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RaidSet raidSet = (RaidSet)iterator.next();
            Collection collection2 = raidSet.getSlices();
            int[] nArray2 = new int[collection2.size()];
            Iterator iterator2 = collection2.iterator();
            while (iterator2.hasNext()) {
                Slice slice = (Slice)iterator2.next();
                nArray2[slice.getId()] = slice.getSize();
            }
            nArray[raidSet.getId() - 1] = nArray2;
        }
        advancedSlicingModel.setSliceSizes(nArray);
    }

    private void populateExpansion(AdvancedExpansionModel advancedExpansionModel) {
        advancedExpansionModel.reset();
        advancedExpansionModel.setRaidSystem(this.managedSystem);
        advancedExpansionModel.setDriveStates(DriveSelectionPanel.getDriveStatesFromRaidSystem(this.managedSystem));
        advancedExpansionModel.setDriveArrays(DriveSelectionPanel.getDriveArraysFromRaidSystem(this.managedSystem));
        advancedExpansionModel.setDriveCapacities(DriveSelectionPanel.getDriveCapacitiesFromRaidSystem(this.managedSystem));
        advancedExpansionModel.setArrayDescriptions(ArraySelectionPanel.getArrayDescriptionsFromRaidSystem(this.managedSystem));
        advancedExpansionModel.setArrayLevels(ArraySelectionPanel.getArrayLevelsFromRaidSystem(this.managedSystem));
    }

    private void populateMasking(AdvancedMaskingModel advancedMaskingModel) {
        advancedMaskingModel.reset();
        advancedMaskingModel.setControllers(2);
        for (int i = 1; i <= 2; ++i) {
            Object object;
            Iterator iterator;
            Object object2;
            RaidController raidController = this.managedSystem.getRaidController(i);
            FibreChannelInterface fibreChannelInterface = (FibreChannelInterface)raidController.getHostInterface(1);
            AdvancedMaskingModel.AdvancedMaskingControllerModel advancedMaskingControllerModel = i == 1 ? advancedMaskingModel.getUpperControllerModel() : advancedMaskingModel.getLowerControllerModel();
            advancedMaskingControllerModel.reset();
            advancedMaskingControllerModel.setLUNMaskEnabled(raidController.getLunMaskEnabled() == 1 ? Boolean.TRUE : Boolean.FALSE);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            Object object3 = raidController.getRaidSets().iterator();
            while (object3.hasNext()) {
                object2 = (RaidSet)object3.next();
                iterator = ((RaidSet)object2).getMappedSlices().iterator();
                while (iterator.hasNext()) {
                    object = (Slice)iterator.next();
                    arrayList.add(new Integer(((Slice)object).getLunId()));
                    arrayList2.add(SOMLocalizer.getSliceName((Slice)object));
                    arrayList3.add(SOMLocalizer.getSliceDescription((Slice)object));
                }
            }
            advancedMaskingControllerModel.setLUNIDs(arrayList);
            advancedMaskingControllerModel.setLUNNames(arrayList2);
            advancedMaskingControllerModel.setLUNDescriptions(arrayList3);
            object3 = new ArrayList();
            object2 = new ArrayList();
            iterator = fibreChannelInterface.getLunMaskList().iterator();
            while (iterator.hasNext()) {
                object = (LunMaskSetting)iterator.next();
                ((ArrayList)object3).add(((LunMaskSetting)object).getWorldWideName());
                BitSet bitSet = new BitSet();
                Iterator iterator2 = ((LunMaskSetting)object).getLUNMaskArray().iterator();
                while (iterator2.hasNext()) {
                    Long l = (Long)iterator2.next();
                    bitSet.set(l.intValue());
                }
                ((ArrayList)object2).add(bitSet);
            }
            advancedMaskingControllerModel.setWWPName((ArrayList)object3);
            advancedMaskingControllerModel.setLUNVisible((ArrayList)object2);
        }
    }

    private boolean isValidString(String string) {
        return string != null && string.length() > 0;
    }

    private void handleCreate() {
        CreateArrayModel createArrayModel = (CreateArrayModel)this.createDataModel;
        boolean bl = createArrayModel.getLevel() == 255;
        String string = bl ? Resources.getString("management.progress.creating.jbod") : Resources.getString("management.progress.creating");
        this.showProgressDialogAndCloseManagementWindow(string);
        if (bl) {
            this.handleCreateJbod(createArrayModel);
        } else {
            this.handleCreateRaid(createArrayModel);
        }
    }

    private void handleCreateRaid(CreateArrayModel createArrayModel) {
        String string;
        RaidController raidController = null;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(7);
        int[] nArray = createArrayModel.getDriveStates();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != -1) continue;
            if (raidController == null) {
                raidController = i < 7 ? this.managedSystem.getRaidController(1) : this.managedSystem.getRaidController(2);
            }
            Integer n = raidController.getId() == 1 ? new Integer(i + 1) : new Integer(i + 1 - 7);
            arrayList.add(n);
        }
        Integer[] integerArray = arrayList.toArray(new Integer[0]);
        switch (createArrayModel.getLevel()) {
            case 0: {
                string = "0";
                break;
            }
            case 1: {
                string = "1";
                break;
            }
            case 2: {
                string = "3";
                break;
            }
            case 3: {
                string = "5";
                break;
            }
            case 4: {
                string = "0+1";
                break;
            }
            default: {
                String string2 = "Unknown RAID level for create RAID set: \"" + createArrayModel.getLevel() + "\"";
                logger.error(string2);
                throw new Error(string2);
            }
        }
        String string3 = createArrayModel.getBackgroundInitEnabled() ? "raid-now" : "regular";
        RaidSetCreator raidSetCreator = new RaidSetCreator(raidController, integerArray, string, string3);
        new Thread(raidSetCreator).start();
    }

    private void handleCreateJbod(CreateArrayModel createArrayModel) {
        int n = -1;
        int[] nArray = createArrayModel.getDriveStates();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != -1) continue;
            n = i < 7 ? 1 : 2;
            break;
        }
        if (n != -1) {
            logger.info("Creating " + (n == 1 ? "upper" : "lower") + " JBOD");
            RequestMessage requestMessage = this.managedSystem.getMessageFactory().newJbodMaskEnableRequest(Boolean.FALSE);
            this.managedSystem.postMessageAsync(null, requestMessage, n, null);
            int n2 = n == 1 ? 17 : 34;
            new Thread(new Restarter(this.managedSystem, n2)).start();
        }
    }

    private void handleDelete() {
        DeleteArrayModel deleteArrayModel = (DeleteArrayModel)this.deleteDataModel;
        boolean bl = DriveSelectionPanel.isJbod(deleteArrayModel.getArrayIndex());
        String string = bl ? Resources.getString("management.progress.deleting.jbod") : Resources.getString("management.progress.deleting");
        this.showProgressDialogAndCloseManagementWindow(string);
        if (bl) {
            this.handleDeleteJbod(deleteArrayModel);
        } else {
            this.handleDeleteRaid(deleteArrayModel);
        }
    }

    private void handleDeleteRaid(DeleteArrayModel deleteArrayModel) {
        RequestMessage requestMessage;
        Object object;
        int n = deleteArrayModel.getArrayIndex();
        RaidSet raidSet = this.managedSystem.getRaidSet(n);
        Integer n2 = new Integer(raidSet.getNativeId());
        RaidController raidController = raidSet.getController();
        MessageFactory messageFactory = this.managedSystem.getMessageFactory();
        logger.info("Deleting RAID set " + n2);
        Collection collection = raidSet.getMappedSlices();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (Slice)iterator.next();
            if (((Slice)object).getLunId() == -1) continue;
            arrayList.add(new Integer(((Slice)object).getLunId()));
        }
        if (raidSet.getOperation() == 1) {
            logger.info("RAID set " + n + " is initializing. Stopping init before delete.");
            requestMessage = messageFactory.newRecalculateCheckDataRequest(n2, "stop");
            this.managedSystem.postMessageAsync(null, requestMessage, raidController.getId(), null);
        }
        boolean bl = raidController.getRaidSets().size() == 1;
        requestMessage = messageFactory.newDeleteArrayRequest(n2);
        this.managedSystem.postMessageAsync(null, requestMessage, raidController.getId(), null);
        object = new LunMapper(raidController);
        ((LunMapper)object).unmapLuns(arrayList);
        if (bl) {
            logger.info("RAID set " + n2 + " was the last array. Restarting RAID controller " + raidController.getId());
            requestMessage = messageFactory.newRestartRaidControllerRequest();
            this.managedSystem.postMessageAsync(null, requestMessage, raidController.getId(), null);
        }
    }

    private void handleDeleteJbod(DeleteArrayModel deleteArrayModel) {
        int n = -1;
        int n2 = deleteArrayModel.getArrayIndex();
        if (n2 == -2) {
            n = 1;
        } else if (n2 == -3) {
            n = 2;
        } else {
            logger.error("handleDeleteJbod called with no JBOD RAID set selected. arrayIndex = " + n2);
        }
        if (n != -1) {
            logger.info("Deleting " + (n == 1 ? "upper" : "lower") + " JBOD");
            RequestMessage requestMessage = this.managedSystem.getMessageFactory().newJbodMaskEnableRequest(Boolean.TRUE);
            this.managedSystem.postMessageAsync(null, requestMessage, n, null);
            int n3 = n == 1 ? 17 : 34;
            new Thread(new Restarter(this.managedSystem, n3)).start();
        }
    }

    private void handleNotifications() {
        String string;
        String string2;
        MessageFactory messageFactory = this.managedSystem.getMessageFactory();
        NotificationsModel notificationsModel = (NotificationsModel)this.notificationsModel;
        this.showProgressDialogAndCloseManagementWindow(Resources.getString("management.progress.notifications"));
        logger.info("Setting up email list");
        if (notificationsModel.getSMTPServerRequiresAuthentication()) {
            string2 = notificationsModel.getSMTPUsername();
            string = notificationsModel.getSMTPPassword();
        } else {
            string2 = "";
            string = "";
        }
        final EmailNotifications emailNotifications = new EmailNotifications(notificationsModel.getSMTPFromEmailAddress(), notificationsModel.getSMTPServer(), string2, string, notificationsModel.getEmailAddressList());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<Map> arrayList = new ArrayList<Map>();
        StringWriter stringWriter = new StringWriter();
        arrayList.add(emailNotifications.toMap());
        try {
            PropertyListUtilities.writeXML(arrayList, stringWriter);
            hashMap.put(AcpPropertyCode.EMAIL_NOTIFICATION + "", stringWriter.toString());
            RequestMessage requestMessage = messageFactory.newSetPropertiesRequest(hashMap);
            CommunicationHandler communicationHandler = new CommunicationHandler(){

                public void handleResponse(RaidSystem raidSystem, Response response, Object object) {
                    if (response.getResultCode() == 0) {
                        Iterator iterator = raidSystem.getSystemControllers().iterator();
                        while (iterator.hasNext()) {
                            SystemController systemController = (SystemController)iterator.next();
                            systemController.setEmailNotificationsData(emailNotifications);
                        }
                    }
                }
            };
            logger.info("Sending list to companion...");
            requestMessage.setTargetController(RequestMessage.Target.COMPANION);
            this.managedSystem.postMessageAsync(null, requestMessage);
            logger.info("Sending list to master...");
            requestMessage.setTargetController(null);
            this.managedSystem.postMessageAsync(null, requestMessage);
            hashMap.put(AcpPropertyCode.ACTION_FLUSH_NVRAM + "", "");
            requestMessage = messageFactory.newSetPropertiesRequest(hashMap);
            logger.info("Sending nvram sync to companion...");
            requestMessage.setTargetController(RequestMessage.Target.COMPANION);
            this.managedSystem.postMessageAsync(null, requestMessage);
            logger.info("Sending nvram sync to master...");
            requestMessage.setTargetController(null);
            this.managedSystem.postMessageAsync(communicationHandler, requestMessage);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void handleTestEmail(TestEmail testEmail) {
        MessageFactory messageFactory = this.managedSystem.getMessageFactory();
        RequestMessage requestMessage = messageFactory.newSendEmailRequest(testEmail);
        this.managedSystem.postMessageAsync(null, requestMessage, null);
    }

    private void handleSetup() {
        this.showProgressDialogAndCloseManagementWindow(Resources.getString("management.progress.settings"));
        int n = 0;
        n |= this.handleNetworkSetup(n);
        n |= this.handleSystemSetup(n);
        n |= this.handleFibreChannelSetup(n);
        n |= this.handlePerformanceSetup(n);
        Restarter restarter = new Restarter(this.managedSystem, n);
        new Thread(restarter).start();
    }

    private int handleSystemSetup(int n) {
        Object object;
        ManagementSystemModel managementSystemModel = (ManagementSystemModel)this.setupDataModels[0];
        int n2 = managementSystemModel.getTimeSynchronizationMethod();
        String string = null;
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Set set = managementSystemModel.changedKeySet();
        Object object2 = set.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            logger.info("System setup field \"" + (String)object + "\" changed");
            if (((String)object).equals("SYSTEM_NAME")) {
                try {
                    String string3 = StringUtilities.truncateStringToEncodedByteLength(managementSystemModel.getSystemName(), "UTF-8", 255);
                    hashMap.put(AcpPropertyCode.SYS_PRESENTATION_NAME + "", string3);
                    hashMap.put(AcpPropertyCode.SYS_NAME + "", string3);
                    string = StringUtilities.truncateStringToEncodedByteLength(managementSystemModel.getSystemName(), "UTF-8", 255);
                    string2 = StringUtilities.appendStringWithMaxEncodedByteLength(string3, SYSTEM_NAME_UNIQUIFIER, "UTF-8", 255);
                    bl = true;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    logger.error(unsupportedEncodingException);
                }
                continue;
            }
            if (((String)object).equals("CONTACT")) {
                hashMap.put(AcpPropertyCode.SYS_CONTACT + "", managementSystemModel.getContact());
                continue;
            }
            if (((String)object).equals("LOCATION")) {
                hashMap.put(AcpPropertyCode.SYS_LOCATION + "", managementSystemModel.getLocation());
                continue;
            }
            if (((String)object).equals("ENABLE_AUDIBLE_ALERTS")) {
                hashMap.put(AcpPropertyCode.EFFECT_FLAGS + "", managementSystemModel.getEnableAudibleAlerts() ? new Integer(0) : new Integer(1));
                continue;
            }
            if (((String)object).equals("RESTART_AUTOMATICALLY")) {
                hashMap.put(AcpPropertyCode.SERVER_MODE + "", new Integer(managementSystemModel.getRestartAutomatically() ? 1 : 0));
                continue;
            }
            if (((String)object).equals("ENABLE_SNMP")) {
                int n3 = 1;
                if (!managementSystemModel.getEnableSnmp()) {
                    n3 |= 2;
                }
                hashMap.put(AcpPropertyCode.SNMP_ACCESS_FLAGS + "", new Integer(n3));
                continue;
            }
            if (((String)object).equals("GUEST_PASSWORD")) {
                try {
                    hashMap.put(AcpPropertyCode.SYS_GUEST_PASSWORD + "", managementSystemModel.getGuestPassword());
                    String string4 = Utilities.crypt(managementSystemModel.getGuestPassword());
                    this.managedSystem.setMonitoringPassword(string4);
                }
                catch (Exception exception) {}
                continue;
            }
            if (!((String)object).equals("ADMIN_PASSWORD")) continue;
            hashMap.put(AcpPropertyCode.SYS_PASSWORD_RW + "", managementSystemModel.getAdminPassword());
            if (!this.managedSystem.getManagementPasswordSaved()) continue;
            try {
                String string5 = Utilities.crypt(managementSystemModel.getAdminPassword());
                this.managedSystem.setManagementPassword(string5);
            }
            catch (Exception exception) {
                logger.error(exception);
            }
        }
        object = (HashMap)hashMap.clone();
        if (string != null && string2 != null) {
            hashMap.put(AcpPropertyCode.SYS_PRESENTATION_NAME + "", string);
            hashMap.put(AcpPropertyCode.SYS_NAME + "", string2);
            bl2 = true;
        }
        if (((HashMap)object).size() > 0) {
            if ((n & 4) == 0) {
                n = bl ? (n |= 4) : (n |= 0x40);
            }
            object2 = this.managedSystem.getMessageFactory().newSetPropertiesRequest((Map)object);
            logger.info("Updating system properties for top system controller");
            this.managedSystem.postMessageAsync(null, (RequestMessage)object2, 1, null);
        }
        if (hashMap.size() > 0) {
            if ((n & 8) == 0) {
                n = bl2 ? (n |= 8) : (n |= 0x80);
            }
            object2 = this.managedSystem.getMessageFactory().newSetPropertiesRequest(hashMap);
            logger.info("Updating system properties for bottom system controller");
            this.managedSystem.postMessageAsync(null, (RequestMessage)object2, 2, null);
        }
        if (n2 == 2) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd G 'at' HH:mm z");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            String string6 = simpleDateFormat.format(new Date());
            object2 = this.managedSystem.getMessageFactory().newSetTimeRequest(null);
            logger.info("Updating top system controller RTC to " + string6);
            this.managedSystem.postMessageAsync(null, (RequestMessage)object2, 1, null);
            logger.info("Updating bottom system controller RTC to " + string6);
            this.managedSystem.postMessageAsync(null, (RequestMessage)object2, 2, null);
            object2 = this.managedSystem.getMessageFactory().newSetPropertyRequest(AcpPropertyCode.NTP_CONFIG.toString(), ".");
            this.managedSystem.postMessageAsync(null, (RequestMessage)object2, 1, null);
            this.managedSystem.postMessageAsync(null, (RequestMessage)object2, 2, null);
        } else if (n2 == 3) {
            object2 = this.managedSystem.getMessageFactory().newSetPropertyRequest(AcpPropertyCode.NTP_CONFIG.toString(), managementSystemModel.getNTPServer());
            this.managedSystem.postMessageAsync(null, (RequestMessage)object2, 1, null);
            this.managedSystem.postMessageAsync(null, (RequestMessage)object2, 2, null);
        } else {
            object2 = this.managedSystem.getMessageFactory().newSetPropertyRequest(AcpPropertyCode.NTP_CONFIG.toString(), ".");
            this.managedSystem.postMessageAsync(null, (RequestMessage)object2, 1, null);
            this.managedSystem.postMessageAsync(null, (RequestMessage)object2, 2, null);
        }
        return n;
    }

    private int handleNetworkSetup(int n) {
        ManagementNetworkModel managementNetworkModel = (ManagementNetworkModel)this.setupDataModels[1];
        for (int i = 1; i <= 2; ++i) {
            int n2;
            ManagementNetworkModel.ManagementNetworkControllerModel managementNetworkControllerModel = i == 1 ? managementNetworkModel.getUpperControllerModel() : managementNetworkModel.getLowerControllerModel();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            int n3 = managementNetworkControllerModel.getNetworkConfigurationMethod();
            if (managementNetworkControllerModel.fieldChanged("NETWORK_CONFIGURATION_METHOD")) {
                n2 = n3 == 1 ? 768 : (n3 == 2 ? 1024 : 768);
                hashMap.put(AcpPropertyCode.LAN_CONFIGURE_VIA + "", new Integer(n2));
            }
            if (n3 == 2) {
                n2 = 0;
                if (managementNetworkControllerModel.fieldChanged("IP_ADDRESS")) {
                    hashMap.put(AcpPropertyCode.LAN_IP_ADDRESS + "", ManagementNetworkModel.translateAddress(managementNetworkControllerModel.getIPAddress()));
                    n2 = 1;
                }
                if (managementNetworkControllerModel.fieldChanged("SUBNET_MASK")) {
                    hashMap.put(AcpPropertyCode.LAN_SUBNET_MASK + "", ManagementNetworkModel.translateAddress(managementNetworkControllerModel.getSubnetMask()));
                    n2 = 1;
                }
                if (managementNetworkControllerModel.fieldChanged("ROUTER_ADDRESS")) {
                    hashMap.put(AcpPropertyCode.LAN_ROUTER_ADDRESS + "", ManagementNetworkModel.translateAddress(managementNetworkControllerModel.getRouter()));
                    n2 = 1;
                }
                if (n2 != 0) {
                    hashMap.put(AcpPropertyCode.WAN_DNS_1 + "", ManagementNetworkModel.translateAddress(managementNetworkControllerModel.getDNS1()));
                    hashMap.put(AcpPropertyCode.WAN_DNS_2 + "", ManagementNetworkModel.translateAddress(managementNetworkControllerModel.getDNS2()));
                    hashMap.put(AcpPropertyCode.WAN_DNS_3 + "", ManagementNetworkModel.translateAddress(managementNetworkControllerModel.getDNS3()));
                }
            }
            if (managementNetworkControllerModel.fieldChanged("DNS_1")) {
                hashMap.put(AcpPropertyCode.WAN_DNS_1 + "", ManagementNetworkModel.translateAddress(managementNetworkControllerModel.getDNS1()));
            }
            if (managementNetworkControllerModel.fieldChanged("DNS_2")) {
                hashMap.put(AcpPropertyCode.WAN_DNS_2 + "", ManagementNetworkModel.translateAddress(managementNetworkControllerModel.getDNS2()));
            }
            if (managementNetworkControllerModel.fieldChanged("DNS_3")) {
                hashMap.put(AcpPropertyCode.WAN_DNS_3 + "", ManagementNetworkModel.translateAddress(managementNetworkControllerModel.getDNS3()));
            }
            if (managementNetworkControllerModel.fieldChanged("DHCP_CLIENT_ID")) {
                hashMap.put(AcpPropertyCode.LAN_DHCP_CLIENT_ID + "", managementNetworkControllerModel.getDHCPClientID());
            }
            if (hashMap.size() <= 0) continue;
            RequestMessage requestMessage = this.managedSystem.getMessageFactory().newSetPropertiesRequest(hashMap);
            logger.info("Updating network properties for " + (i == 1 ? "top" : "bottom") + " system controller");
            logger.info("Network properties: " + hashMap);
            this.managedSystem.postMessageAsync(null, requestMessage, i, null);
            if (i == 1) {
                n |= 4;
                continue;
            }
            n |= 8;
        }
        return n;
    }

    private int handleFibreChannelSetup(int n) {
        ManagementFibreModel managementFibreModel = (ManagementFibreModel)this.setupDataModels[2];
        for (int i = 1; i <= 2; ++i) {
            boolean bl = false;
            ManagementFibreModel.ManagementFibreControllerModel managementFibreControllerModel = i == 1 ? managementFibreModel.getUpperControllerModel() : managementFibreModel.getLowerControllerModel();
            HashMap hashMap = new HashMap();
            Set set = managementFibreControllerModel.changedKeySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!string.equals("WORLD_WIDE_PORT_NAME") && !string.equals("WORLD_WIDE_NODE_NAME")) {
                    RequestMessage requestMessage;
                    String string2;
                    if (string.equals("SPEED")) {
                        int n2 = managementFibreControllerModel.getSpeed();
                        string2 = n2 == 2 ? "2Gb/sec" : (n2 == 1 ? "1Gb/sec" : "auto-negotiated");
                        requestMessage = this.managedSystem.getMessageFactory().newSetFibreChannelSpeedRequest(new Integer(1), string2);
                        logger.info("Updating fibre speed properties for " + (i == 1 ? "top" : "bottom") + " raid controller");
                        this.managedSystem.postMessageAsync(null, requestMessage, i, null);
                        bl = true;
                    } else if (string.equals("TOPOLOGY")) {
                        int n3 = managementFibreControllerModel.getTopology();
                        string2 = n3 == 1 ? "point-to-point" : (n3 == 2 ? "arbitrated-loop" : "auto");
                        requestMessage = this.managedSystem.getMessageFactory().newSetFibreChannelTopologyRequest(string2);
                        logger.info("Updating fibre topology properties for " + (i == 1 ? "top" : "bottom") + " raid controller");
                        this.managedSystem.postMessageAsync(null, requestMessage, i, null);
                        bl = true;
                    } else if (string.equals("HARD_LOOP_ID_ENABLED")) {
                        boolean bl2 = managementFibreControllerModel.getHardLoopEnabled();
                        requestMessage = this.managedSystem.getMessageFactory().newSetFibreChannelHardLoopIDEnableRequest(bl2);
                        logger.info(bl2 ? "Enabling" : "Disabling fibre hard loop ID for " + (i == 1 ? "top" : "bottom") + " raid controller");
                        this.managedSystem.postMessageAsync(null, requestMessage, i, null);
                        bl = true;
                    } else if (string.equals("HARD_LOOP_ID")) {
                        Integer n4 = new Integer(managementFibreControllerModel.getHardLoopID());
                        requestMessage = this.managedSystem.getMessageFactory().newSetFibreChannelHardLoopIDRequest(n4);
                        logger.info("Setting fibre hard loop ID = " + n4 + " for " + (i == 1 ? "top" : "bottom") + " raid controller");
                        this.managedSystem.postMessageAsync(null, requestMessage, i, null);
                        bl = true;
                    }
                }
                if (!bl) continue;
                n |= i == 1 ? 16 : 32;
                n |= i == 1 ? 1 : 2;
            }
        }
        return n;
    }

    private int handlePerformanceSetup(int n) {
        boolean bl;
        boolean bl2;
        ManagementPerformanceModel managementPerformanceModel = (ManagementPerformanceModel)this.setupDataModels[3];
        try {
            bl2 = OperationManager.isSupported(this.managedSystem, OperationManager.OP_CONFIGURE_SYNC_CACHE);
        }
        catch (Exception exception) {
            bl2 = true;
            logger.error(exception);
        }
        try {
            bl = OperationManager.isSupported(this.managedSystem, OperationManager.OP_CONFIGURE_SLOW_READ_BYPASS);
        }
        catch (Exception exception) {
            bl = true;
            logger.error(exception);
        }
        for (int i = 1; i <= 2; ++i) {
            ManagementPerformanceModel.ManagementPerformanceControllerModel managementPerformanceControllerModel = i == 1 ? managementPerformanceModel.getUpperPerformanceModel() : managementPerformanceModel.getLowerPerformanceModel();
            Set set = managementPerformanceControllerModel.changedKeySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                RequestMessage requestMessage;
                String string = (String)iterator.next();
                if (string.equals("CONTROLLER_CACHE")) {
                    logger.info("Changing Controller cache setting for " + (i == 1 ? "top" : "bottom") + " RAID controller");
                    requestMessage = this.managedSystem.getMessageFactory().newSetRAIDCacheControlRequest(managementPerformanceControllerModel.getControllerCache() == 0);
                    this.managedSystem.postMessageAsync(null, requestMessage, i, null);
                    continue;
                }
                if (bl2 && string.equals("SYNC_CACHE")) {
                    logger.info((managementPerformanceControllerModel.getSyncCache() == 0 ? "Enabling " : "Disabling ") + "sync cache setting for " + (i == 1 ? "top" : "bottom") + " RAID controller");
                    requestMessage = this.managedSystem.getMessageFactory().newSetSynchronizeCacheRequest(managementPerformanceControllerModel.getSyncCache() == 0 ? 1 : 2);
                    this.managedSystem.postMessageAsync(null, requestMessage, i, null);
                    n |= i == 1 ? 16 : 32;
                    continue;
                }
                if (bl && string.equals("SLOW_READ_BYPASS")) {
                    logger.info((managementPerformanceControllerModel.getSlowReadBypass() == 0 ? "Enabling " : "Disabling ") + "slow read bypass mode for " + (i == 1 ? "top" : "bottom") + " RAID controller");
                    requestMessage = this.managedSystem.getMessageFactory().newSlowReadBypassModeControlRequest(managementPerformanceControllerModel.getSlowReadBypass() == 0);
                    this.managedSystem.postMessageAsync(null, requestMessage, i, null);
                    continue;
                }
                if (!string.equals("PREFETCH")) continue;
                int[] nArray = new int[]{0, 3, 7};
                logger.info("Changing Controller prefetch setting for " + (i == 1 ? "top" : "bottom") + " RAID controller");
                requestMessage = this.managedSystem.getMessageFactory().newSetRAIDPrefetchSizeRequest(nArray[managementPerformanceControllerModel.getPrefetch()]);
                this.managedSystem.postMessageAsync(null, requestMessage, i, null);
            }
            boolean bl3 = managementPerformanceControllerModel.getDiskCache() == 0;
            this.setDriveCacheForController(i, bl3);
        }
        return n;
    }

    private boolean setDriveCacheForController(int n, boolean bl) {
        boolean bl2;
        try {
            bl2 = OperationManager.isSupported(this.managedSystem, OperationManager.OP_CONFIGURE_DISK_CACHE);
        }
        catch (Exception exception) {
            bl2 = true;
            logger.error(exception);
        }
        if (bl2) {
            boolean bl3 = this.managedSystem.supportsGlobalDriveCacheFeature();
            if (bl3) {
                logger.info("1.5 or later firmware: " + (bl ? "Enabling" : "Disabling") + " all drive caches on controller " + n);
                Integer n2 = bl ? new Integer(127) : new Integer(0);
                RequestMessage requestMessage = this.managedSystem.getMessageFactory().newSetPropertyRequest(AcpPropertyCode.DRIVE_CACHE_FLAGS.fourCharCode(), n2);
                this.managedSystem.postMessageAsync(null, requestMessage, n, null);
            } else {
                RaidController raidController = this.managedSystem.getRaidController(n);
                Iterator iterator = raidController.getDiskSlots().iterator();
                while (iterator.hasNext()) {
                    DiskSlot diskSlot = (DiskSlot)iterator.next();
                    if (!diskSlot.isPopulated()) continue;
                    logger.info("Pre-1.5 firmware: " + (bl ? "Enabling" : "Disabling") + " disk " + diskSlot.getDisk().getId() + " cache on controller " + n);
                    RequestMessage requestMessage = this.managedSystem.getMessageFactory().newSetDriveCacheControlRequest(diskSlot.getDisk().getNativeId(), bl);
                    this.managedSystem.postMessageAsync(null, requestMessage, n, null);
                }
            }
        }
        return bl2;
    }

    private void handleFirstAid() {
        RequestMessage requestMessage;
        String string;
        int n;
        int n2;
        Object object;
        Object object2;
        FirstAidDataModel firstAidDataModel = (FirstAidDataModel)this.firstAidDataModel;
        int n3 = firstAidDataModel.getOperation();
        MessageFactory messageFactory = this.managedSystem.getMessageFactory();
        if (n3 == 0 || n3 == 1 || n3 == 2 || n3 == 3 || n3 == 5) {
            object2 = this.managedSystem.getRaidSet(firstAidDataModel.getArrayID());
            object = ((RaidSet)object2).getController();
            n2 = ((RaidSet)object2).getNativeId();
            n = ((RaidController)object).getId();
        } else {
            n2 = 0;
            n = firstAidDataModel.getControllerID();
        }
        if (n3 == 0) {
            logger.info("Verify RAID set " + n2 + " parity on RAID controller " + n);
            string = Resources.getString("management.progress.verifying");
            requestMessage = messageFactory.newVerifyCheckDataRequest(new Integer(n2), "start");
        } else if (n3 == 1) {
            logger.info("Rebuild RAID set " + n2 + " parity on RAID controller " + n);
            string = Resources.getString("management.progress.rebuilding");
            requestMessage = messageFactory.newRecalculateCheckDataRequest(new Integer(n2), "start");
        } else if (n3 == 2) {
            logger.info("Start background read/write scan on RAID controller " + n + ", RAID set " + n2);
            string = Resources.getString("management.progress.bgrw.starting");
            this.showProgressDialogAndCloseManagementWindow(string);
            requestMessage = messageFactory.newSetBackgroundReadWriteScanThresholdRequest(new Integer(firstAidDataModel.getConditioningPriority()));
            this.managedSystem.postMessageAsync(null, requestMessage, n, null);
            requestMessage = messageFactory.newBackgroundReadWriteScanRequest(n2, 1);
        } else if (n3 == 3) {
            logger.info("Pause background read/write scan on RAID controller " + n + ", RAID set " + n2);
            string = Resources.getString("management.progress.bgrw.pausing");
            requestMessage = messageFactory.newBackgroundReadWriteScanRequest(n2, 3);
        } else if (n3 == 4) {
            logger.info("Resume background read/write scan on RAID controller " + n + ", RAID set " + n2);
            string = Resources.getString("management.progress.bgrw.resuming");
            requestMessage = messageFactory.newBackgroundReadWriteScanRequest(n2, 1);
        } else if (n3 == 5) {
            logger.info("Stop background read/write scan on RAID controller " + n + ", RAID set " + n2);
            string = Resources.getString("management.progress.bgrw.stopping");
            requestMessage = messageFactory.newBackgroundReadWriteScanRequest(n2, 2);
        } else if (n3 == 6) {
            object2 = this.managedSystem.getDisk(firstAidDataModel.getDriveID());
            logger.info("Clearing metadata on disk " + ((Disk)object2).getNativeId() + ", RAID controller " + n);
            string = Resources.getString("management.progress.manageOrphans");
            requestMessage = messageFactory.newDeleteBrokenRaidMemberRequest(((Disk)object2).getNativeId());
        } else if (n3 == 7) {
            logger.info("Recognize array on RAID controller " + n);
            object2 = new ManagementProgressSheet(Resources.getString("management.progress.recognizeArray"));
            object = new AquaAlert((JPanel)object2, null, null, null);
            new Thread(new RecognizeArrayAction(this.managedSystem, n, (AquaAlert)object)).start();
            ((AquaAlert)object).showSheet(this.managementWindow, new AquaAlertListener((ManagementProgressSheet)object2){
                private final /* synthetic */ ManagementProgressSheet val$progressPanel;
                {
                    this.val$progressPanel = managementProgressSheet;
                }

                public void aquaAlertDismissed(int n, Object object) {
                    this.val$progressPanel.stopAnimation();
                    ManagementController.this.closeManagementWindow();
                }

                public void aquaAlertSheetVisible(Object object) {
                    this.val$progressPanel.startAnimation();
                }

                public boolean allowAquaAlertToBeDismissed(int n, Object object) {
                    return true;
                }

                public void aquaAlertWillBeShown(Object object) {
                }

                public void aquaAlertResized(Object object) {
                }
            }, null);
            string = null;
            requestMessage = null;
        } else {
            string = StringUtilities.replaceAll(Resources.getString("management.progress.error"), "{window}", Resources.getString("firstAid"));
            string = StringUtilities.replaceAll(string, "{code}", n3 + "");
            logger.error(string);
            requestMessage = null;
        }
        if (string != null) {
            this.showProgressDialogAndCloseManagementWindow(string);
        }
        if (requestMessage != null) {
            this.managedSystem.postMessageAsync(null, requestMessage, n, null);
        }
    }

    private void handleSlicing() {
        AdvancedSlicingModel advancedSlicingModel = (AdvancedSlicingModel)this.advancedDataModels[0];
        RaidSet raidSet = this.managedSystem.getRaidSet(advancedSlicingModel.getArrayIndex());
        String string = Resources.getString("management.progress.slicing");
        ManagementProgressSheet managementProgressSheet = new ManagementProgressSheet(string);
        final AquaAlert aquaAlert = new AquaAlert(managementProgressSheet, null, null, null);
        aquaAlert.showSheet(this.managementWindow, null, null);
        managementProgressSheet.startAnimation();
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    Thread.sleep(4000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                aquaAlert.dismissSheetOrDialog(1);
                ManagementController.this.closeManagementWindow();
            }
        };
        Slicer slicer = new Slicer(this.managedSystem, raidSet, advancedSlicingModel.getSliceCount(), new InvocationEvent((Object)this, runnable));
        new Thread(slicer).start();
    }

    private void handleExpansion() {
        AdvancedExpansionModel advancedExpansionModel = (AdvancedExpansionModel)this.advancedDataModels[1];
        int n = advancedExpansionModel.getArrayIndex();
        RaidSet raidSet = this.managedSystem.getRaidSet(n);
        Integer n2 = new Integer(raidSet.getNativeId());
        RaidController raidController = raidSet.getController();
        MessageFactory messageFactory = this.managedSystem.getMessageFactory();
        this.showProgressDialogAndCloseManagementWindow(Resources.getString("management.progress.expanding"));
        int n3 = -1;
        int n4 = 0;
        int[] nArray = advancedExpansionModel.getDriveStates();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != -1) continue;
            ++n4;
        }
        logger.info("Expanding RAID set " + n2 + " with " + n4 + " disks on RAID controller " + raidController.getId());
        if (n4 > 0) {
            RequestMessage requestMessage = messageFactory.newExpandArrayRequest(n2, new Integer(n4));
            this.managedSystem.postMessageAsync(null, requestMessage, raidController.getId(), null);
        }
    }

    private void handleMasking() {
        AdvancedMaskingModel advancedMaskingModel = (AdvancedMaskingModel)this.advancedDataModels[2];
        int n = 0;
        this.showProgressDialogAndCloseManagementWindow(Resources.getString("management.progress.masking"));
        for (int i = 1; i <= 2; ++i) {
            RequestMessage requestMessage;
            Object object;
            AdvancedMaskingModel.AdvancedMaskingControllerModel advancedMaskingControllerModel = i == 1 ? advancedMaskingModel.getUpperControllerModel() : advancedMaskingModel.getLowerControllerModel();
            HashMap hashMap = new HashMap();
            Set set = advancedMaskingControllerModel.changedKeySet();
            boolean bl = false;
            boolean bl2 = false;
            Object object2 = set.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                if (((String)object).equals("ENABLED")) {
                    boolean bl3 = advancedMaskingControllerModel.getLUNMaskEnabled();
                    requestMessage = this.managedSystem.getMessageFactory().newSetFibreChannelLUNMaskEnableRequest(bl3);
                    logger.info(bl3 ? "Enabling" : "Disabling LUN Masking for " + (i == 1 ? "top" : "bottom") + " RAID controller");
                    this.managedSystem.postMessageAsync(null, requestMessage, i, null);
                    bl = true;
                    continue;
                }
                if (((String)object).equals("WORLD_WIDE_NAME")) {
                    bl2 = true;
                    bl = true;
                    continue;
                }
                if (!((String)object).equals("LUN_VISIBLE")) continue;
                bl2 = true;
                bl = true;
            }
            if (bl2) {
                logger.info("LUN mask settings changed:");
                object2 = advancedMaskingControllerModel.getWWPName();
                object = advancedMaskingControllerModel.getLUNVisible();
                ArrayList<Map> arrayList = new ArrayList<Map>();
                if (((ArrayList)object2).size() != ((ArrayList)object).size()) {
                    throw new RuntimeException("wwns.size() != visible.size()");
                }
                int n2 = 1;
                for (int j = 0; j < ((ArrayList)object2).size(); ++j) {
                    String string = (String)((ArrayList)object2).get(j);
                    if (string.length() <= 0) continue;
                    BitSet bitSet = (BitSet)((ArrayList)object).get(j);
                    ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                    for (int k = 0; k < 128; ++k) {
                        if (!bitSet.get(k)) continue;
                        arrayList2.add(new Integer(k));
                    }
                    logger.info("     WWPN " + string + " views " + arrayList2);
                    LunMaskSetting lunMaskSetting = new LunMaskSetting(n2++, string, arrayList2);
                    arrayList.add(lunMaskSetting.toMap());
                }
                requestMessage = this.managedSystem.getMessageFactory().newSetFibreChannelLUNMaskRequest(arrayList);
                logger.info("Changing LUN Masking for " + (i == 1 ? "top" : "bottom") + " RAID controller");
                this.managedSystem.postMessageAsync(null, requestMessage, i, null);
            }
            if (!bl) continue;
            n |= i == 1 ? 16 : 32;
            n |= i == 1 ? 1 : 2;
        }
        Restarter restarter = new Restarter(this.managedSystem, n);
        new Thread(restarter).start();
    }

    private void setDriveCacheForRaidSet(RaidSet raidSet, boolean bl) {
        Disk[] diskArray = raidSet.getMembers().toArray(new Disk[0]);
        RaidController raidController = raidSet.getController();
        for (int i = 0; i < diskArray.length; ++i) {
            RequestMessage requestMessage = this.managedSystem.getMessageFactory().newSetDriveCacheControlRequest(diskArray[i].getNativeId(), bl);
            logger.info("Changing drive cache setting for " + (raidController.getId() == 1 ? "top" : "bottom") + " RAID controller, drive = " + i);
            this.managedSystem.postMessageAsync(null, requestMessage, raidController.getId() == 1 ? 1 : 2, null);
        }
    }

    private void showProgressDialogAndCloseManagementWindow(String string) {
        final ManagementProgressSheet managementProgressSheet = new ManagementProgressSheet(string);
        final AquaAlert aquaAlert = new AquaAlert(managementProgressSheet, null, null, null);
        aquaAlert.showSheet(this.managementWindow, new AquaAlertListener(){

            public void aquaAlertWillBeShown(Object object) {
            }

            public void aquaAlertResized(Object object) {
            }

            public void aquaAlertDismissed(int n, Object object) {
                ManagementController.this.closeManagementWindow();
            }

            public void aquaAlertSheetVisible(Object object) {
                managementProgressSheet.startAnimation();
                Timer timer = new Timer(4000, new ActionListener(this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        4.access$000(this.this$1).stopAnimation();
                        4.access$100(this.this$1).dismissSheetOrDialog(1);
                    }
                });
                timer.setRepeats(false);
                timer.start();
            }

            public boolean allowAquaAlertToBeDismissed(int n, Object object) {
                return true;
            }

            static /* synthetic */ ManagementProgressSheet access$000(4 var0) {
                return var0.managementProgressSheet;
            }

            static /* synthetic */ AquaAlert access$100(4 var0) {
                return var0.aquaAlert;
            }
        }, null);
    }

    private boolean validatePane(ManagementPane managementPane, DataModel[] dataModelArray) {
        return managementPane.validateUI(dataModelArray);
    }

    private void initManagementWindow(String string) {
        if (this.managementWindow == null) {
            this.managementWindow = new ManagementWindow(this.managedSystem.getName() + Resources.getString("managementController.windowTitleSeparator") + this.managedSystem.getPrimaryHostAddress(), string);
            this.managementWindow.setJMenuBar(RaidAdmin.newMenuBar(1));
            if (string == null) {
                throw new NullPointerException("paneType may not be null when initializing the management window.");
            }
            if (string.equals("create_array_pane")) {
                this.managementWindow.addActionListener(this, "create_array_pane");
            } else if (string.equals("delete_array_pane")) {
                this.managementWindow.addActionListener(this, "delete_array_pane");
            } else if (string.equals("setup_pane")) {
                this.managementWindow.addActionListener(this, "setup_pane");
            } else if (string.equals("notifications_pane")) {
                this.managementWindow.addActionListener(this, "notifications_pane");
            } else if (string.equals("first_aid")) {
                this.managementWindow.addActionListener(this, "first_aid");
            } else if (string.equals("advanced_pane")) {
                this.managementWindow.addActionListener(this, "advanced_pane");
            } else {
                throw new IllegalArgumentException("An illegal paneType was passed in.");
            }
            this.managementWindow.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    ManagementController.this.managementWindow = null;
                    ManagementController.this.managedSystem = null;
                }
            });
        } else {
            logger.error("Attempt to init management window when it already exists");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class LunMapRepairer
    implements Runnable {
        private RaidSystem system;
        private int[] controllerIDs;
        private ActiveEvent completionEvent;
        private static final Logger logger = Logger.getLogger(class$com$apple$xsr$ManagementController$LunMapRepairer == null ? (class$com$apple$xsr$ManagementController$LunMapRepairer = ManagementController.class$("com.apple.xsr.ManagementController$LunMapRepairer")) : class$com$apple$xsr$ManagementController$LunMapRepairer);

        public LunMapRepairer(RaidSystem raidSystem) {
            this(raidSystem, new int[]{1, 2}, null);
        }

        public LunMapRepairer(RaidSystem raidSystem, int[] nArray) {
            this(raidSystem, nArray, null);
        }

        public LunMapRepairer(RaidSystem raidSystem, int[] nArray, ActiveEvent activeEvent) {
            if (raidSystem == null) {
                throw new NullPointerException("RaidSystem cannot be null");
            }
            if (nArray == null) {
                throw new NullPointerException("controllerIDs cannot be null");
            }
            this.system = raidSystem;
            this.controllerIDs = nArray;
            this.completionEvent = activeEvent;
        }

        public void run() {
            int n;
            int n2 = 0;
            boolean[] blArray = new boolean[this.controllerIDs.length];
            for (n = 0; n < this.controllerIDs.length; ++n) {
                blArray[n] = LunMapRepairer.repair(this.system, this.controllerIDs[n]);
            }
            for (n = 0; n < blArray.length; ++n) {
                if (!blArray[n]) continue;
                if (this.controllerIDs[n] == 1) {
                    n2 |= 0x10;
                    n2 |= 1;
                    continue;
                }
                if (this.controllerIDs[n] != 2) continue;
                n2 |= 0x20;
                n2 |= 2;
            }
            new Restarter(this.system, n2, true, null).restart();
            if (this.completionEvent != null) {
                this.completionEvent.dispatch();
            }
        }

        public static boolean repair(RaidSystem raidSystem, int n) {
            int n2;
            RaidController raidController = raidSystem.getRaidController(n);
            ArrayList arrayList = new ArrayList();
            int n3 = 0;
            boolean bl = false;
            if (raidSystem == null) {
                throw new NullPointerException("RaidSystem cannot be null");
            }
            if (n != 1 && n != 2) {
                throw new IllegalArgumentException("invalid controller ID (" + n + ")");
            }
            Iterator iterator = raidController.getRaidSets().iterator();
            while (iterator.hasNext()) {
                RaidSet raidSet = (RaidSet)iterator.next();
                arrayList.addAll(raidSet.getLiveSlices());
            }
            if (arrayList.size() > 0) {
                bl = true;
            }
            if (arrayList.size() > 8) {
                logger.warn("Insufficient LUN's available to map all slices (slice count = " + arrayList.size() + ")");
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                n2 = LunMapper.map((Slice)iterator.next(), n3++);
                if (n3 <= 7) continue;
            }
            while (n3 <= 7) {
                n2 = LunMapper.unmap(raidController, n3++);
            }
            return bl;
        }
    }

    public static class LunMapper {
        private RaidController controller;
        private static final Logger logger = Logger.getLogger(class$com$apple$xsr$ManagementController$LunMapper == null ? (class$com$apple$xsr$ManagementController$LunMapper = ManagementController.class$("com.apple.xsr.ManagementController$LunMapper")) : class$com$apple$xsr$ManagementController$LunMapper);

        public LunMapper(RaidController raidController) {
            if (raidController == null) {
                throw new NullPointerException("controller cannot be null");
            }
            this.controller = raidController;
        }

        public static int map(Slice slice, int n) {
            int n2;
            if (slice == null) {
                throw new NullPointerException("slice cannot be null");
            }
            RaidSet raidSet = slice.getRaidSet();
            if (raidSet == null) {
                throw new IllegalArgumentException("invalid slice (no parent RAID set): " + slice);
            }
            RaidController raidController = raidSet.getController();
            RaidSystem raidSystem = raidController.getRaidSystem();
            MessageFactory messageFactory = raidSystem.getMessageFactory();
            int n3 = raidSystem.translateSliceId(slice.getNativeId(), raidController.getId(), 0);
            n = raidSystem.translateLunId(n, raidController.getId(), 0);
            RequestMessage requestMessage = messageFactory.newLUNAssignmentRequest(new Integer(raidSet.getNativeId()), new Integer(n3), new Integer(n));
            try {
                Response response = raidSystem.postMessage(requestMessage, raidController.getId());
                n2 = response.getResultCode();
                if (n2 == 0) {
                    logger.info("Mapped RAID set " + raidSet.getNativeId() + ", slice " + slice.getNativeId() + " to LUN " + n);
                } else {
                    logger.error("Result code " + n2 + " attempting to map RAID set " + raidSet.getNativeId() + ", slice " + slice.getNativeId() + " to LUN " + n);
                }
            }
            catch (IOException iOException) {
                n2 = -102;
                logger.error("Error sending LUN assignment request. " + iOException);
            }
            return n2;
        }

        public static int unmap(RaidController raidController, int n) {
            int n2;
            block5: {
                Integer n3 = new Integer(15);
                RaidSystem raidSystem = raidController.getRaidSystem();
                MessageFactory messageFactory = raidSystem.getMessageFactory();
                if (n >= 0 && n <= 7) {
                    n = raidSystem.translateLunId(n, raidController.getId(), 0);
                    RequestMessage requestMessage = messageFactory.newLUNAssignmentRequest(n3, n3, new Integer(n));
                    try {
                        Response response = raidSystem.postMessage(requestMessage, raidController.getId());
                        n2 = response.getResultCode();
                        if (n2 == 0) {
                            logger.info("Unmapped LUN " + n);
                            break block5;
                        }
                        logger.error("Result code " + n2 + " attempting to unmap LUN " + n);
                    }
                    catch (IOException iOException) {
                        n2 = -102;
                        logger.error("Error sending LUN assignment request. " + iOException);
                    }
                } else {
                    n2 = -100;
                    logger.warn("Attempt to unmap invalid LUN ID (" + n + ")");
                }
            }
            return n2;
        }

        public static Integer nextAvailableLun(RaidController raidController) {
            Integer n = null;
            Collection collection = raidController.getUnmappedLuns();
            if (!collection.isEmpty()) {
                n = (Integer)collection.iterator().next();
            }
            return n;
        }

        public void mapLunsToSlices(Collection collection) {
            LunMapper.mapLunsToSlices(this.controller, collection);
        }

        public static void mapLunsToSlices(RaidController raidController, Collection collection) {
            if (collection.size() > 0) {
                Collection collection2 = raidController.getUnmappedLuns();
                if (collection2.size() < collection.size()) {
                    logger.error("Insufficient LUNs available (" + collection2.size() + ") to map all slices (" + collection.size() + ")");
                }
                Iterator iterator = collection2.iterator();
                Iterator iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    Integer n;
                    Slice slice = (Slice)iterator2.next();
                    Integer n2 = n = iterator.hasNext() ? (Integer)iterator.next() : null;
                    if (n != null) {
                        LunMapper.map(slice, n);
                        continue;
                    }
                    logger.error("No unmapped LUN's available for slice " + slice);
                    break;
                }
            }
        }

        public void unmapLuns(Collection collection) {
            LunMapper.unmapLuns(this.controller, collection);
        }

        public static void unmapLuns(RaidController raidController, Collection collection) {
            if (collection != null && collection.size() > 0) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    LunMapper.unmap(raidController, n);
                }
            }
        }

        public void unmapLunsFromSlices(Collection collection) {
            LunMapper.unmapLunsFromSlices(this.controller, collection);
        }

        public static void unmapLunsFromSlices(RaidController raidController, Collection collection) {
            if (collection.size() > 0) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>(collection.size());
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Slice slice = (Slice)iterator.next();
                    if (slice.getLunId() == -1) continue;
                    arrayList.add(new Integer(slice.getLunId()));
                }
                LunMapper.unmapLuns(raidController, arrayList);
            }
        }

        public static void mapUnmappedSlices(RaidSystem raidSystem) {
            Collection collection;
            Object object;
            ArrayList arrayList = new ArrayList();
            RaidController raidController = null;
            int n = 0;
            raidController = raidSystem.getRaidController(1);
            if (raidController != null) {
                object = raidController.getRaidSets().iterator();
                while (object.hasNext()) {
                    collection = ((RaidSet)object.next()).getUnmappedSlices();
                    arrayList.addAll(collection);
                }
                if (arrayList.size() > 0) {
                    logger.info("mapUnmappedSlices: Mapping top RAID controller slices " + arrayList);
                    LunMapper.mapLunsToSlices(raidController, arrayList);
                    n |= 0x10;
                    n |= 1;
                } else {
                    logger.info("mapUnmappedSlices: No unmapped slices on top RAID controller");
                }
            }
            arrayList.clear();
            raidController = raidSystem.getRaidController(2);
            if (raidController != null) {
                object = raidController.getRaidSets().iterator();
                while (object.hasNext()) {
                    collection = ((RaidSet)object.next()).getUnmappedSlices();
                    arrayList.addAll(collection);
                }
                if (arrayList.size() > 0) {
                    logger.info("mapUnmappedSlices: Mapping bottom RAID controller slices " + arrayList);
                    LunMapper.mapLunsToSlices(raidController, arrayList);
                    n |= 0x20;
                    n |= 2;
                } else {
                    logger.info("mapUnmappedSlices: No unmapped slices on bottom RAID controller");
                }
            }
            object = new Restarter(raidSystem, n);
            ((Restarter)object).restart();
        }
    }

    private static class Slicer
    implements Runnable {
        private RaidSystem system;
        private RaidSet raidSet;
        private int newSliceCount;
        private InvocationEvent completionEvent;
        private static final int RESTART_WAIT_SECS = 30;
        private static final Logger logger = Logger.getLogger(class$com$apple$xsr$ManagementController$Slicer == null ? (class$com$apple$xsr$ManagementController$Slicer = ManagementController.class$("com.apple.xsr.ManagementController$Slicer")) : class$com$apple$xsr$ManagementController$Slicer);

        public Slicer(RaidSystem raidSystem, RaidSet raidSet, int n, InvocationEvent invocationEvent) {
            this.system = raidSystem;
            this.raidSet = raidSet;
            this.newSliceCount = n;
            this.completionEvent = invocationEvent;
        }

        public void run() {
            this.slice();
            if (this.completionEvent != null) {
                this.completionEvent.dispatch();
            }
        }

        public void slice() {
            Object object;
            int n;
            TreeSet treeSet;
            MessageFactory messageFactory = this.system.getMessageFactory();
            RaidController raidController = this.raidSet.getController();
            int n2 = this.raidSet.getNativeId();
            int n3 = this.raidSet.getLiveSliceCount();
            if (n3 <= 1) {
                treeSet = this.raidSet.getSlices();
                long l = this.raidSet.getCapacityBytes() / (long)this.newSliceCount;
                n = (int)(l / 1024L / 1024L);
            } else {
                treeSet = new TreeSet(Collections.reverseOrder());
                treeSet.addAll(this.raidSet.getSlices());
                n = (int)(this.raidSet.getCapacityBytes() / 1024L / 1024L);
            }
            logger.info("Slicing RAID set " + this.raidSet.getNativeId() + " on " + raidController.getName());
            logger.info("     New slice count " + this.newSliceCount);
            logger.info("     New slice size " + n);
            ArrayList<RequestMessage> arrayList = new ArrayList<RequestMessage>();
            ArrayList<RequestMessage> arrayList2 = new ArrayList<RequestMessage>();
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                RequestMessage requestMessage;
                object = (Slice)iterator.next();
                int n4 = ((Slice)object).getSize();
                int n5 = this.system.translateSliceId(((Slice)object).getId(), raidController.getId(), 0);
                if (this.newSliceCount > 1) {
                    if (n4 > 0) {
                        requestMessage = messageFactory.newSetSliceSizeRequest(new Integer(n2), new Integer(n5), new Integer(n));
                        arrayList.add(requestMessage);
                        continue;
                    }
                    if (arrayList.size() + arrayList2.size() >= this.newSliceCount) continue;
                    requestMessage = messageFactory.newSetSliceSizeRequest(new Integer(n2), new Integer(n5), new Integer(n));
                    arrayList2.add(requestMessage);
                    arrayList3.add(object);
                    continue;
                }
                if (((Slice)object).getId() == 0) {
                    requestMessage = messageFactory.newSetSliceSizeRequest(new Integer(n2), new Integer(n5), new Integer(n));
                    arrayList2.add(requestMessage);
                    continue;
                }
                if (n4 <= 0) continue;
                requestMessage = messageFactory.newSetSliceSizeRequest(new Integer(n2), new Integer(n5), new Integer(0));
                arrayList.add(requestMessage);
                if (((Slice)object).getLunId() == -1) continue;
                arrayList3.add(new Integer(((Slice)object).getLunId()));
            }
            int n6 = 0;
            if (raidController.getId() == 1) {
                n6 |= 0x10;
                n6 |= 1;
            } else {
                n6 |= 0x20;
                n6 |= 2;
            }
            object = new Restarter(this.system, n6);
            if (arrayList.size() > 0) {
                ListIterator listIterator = arrayList.listIterator();
                while (listIterator.hasNext()) {
                    logger.info("Sending request to shrink slice...");
                    RequestMessage requestMessage = (RequestMessage)listIterator.next();
                    this.system.postMessageAsync(null, requestMessage, raidController.getId(), null);
                }
                if (arrayList2.size() > 0) {
                    logger.info("Restarting RAID controller....");
                    ((Restarter)object).restart();
                    logger.info("Waiting for RAID controller to restart...");
                    try {
                        this.system.waitForRaidControllerOnline(raidController.getId());
                        logger.info(raidController.getName() + " is online");
                    }
                    catch (InterruptedException interruptedException) {
                        logger.info("Exception waiting for " + raidController.getName() + " to come online: " + interruptedException);
                    }
                }
            }
            if (arrayList2.size() > 0) {
                ListIterator listIterator = arrayList2.listIterator();
                while (listIterator.hasNext()) {
                    logger.info("Sending request to expand slice...");
                    RequestMessage requestMessage = (RequestMessage)listIterator.next();
                    this.system.postMessageAsync(null, requestMessage, raidController.getId(), null);
                }
            }
            if (arrayList.size() > 0 || arrayList2.size() > 0) {
                LunMapper lunMapper = new LunMapper(raidController);
                if (this.newSliceCount > 1) {
                    lunMapper.mapLunsToSlices(arrayList3);
                } else {
                    lunMapper.unmapLuns(arrayList3);
                }
                logger.info("Restarting RAID controller....");
                ((Restarter)object).restart();
                logger.info("Waiting for RAID controller to restart...");
                try {
                    this.system.waitForRaidControllerOnline(raidController.getId());
                    logger.info(raidController.getName() + " is online");
                }
                catch (InterruptedException interruptedException) {
                    logger.info("Exception waiting for " + raidController.getName() + " to come online: " + interruptedException);
                }
            }
        }
    }

    static class Restarter
    implements Runnable {
        private static final int RESTART_UPPER_RAID_BIT = 0;
        private static final int RESTART_LOWER_RAID_BIT = 1;
        private static final int RESTART_UPPER_COPROCESSOR_BIT = 2;
        private static final int RESTART_LOWER_COPROCESSOR_BIT = 3;
        private static final int SYNC_NVRAM_UPPER_RAID_BIT = 4;
        private static final int SYNC_NVRAM_LOWER_RAID_BIT = 5;
        private static final int SYNC_NVRAM_UPPER_COPROCESSOR_BIT = 6;
        private static final int SYNC_NVRAM_LOWER_COPROCESSOR_BIT = 7;
        public static final int RESTART_UPPER_RAID_MASK = 1;
        public static final int RESTART_LOWER_RAID_MASK = 2;
        public static final int RESTART_UPPER_COPROCESSOR_MASK = 4;
        public static final int RESTART_LOWER_COPROCESSOR_MASK = 8;
        public static final int SYNC_NVRAM_UPPER_RAID_MASK = 16;
        public static final int SYNC_NVRAM_LOWER_RAID_MASK = 32;
        public static final int SYNC_NVRAM_UPPER_COPROCESSOR_MASK = 64;
        public static final int SYNC_NVRAM_LOWER_COPROCESSOR_MASK = 128;
        public static final int RESTART_DELAY = 10000;
        RaidSystem system;
        int restartBitMask;
        boolean suspendPolling;
        ActiveEvent completionEvent;

        public Restarter(RaidSystem raidSystem, int n) {
            this(raidSystem, n, false, null);
        }

        public Restarter(RaidSystem raidSystem, int n, boolean bl, ActiveEvent activeEvent) {
            this.system = raidSystem;
            this.restartBitMask = n;
            this.suspendPolling = bl;
            this.completionEvent = activeEvent;
        }

        public void run() {
            if (this.suspendPolling) {
                try {
                    this.system.waitForUpdateFinished();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.system.setPollingEnabled(false);
            }
            this.restart();
            if ((this.restartBitMask & 4) != 0 || (this.restartBitMask & 8) != 0 || (this.restartBitMask & 1) != 0 || (this.restartBitMask & 2) != 0 && (this.suspendPolling || this.completionEvent != null)) {
                logger.info("Restarter: Pausing 60 secs before resuming polling or dispatching");
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.suspendPolling) {
                this.system.setPollingEnabled(true);
                try {
                    this.system.waitForUpdateFinished();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.completionEvent != null) {
                this.completionEvent.dispatch();
            }
        }

        public void restart() {
            if (this.restartBitMask != 0) {
                HashMap<String, String> hashMap;
                RequestMessage requestMessage;
                MessageFactory messageFactory = this.system.getMessageFactory();
                int n = 0;
                if ((this.restartBitMask & 0x10) != 0) {
                    n = 1;
                    requestMessage = messageFactory.newFlushRaidControllerNvramRequest();
                    this.system.postMessageAsync(null, requestMessage, n, null);
                }
                if ((this.restartBitMask & 0x20) != 0) {
                    n = 2;
                    requestMessage = messageFactory.newFlushRaidControllerNvramRequest();
                    this.system.postMessageAsync(null, requestMessage, n, null);
                }
                if ((this.restartBitMask & 1) != 0) {
                    n = 1;
                    requestMessage = messageFactory.newRestartRaidControllerRequest();
                    this.system.postMessageAsync(null, requestMessage, n, null);
                }
                if ((this.restartBitMask & 2) != 0) {
                    n = 2;
                    requestMessage = messageFactory.newRestartRaidControllerRequest();
                    this.system.postMessageAsync(null, requestMessage, n, null);
                }
                if ((this.restartBitMask & 0x80) != 0) {
                    hashMap = new HashMap<String, String>();
                    hashMap.put(AcpPropertyCode.ACTION_FLUSH_NVRAM + "", "");
                    requestMessage = messageFactory.newSetPropertiesRequest(hashMap);
                    n = 2;
                    this.system.postMessageAsync(null, requestMessage, n, null);
                }
                if ((this.restartBitMask & 0x40) != 0) {
                    hashMap = new HashMap();
                    hashMap.put(AcpPropertyCode.ACTION_FLUSH_NVRAM + "", "");
                    requestMessage = messageFactory.newSetPropertiesRequest(hashMap);
                    n = 1;
                    this.system.postMessageAsync(null, requestMessage, n, null);
                }
                if (this.system.getPrimarySystemController().getId() == 1) {
                    if ((this.restartBitMask & 8) != 0) {
                        requestMessage = messageFactory.newRestartSystemRequest();
                        n = 2;
                        this.system.postMessageAsync(null, requestMessage, n, null);
                    }
                    if ((this.restartBitMask & 4) != 0 && (this.restartBitMask & 8) != 0) {
                        logger.info("Restarter: Pausing 10 secs before restarting top controller");
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if ((this.restartBitMask & 4) != 0) {
                        requestMessage = messageFactory.newRestartSystemRequest();
                        n = 1;
                        this.system.postMessageAsync(null, requestMessage, n, null);
                    }
                } else {
                    if ((this.restartBitMask & 4) != 0) {
                        requestMessage = messageFactory.newRestartSystemRequest();
                        n = 1;
                        this.system.postMessageAsync(null, requestMessage, n, null);
                    }
                    if ((this.restartBitMask & 4) != 0 && (this.restartBitMask & 8) != 0) {
                        logger.info("Restarter: Pausing 10 secs before restarting bottom controller");
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if ((this.restartBitMask & 8) != 0) {
                        requestMessage = messageFactory.newRestartSystemRequest();
                        n = 2;
                        this.system.postMessageAsync(null, requestMessage, n, null);
                    }
                }
            }
        }
    }

    private static class RaidSetCreator
    implements Runnable {
        private RaidController controller;
        private Integer[] members;
        private String raidLevel;
        private String type;
        private static final Logger logger = Logger.getLogger(class$com$apple$xsr$ManagementController$RaidSetCreator == null ? (class$com$apple$xsr$ManagementController$RaidSetCreator = ManagementController.class$("com.apple.xsr.ManagementController$RaidSetCreator")) : class$com$apple$xsr$ManagementController$RaidSetCreator);

        public RaidSetCreator(RaidController raidController, Integer[] integerArray, String string, String string2) {
            this.controller = raidController;
            this.members = integerArray;
            this.raidLevel = string;
            this.type = string2;
        }

        public void run() {
            RaidSetCreator.createRaidSet(this.controller, this.members, this.raidLevel, this.type);
        }

        public static void createRaidSet(RaidController raidController, Integer[] integerArray, String string, String string2) {
            RaidSystem raidSystem;
            block15: {
                Object object;
                raidSystem = raidController.getRaidSystem();
                MessageFactory messageFactory = raidSystem.getMessageFactory();
                int n = raidController.getId();
                boolean bl = raidController.getRaidSets().size() == 0;
                Integer n2 = new Integer(raidController.nextRaidSetId());
                if (n2 == -1) {
                    String string3 = "Could not allocate new RAID set ID (" + n2 + ")";
                    logger.error(string3);
                    throw new Error(string3);
                }
                if (logger.isInfoEnabled()) {
                    object = Resources.getLineSeparator();
                    String string4 = "Creating RAID set " + n2 + " on RAID controller " + n + (String)object;
                    string4 = string4 + "\t\tRAID set ID: " + n2 + (String)object;
                    string4 = string4 + "\t\tRAID level:  " + string + (String)object;
                    string4 = string4 + "\t\tMembers:     ";
                    for (int i = 0; i < integerArray.length; ++i) {
                        string4 = string4 + integerArray[i] + (String)(i < integerArray.length - 1 ? ", " : object);
                    }
                    string4 = string4 + "\t\tType:        " + string2 + (String)object;
                    logger.info(string4);
                }
                raidSystem.setRaidSetCreationInProgress(n, n2);
                object = messageFactory.newCreateArrayRequest(n2, string, integerArray, string2);
                raidSystem.postMessageAsync(null, (RequestMessage)object, n, null);
                if (bl) {
                    logger.info("RAID set " + n2 + " is the first array. Restarting RAID controller " + n);
                    object = messageFactory.newRestartRaidControllerRequest();
                    raidSystem.postMessageAsync(null, (RequestMessage)object, n, null);
                    logger.info("Waiting for RAID controller to restart...");
                    try {
                        raidSystem.waitForRaidControllerOnline(n);
                        logger.info(raidController.getName() + " is online");
                    }
                    catch (InterruptedException interruptedException) {
                        logger.info("Exception waiting for " + raidController.getName() + " to come online: " + interruptedException);
                    }
                }
                try {
                    raidSystem.waitForRaidSetOnline(n, n2);
                    raidSystem.waitForUpdateFinished();
                    boolean bl2 = false;
                    Object object2 = raidController.getRaidSets().iterator();
                    while (object2.hasNext()) {
                        RaidSet raidSet = (RaidSet)object2.next();
                        if (n2.intValue() != raidSet.getNativeId() || !raidSet.getSlice(0).isMapped()) continue;
                        logger.warn("RAID set " + n2 + " slice 0 already mapped to LUN " + raidSet.getSlice(0).getLunId() + ". Array creation complete.");
                        bl2 = true;
                        break;
                    }
                    if (bl2) break block15;
                    object2 = LunMapper.nextAvailableLun(raidController);
                    if (object2 != null) {
                        int n3 = raidSystem.translateSliceId(0, n, 0);
                        int n4 = raidSystem.translateLunId((Integer)object2, n, 0);
                        logger.info("Mapping Slice " + n3 + " of new array " + n2 + " to LUN " + n4);
                        object = messageFactory.newLUNAssignmentRequest(n2, new Integer(n3), new Integer(n4));
                        raidSystem.postMessageAsync(null, (RequestMessage)object, n, null);
                    } else {
                        logger.error("Unable to map Slice 0 of new array " + n2 + ". No LUN's available.");
                    }
                    object = messageFactory.newFlushRaidControllerNvramRequest();
                    raidSystem.postMessageAsync(null, (RequestMessage)object, n, null);
                    object = messageFactory.newRestartRaidControllerRequest();
                    raidSystem.postMessageAsync(null, (RequestMessage)object, n, null);
                    logger.info("Waiting for RAID controller to restart...");
                    try {
                        raidSystem.waitForRaidControllerOnline(raidController.getId());
                        logger.info(raidController.getName() + " is online");
                    }
                    catch (InterruptedException interruptedException) {
                        logger.info("Exception waiting for " + raidController.getName() + " to come online: " + interruptedException);
                    }
                    logger.info("Waiting for poll cycle to complete...");
                    try {
                        raidSystem.waitForUpdateFinished();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (InterruptedException interruptedException) {
                    logger.error("Interrupted waiting for RAID set " + n2 + " to come online. RAID set was not mapped. " + interruptedException);
                }
            }
            raidSystem.clearRaidSetCreationInProgress();
        }
    }

    private class RecognizeArrayAction
    implements Runnable {
        RaidSystem system;
        int controllerID;
        AquaAlert progressAlert;
        Map raidSetIdMap = new HashMap();

        public RecognizeArrayAction(RaidSystem raidSystem, int n, AquaAlert aquaAlert) {
            this.system = raidSystem;
            this.controllerID = n;
            this.progressAlert = aquaAlert;
        }

        public void run() {
            Object object;
            RaidController raidController = this.system.getRaidController(this.controllerID);
            int n = 0;
            int n2 = 0;
            long l = System.currentTimeMillis();
            logger.info("Checking for hot-plugged drives on RAID controller " + this.controllerID + "...");
            Object object2 = raidController.getDisks().iterator();
            while (object2.hasNext()) {
                object = (Disk)object2.next();
                if (!((Disk)object).isOrphanRaidMember() || ((Disk)object).getMemberState() != 4) continue;
                ++n;
            }
            if (n > 0) {
                logger.info("Restarting RAID controller " + this.controllerID + " to bring hot-plugged drives online...");
                this.system.setUserMessageIndex(7);
                this.restartRaidController(false);
            } else if (logger.isInfoEnabled()) {
                logger.info("No hot-plugged drives found");
            }
            logger.info("Checking for RAID set ID conflicts on RAID controller " + this.controllerID + "...");
            object2 = raidController.getDisks().iterator();
            while (object2.hasNext()) {
                object = (Disk)object2.next();
                if (!((Disk)object).isOrphanRaidMember() || ((Disk)object).getMemberState() != 2) continue;
                this.changeRaidSetID((Disk)object);
                ++n2;
            }
            if (n2 > 0) {
                logger.info("Restarting RAID controller " + this.controllerID + " to bring conflicting ID drives online...");
                this.system.setUserMessageIndex(7);
                this.restartRaidController(false);
                object2 = new ArrayList();
                object = raidController.getRaidSets().iterator();
                while (object.hasNext()) {
                    RaidSet raidSet = (RaidSet)object.next();
                    object2.addAll(raidSet.getLiveSlices());
                }
                if (object2.size() > 0) {
                    logger.info("Updating LUN map for RAID controller " + this.controllerID + "...");
                    this.updateLunMap(raidController, (Collection)object2);
                    logger.info("Syncing NVRAM and restarting RAID controller " + this.controllerID + "...");
                    this.system.setUserMessageIndex(7);
                    this.restartRaidController(true);
                } else {
                    logger.info("No slices exist for RAID controller " + this.controllerID + ". Skipping LUN map repair.");
                }
            } else if (logger.isInfoEnabled()) {
                logger.info("No conflicting ID drives found. Recognize Array complete.");
            }
            if (this.progressAlert != null) {
                if (System.currentTimeMillis() - l < 4000L) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(4000L - (System.currentTimeMillis() - l));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.progressAlert.dismissSheetOrDialog(1);
            }
        }

        private void changeRaidSetID(Disk disk) {
            int n;
            RaidSetIdentifier raidSetIdentifier = new RaidSetIdentifier(disk.getOrphanRaidSetId(), disk.getRaidControllerSerialNumber());
            if (this.raidSetIdMap.containsKey(raidSetIdentifier)) {
                n = (Integer)this.raidSetIdMap.get(raidSetIdentifier);
                logger.info("Retrieved new ID " + n + " from cache");
            } else {
                n = disk.getRaidController().nextRaidSetId();
                this.raidSetIdMap.put(raidSetIdentifier, new Integer(n));
                logger.info("Generated new ID " + n);
            }
            RequestMessage requestMessage = this.system.getMessageFactory().newChangeBrokenRaidIdRequest(disk.getNativeId(), n);
            try {
                this.system.postMessage(requestMessage, this.controllerID);
                logger.info("Setting orphan disk " + disk.getId() + " on RAID controller " + this.controllerID + " to new RS ID " + n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void restartRaidController(boolean bl) {
            int n;
            if (this.controllerID == 1) {
                n = 1;
                if (bl) {
                    n |= 0x10;
                }
            } else {
                n = 2;
                if (bl) {
                    n |= 0x20;
                }
            }
            Restarter restarter = new Restarter(this.system, n, true, null);
            restarter.run();
        }

        private void updateLunMap(RaidController raidController, Collection collection) {
            if (collection.size() > 8) {
                logger.warn("Warning. Insufficient LUN's available to map all slices (slice count = " + collection.size() + ")");
            }
            int n = 0;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                LunMapper.map((Slice)iterator.next(), n++);
                if (n <= 7) continue;
            }
            while (n <= 7) {
                LunMapper.unmap(raidController, n++);
            }
        }

        private boolean idConflicts(RaidController raidController, int n) {
            Iterator iterator = raidController.getRaidSets().iterator();
            while (iterator.hasNext()) {
                int n2 = ((RaidSet)iterator.next()).getNativeId();
                if (n2 != n) continue;
                logger.info("Orphan disk RAID set ID " + n + " conflicts with existing RAID set " + n2);
                return true;
            }
            return false;
        }

        private class RaidSetIdentifier {
            public int raidSetID;
            public String controllerSerialNumber;

            public RaidSetIdentifier(int n, String string) {
                this.raidSetID = n;
                this.controllerSerialNumber = string;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof RaidSetIdentifier)) {
                    return false;
                }
                RaidSetIdentifier raidSetIdentifier = (RaidSetIdentifier)object;
                boolean bl = raidSetIdentifier.raidSetID == this.raidSetID && raidSetIdentifier.controllerSerialNumber.equals(this.controllerSerialNumber);
                return bl;
            }

            public int hashCode() {
                int n = 13;
                n = 37 * n + this.raidSetID;
                n = 37 * n + this.controllerSerialNumber.hashCode();
                return n;
            }
        }
    }

    private static class ManagementProgressSheet
    extends JPanel {
        AquaProgressClock progressClock;

        public ManagementProgressSheet(String string) {
            this.setLayout(new GridBagLayout());
            EmptyBorder emptyBorder = new EmptyBorder(40, 40, 40, 40);
            this.setBorder(emptyBorder);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.insets = new Insets(0, 0, 10, 0);
            this.add((Component)new JLabel(string, 0), gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 3;
            this.add(Box.createHorizontalStrut(300), gridBagConstraints);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.weightx = 1.0;
            this.add(Box.createHorizontalStrut(1), gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            ++gridBagConstraints.gridx;
            this.progressClock = new AquaProgressClock();
            this.add((Component)this.progressClock, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            this.add(Box.createHorizontalStrut(1), gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            ++gridBagConstraints.gridx;
        }

        public boolean isFocusCycleRoot() {
            return true;
        }

        public void startAnimation() {
            this.progressClock.startAnimation();
        }

        public void stopAnimation() {
            this.progressClock.stopAnimation();
        }
    }
}

