/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.xsr.DrivePanel;
import com.apple.xsr.DrivePanelEvent;
import com.apple.xsr.DrivePanelListener;
import com.apple.xsr.DrivePanelSelectionModel;
import com.apple.xsr.DrivePanelSelectionPolicy;
import com.apple.xsr.Resources;
import com.apple.xsr.som.Disk;
import com.apple.xsr.som.RaidSet;
import com.apple.xsr.som.RaidSystem;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.MediaTracker;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.EventListenerList;

public class DriveSelectionPanelEx
extends JPanel
implements DrivePanel,
ItemSelectable {
    static final int DRIVE_COUNT = 14;
    private RaidSystem system;
    protected DrivePanelSelectionModel selectionModel = new DrivePanel.DefaultSelectionModel();
    protected DrivePanelSelectionPolicy selectionPolicy = new DrivePanel.DefaultSelectionPolicy();
    private int[] states = new int[14];
    private int[] types = new int[14];
    private int[] raidSets = new int[14];
    private int[] badges = new int[14];
    private int selectionColor = 0;
    private boolean useCheckBoxes = false;
    private Map infoIcons = new HashMap(4);
    private boolean expandArbitrary = false;
    boolean addNotifyCalled = false;
    boolean inDragSelect = false;
    boolean selecting = false;
    private final EventListenerList listenerList = new EventListenerList();
    private DriveIcon[] driveIcon;
    static final Image emptyImage = Resources.getImage("icon.frontpanel.drive.empty");
    static final Image presentImage = Resources.getImage("icon.frontpanel.drive.present");
    static final Image availableImage = Resources.getImage("icon.frontpanel.drive.available");
    static final Image selectedImage = Resources.getImage("icon.frontpanel.drive.selected");
    static final Image offlineImage = Resources.getImage("icon.frontpanel.drive.offline");
    static final Image deleteImage = Resources.getImage("icon.frontpanel.drive.delete");
    static final Image rebuildingImage = Resources.getImage("icon.frontpanel.drive.rebuilding");
    static final Image expandImage = Resources.getImage("icon.frontpanel.drive.expand");
    static final Image orphanImage = Resources.getImage("icon.frontpanel.drive.orphan");
    private static Color hiliteColor = new JTable().getSelectionBackground();
    private static Color badgeColor = Color.getHSBColor(0.0f, 0.0f, 0.4f);
    static /* synthetic */ Class class$java$awt$event$ItemListener;
    static /* synthetic */ Class class$com$apple$xsr$DrivePanelListener;

    public DriveSelectionPanelEx(int n) {
        JLabel jLabel;
        GUIFactory.configureComponentForPlatform(this);
        this.selectionModel.setSelectionMode(n);
        this.selectionModel.addDrivePanelListener(new SelectionModelListener());
        for (int i = 0; i < 14; ++i) {
            this.states[i] = 1;
            this.types[i] = 0;
            this.raidSets[i] = 0;
            this.badges[i] = 0;
        }
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(emptyImage, 0);
        mediaTracker.addImage(presentImage, 0);
        mediaTracker.addImage(availableImage, 0);
        mediaTracker.addImage(selectedImage, 0);
        mediaTracker.addImage(offlineImage, 0);
        mediaTracker.addImage(deleteImage, 0);
        mediaTracker.addImage(rebuildingImage, 0);
        mediaTracker.addImage(expandImage, 0);
        mediaTracker.addImage(orphanImage, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        JLabel jLabel2 = new JLabel(new ImageIcon(Resources.getImage("icon.frontpanel.top")));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 17;
        gridBagConstraints.gridheight = 1;
        this.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel(new ImageIcon(Resources.getImage("icon.frontpanel.left")));
        gridBagConstraints.gridx = n2++;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.add((Component)jLabel3, gridBagConstraints);
        this.driveIcon = new DriveIcon[14];
        for (int i = 0; i < 14; ++i) {
            this.driveIcon[i] = new DriveIcon(i, new ImageIcon(emptyImage));
            gridBagConstraints.gridx = n2++;
            gridBagConstraints.gridy = 1;
            this.add((Component)this.driveIcon[i], gridBagConstraints);
            if (i != 6) continue;
            jLabel = new JLabel(new ImageIcon(Resources.getImage("icon.frontpanel.center")));
            gridBagConstraints.gridx = n2++;
            gridBagConstraints.gridy = 1;
            this.add((Component)jLabel, gridBagConstraints);
        }
        JLabel jLabel4 = new JLabel(new ImageIcon(Resources.getImage("icon.frontpanel.right")));
        gridBagConstraints.gridx = n2++;
        gridBagConstraints.gridy = 1;
        this.add((Component)jLabel4, gridBagConstraints);
        jLabel = new JLabel(new ImageIcon(Resources.getImage("icon.frontpanel.bottom")));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 17;
        gridBagConstraints.gridheight = 1;
        this.add((Component)jLabel, gridBagConstraints);
    }

    public void setRaidSystem(RaidSystem raidSystem) {
        for (int i = 0; i < 14; ++i) {
            this.states[i] = 1;
            this.types[i] = 0;
            this.raidSets[i] = 0;
        }
        this.selectionModel.clearSelection();
        if (raidSystem != null) {
            this.system = new RaidSystem(raidSystem);
            Collection collection = this.system.getDisks();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                int n = -1;
                int n2 = -1;
                int n3 = 0;
                Disk disk = (Disk)iterator.next();
                n = disk.getState();
                n2 = disk.getType();
                if (n2 == 1) {
                    RaidSet raidSet = disk.getRaidSet();
                    if (raidSet != null) {
                        n3 = raidSet.getId();
                    } else {
                        n = 0;
                    }
                } else if (disk.getType() == 3) {
                    n3 = disk.getRaidController().isTop() ? -2 : -3;
                } else if (disk.getType() == 4) {
                    n3 = disk.getOrphanRaidSetId();
                }
                int n4 = disk.getId() - 1;
                this.states[n4] = n;
                this.types[n4] = n2;
                this.raidSets[n4] = n3;
            }
        } else {
            this.system = null;
        }
        this.paintDriveIcons();
    }

    public RaidSystem getRaidSystem() {
        return this.system;
    }

    public void setSelectionModel(DrivePanelSelectionModel drivePanelSelectionModel) {
        this.selectionModel = drivePanelSelectionModel;
    }

    public DrivePanelSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionPolicy(DrivePanelSelectionPolicy drivePanelSelectionPolicy) {
        this.selectionPolicy = drivePanelSelectionPolicy;
    }

    public DrivePanelSelectionPolicy getSelectionPolicy() {
        return this.selectionPolicy;
    }

    public void setSelectionMode(int n) {
        this.selectionModel.setSelectionMode(n);
        this.paintDriveIcons();
    }

    public int getSelectionMode() {
        return this.selectionModel.getSelectionMode();
    }

    public void setSelectionStyle(int n) {
        this.selectionModel.setSelectionStyle(n);
        this.paintDriveIcons();
    }

    public int getSelectionStyle() {
        return this.selectionModel.getSelectionStyle();
    }

    public void setDriveSelected(int n, boolean bl) {
        this.selectionModel.setDriveSelected(n, bl);
    }

    public boolean isDriveSelected(int n) {
        return this.selectionModel.isDriveSelected(n);
    }

    public void setArraySelected(int n, boolean bl) {
        this.selectionModel.setArraySelected(n, bl);
    }

    public boolean isArraySelected(int n) {
        return this.selectionModel.isArraySelected(n);
    }

    public Object[] getSelectedObjects() {
        int[] nArray = this.selectionModel.getSelectedDrives();
        Object[] objectArray = new Object[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray[i] = new Integer(nArray[i]);
        }
        return objectArray;
    }

    public void setSelectedDriveCount(int n) {
        this.paintDriveIcons();
    }

    public int getSelectionCount() {
        return this.selectionModel.getSelectionCount();
    }

    public void setBadgeIcon(int n, int n2) {
        this.badges[n] = n2;
    }

    public int getBadgeIcon(int n) {
        return this.badges[n];
    }

    public void setInfoIcon(int n, InfoIcon infoIcon) {
        this.infoIcons.put(new Integer(n), infoIcon);
    }

    public void setUseCheckBoxes(boolean bl) {
        if (bl && this.selectionPolicy.getSelectableTypes() != 0 && this.selectionPolicy.getSelectableStates() != 1) {
            throw new IllegalStateException("selection policy selectable types must be UNASSIGNED and states must be ONLINE if using checkboxes");
        }
        this.useCheckBoxes = bl;
    }

    public boolean isUsingCheckBoxes() {
        return this.useCheckBoxes;
    }

    public void doClick(int n) {
        this.driveIcon[n - 1].doClick();
    }

    public void addItemListener(ItemListener itemListener) {
        this.listenerList.add(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = DriveSelectionPanelEx.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.listenerList.remove(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = DriveSelectionPanelEx.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, itemListener);
    }

    public void addDrivePanelListener(DrivePanelListener drivePanelListener) {
        this.listenerList.add(class$com$apple$xsr$DrivePanelListener == null ? (class$com$apple$xsr$DrivePanelListener = DriveSelectionPanelEx.class$("com.apple.xsr.DrivePanelListener")) : class$com$apple$xsr$DrivePanelListener, drivePanelListener);
    }

    public void removeDrivePanelListener(DrivePanelListener drivePanelListener) {
        this.listenerList.remove(class$com$apple$xsr$DrivePanelListener == null ? (class$com$apple$xsr$DrivePanelListener = DriveSelectionPanelEx.class$("com.apple.xsr.DrivePanelListener")) : class$com$apple$xsr$DrivePanelListener, drivePanelListener);
    }

    private void fireDrivePanelEvent(DrivePanelEvent drivePanelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$apple$xsr$DrivePanelListener == null ? DriveSelectionPanelEx.class$("com.apple.xsr.DrivePanelListener") : class$com$apple$xsr$DrivePanelListener)) continue;
            DrivePanelListener drivePanelListener = (DrivePanelListener)objectArray[i + 1];
            if (drivePanelEvent.getEventID() == 0) {
                drivePanelListener.driveIconEntered(drivePanelEvent);
            } else if (drivePanelEvent.getEventID() == 1) {
                drivePanelListener.driveIconExited(drivePanelEvent);
            }
            if (drivePanelEvent.getEventID() != 2) continue;
            drivePanelListener.driveIconClicked(drivePanelEvent);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.addNotifyCalled = true;
        this.paintDriveIcons();
    }

    private boolean isAssigned(int n) {
        return this.types[n] == 1 || this.types[n] == 3 || this.types[n] == 4;
    }

    private void paintDriveIcons() {
        if (!this.addNotifyCalled) {
            return;
        }
        for (int i = 0; i < 14; ++i) {
            InfoIcon infoIcon;
            int n = this.getSelectionMode();
            int n2 = this.states[i];
            int n3 = this.types[i];
            int n4 = this.raidSets[i];
            int n5 = 18;
            int n6 = 68;
            int n7 = 49;
            int n8 = 14;
            Image image = this.createImage(n5, n6);
            Graphics graphics = image.getGraphics();
            Image image2 = this.isAssigned(i) ? (this.getSelectionMode() == 1 && this.useCheckBoxes ? (this.isDriveSelected(i + 1) ? selectedImage : availableImage) : presentImage) : (this.states[i] == -2 ? emptyImage : presentImage);
            graphics.drawImage(image2, 0, 0, null);
            boolean bl = false;
            if (n == 1 || n == 3) {
                if (!this.useCheckBoxes) {
                    bl = this.isDriveSelected(i + 1);
                }
            } else if (n == 2) {
                bl = this.isArraySelected(this.raidSets[i]);
            }
            if (bl) {
                if (this.selectionColor == 0) {
                    this.tintIcon(graphics, n5, n6, hiliteColor, 0.7f, true);
                } else if (this.selectionColor == 1) {
                    this.tintIcon(graphics, n5, n6, Color.red, 0.4f, false);
                }
            }
            if (image2 == availableImage || image2 == selectedImage) {
                n7 -= 12;
            }
            if (this.badges[i] == 0) {
                if (this.isAssigned(i)) {
                    if (n3 == 1 || n3 == 3) {
                        graphics.setColor(badgeColor);
                        graphics.fillRect(4, 53, 10, 10);
                        graphics.setColor(Color.white);
                        graphics.setFont(GUIFactory.FONT_BADGE);
                        if (n4 > 0) {
                            graphics.drawString(n4 + "", 6, 62);
                        } else {
                            graphics.drawString("J", 8, 61);
                        }
                        n7 -= n8;
                    } else if (n3 == 4) {
                        boolean bl2 = false;
                        if (bl2) {
                            boolean bl3;
                            graphics.setColor(badgeColor);
                            graphics.fillRect(4, 53, 10, 10);
                            graphics.setColor(Color.white);
                            graphics.setFont(GUIFactory.FONT_BADGE);
                            if (n4 > 0) {
                                graphics.drawString(n4 + "", 6, 62);
                            }
                            if ((bl3 = false) && n4 == 0) {
                                graphics.drawString("?", 7, 61);
                            }
                            graphics.drawImage(orphanImage, 4, (n7 -= n8) + 6, null);
                            n7 -= n8;
                        } else {
                            graphics.drawImage(orphanImage, 4, n7 + 4, null);
                            n7 -= n8;
                        }
                    }
                }
                if (n2 == 0) {
                    graphics.drawImage(offlineImage, 0, n7, null);
                    n7 -= n8;
                }
                if (n2 == 2) {
                    // empty if block
                }
            } else if (this.badges[i] == 1) {
                graphics.drawImage(expandImage, 0, n7, null);
                n7 -= n8;
            }
            if (this.infoIcons.containsKey(new Integer(n2)) && ((infoIcon = (InfoIcon)this.infoIcons.get(new Integer(n2))).selectionState == 1 && this.isDriveSelected(i + 1) || infoIcon.selectionState == 0 && !this.isDriveSelected(i + 1) || infoIcon.selectionState == 2) && infoIcon.icon == 0) {
                graphics.drawImage(deleteImage, 0, n7 + 1, null);
                n7 -= n8;
            }
            this.driveIcon[i].setIcon(new ImageIcon(image));
        }
    }

    private void tintIcon(Graphics graphics, int n, int n2, Color color, float f, boolean bl) {
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f);
        Composite composite = ((Graphics2D)graphics).getComposite();
        ((Graphics2D)graphics).setComposite(alphaComposite);
        graphics.setColor(color);
        graphics.fillRect(1, 1, n - 2, n2 - 2);
        ((Graphics2D)graphics).setComposite(composite);
        if (bl) {
            graphics.setColor(color);
            graphics.drawRect(1, 1, n - 3, n2 - 3);
            graphics.drawRect(2, 2, n - 5, n2 - 5);
        }
    }

    private int indexOfFirstSelectedDrive() {
        int n = -1;
        for (int i = 0; i < 14; ++i) {
            if (!this.isDriveSelected(i + 1)) continue;
            n = i;
            break;
        }
        return n;
    }

    public static boolean isJbod(int n) {
        return n == -2 || n == -3;
    }

    public void setSelectedArray(int n) {
    }

    public int getSelectedArray() {
        return 0;
    }

    public void setConfirmed(boolean bl) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SelectionModelListener
    implements DrivePanelListener {
        private SelectionModelListener() {
        }

        public void valueChanged(DrivePanelEvent drivePanelEvent) {
            DriveSelectionPanelEx.this.paintDriveIcons();
            this.fireValueChanged(drivePanelEvent);
        }

        public void driveIconEntered(DrivePanelEvent drivePanelEvent) {
        }

        public void driveIconExited(DrivePanelEvent drivePanelEvent) {
        }

        public void driveIconClicked(DrivePanelEvent drivePanelEvent) {
        }

        private void fireValueChanged(DrivePanelEvent drivePanelEvent) {
            Object[] objectArray = DriveSelectionPanelEx.this.listenerList.getListenerList();
            ItemEvent itemEvent = null;
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] == (class$java$awt$event$ItemListener == null ? DriveSelectionPanelEx.class$("java.awt.event.ItemListener") : class$java$awt$event$ItemListener)) {
                    if (itemEvent == null) {
                        Integer n = new Integer(drivePanelEvent.getFirstID());
                        boolean bl = drivePanelEvent.getEventID() == 3 ? DriveSelectionPanelEx.this.selectionModel.isDriveSelected(drivePanelEvent.getFirstID()) : DriveSelectionPanelEx.this.selectionModel.isArraySelected(drivePanelEvent.getFirstID());
                        int n2 = bl ? 1 : 2;
                        itemEvent = new ItemEvent(DriveSelectionPanelEx.this, 701, n, n2);
                    }
                    ((ItemListener)objectArray[i + 1]).itemStateChanged(itemEvent);
                }
                if (objectArray[i] != (class$com$apple$xsr$DrivePanelListener == null ? DriveSelectionPanelEx.class$("com.apple.xsr.DrivePanelListener") : class$com$apple$xsr$DrivePanelListener)) continue;
                ((DrivePanelListener)objectArray[i + 1]).valueChanged(drivePanelEvent);
            }
        }
    }

    private class DriveIcon
    extends JLabel
    implements MouseListener {
        private int index;
        private Icon image;

        public DriveIcon(int n, Icon icon) {
            super(icon);
            this.index = n;
            this.addMouseListener(this);
        }

        public int getID() {
            return this.index + 1;
        }

        public void doClick() {
            this.mousePressed(new MouseEvent(this, 501, System.currentTimeMillis(), 0, 0, 0, 0, false));
            this.mouseReleased(new MouseEvent(this, 502, System.currentTimeMillis(), 0, 0, 0, 0, false));
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            DrivePanelEvent drivePanelEvent = new DrivePanelEvent(0, DriveSelectionPanelEx.this, this.getID(), false);
            DriveSelectionPanelEx.this.fireDrivePanelEvent(drivePanelEvent);
            if (DriveSelectionPanelEx.this.inDragSelect && DriveSelectionPanelEx.this.getSelectionMode() == 1) {
                DriveSelectionPanelEx.this.setDriveSelected(this.index + 1, DriveSelectionPanelEx.this.selecting);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            DrivePanelEvent drivePanelEvent = new DrivePanelEvent(1, DriveSelectionPanelEx.this, this.getID(), false);
            DriveSelectionPanelEx.this.fireDrivePanelEvent(drivePanelEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            block9: {
                block11: {
                    block10: {
                        int n;
                        int n2 = DriveSelectionPanelEx.this.states[this.index];
                        if (!DriveSelectionPanelEx.this.selectionPolicy.isSelectable(n2, n = DriveSelectionPanelEx.this.types[this.index])) break block9;
                        if (DriveSelectionPanelEx.this.getSelectionMode() != 1) break block10;
                        if (DriveSelectionPanelEx.this.selectionModel.getSelectionStyle() == 0) {
                            DriveSelectionPanelEx.this.inDragSelect = false;
                            DriveSelectionPanelEx.this.selecting = !DriveSelectionPanelEx.this.isDriveSelected(this.index + 1);
                            DriveSelectionPanelEx.this.selectionModel.setSelectionIsAdjusting(true);
                            for (int i = 0; i < 14; ++i) {
                                if (i == 13) {
                                    DriveSelectionPanelEx.this.selectionModel.setSelectionIsAdjusting(false);
                                }
                                DriveSelectionPanelEx.this.setDriveSelected(i + 1, i != this.index ? false : DriveSelectionPanelEx.this.selecting);
                            }
                        } else {
                            DriveSelectionPanelEx.this.inDragSelect = true;
                            DriveSelectionPanelEx.this.selecting = !DriveSelectionPanelEx.this.isDriveSelected(this.index + 1);
                            DriveSelectionPanelEx.this.setDriveSelected(this.index + 1, DriveSelectionPanelEx.this.selecting);
                        }
                        break block9;
                    }
                    if (DriveSelectionPanelEx.this.getSelectionMode() != 2) break block11;
                    DriveSelectionPanelEx.this.inDragSelect = true;
                    DriveSelectionPanelEx.this.selecting = !DriveSelectionPanelEx.this.isArraySelected(DriveSelectionPanelEx.this.raidSets[this.index]);
                    DriveSelectionPanelEx.this.setArraySelected(DriveSelectionPanelEx.this.raidSets[this.index], DriveSelectionPanelEx.this.selecting);
                    break block9;
                }
                if (DriveSelectionPanelEx.this.getSelectionMode() != 3) break block9;
                DriveSelectionPanelEx.this.inDragSelect = false;
                boolean bl = DriveSelectionPanelEx.this.selecting = !DriveSelectionPanelEx.this.isDriveSelected(this.index + 1);
                if (DriveSelectionPanelEx.this.selecting) {
                    int n;
                    DriveSelectionPanelEx.this.selectionModel.setSelectionIsAdjusting(true);
                    for (n = 1; n <= 7; ++n) {
                        if (n == 7) {
                            DriveSelectionPanelEx.this.selectionModel.setSelectionIsAdjusting(false);
                        }
                        DriveSelectionPanelEx.this.setDriveSelected(n + (this.index < 7 ? 7 : 0), false);
                    }
                    DriveSelectionPanelEx.this.selectionModel.setSelectionIsAdjusting(true);
                    for (n = 1; n <= 7; ++n) {
                        if (n == 7) {
                            DriveSelectionPanelEx.this.selectionModel.setSelectionIsAdjusting(false);
                        }
                        DriveSelectionPanelEx.this.setDriveSelected(n + (this.index < 7 ? 0 : 7), true);
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            DriveSelectionPanelEx.this.inDragSelect = false;
        }
    }

    public static class InfoIcon {
        public static final int NOT_SELECTED = 0;
        public static final int SELECTED = 1;
        public static final int BOTH = 2;
        private int icon;
        private int selectionState;
    }
}

