/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.util.Gestalt;
import com.apple.xsr.AquaInformationPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.Renderer;
import javax.swing.SwingUtilities;

public class DriveInformationPanel
extends AquaInformationPanel {
    public DriveInformationPanel(Image image, String string) {
        super(image, string);
        if (!Gestalt.isAquaLookAndFeel) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 2;
            this.add(Box.createVerticalStrut(90), gridBagConstraints);
        }
    }

    public void setText(String string) {
        this.setText((Object)string);
    }

    public void setText(Object object) {
        if (this.textRenderer != null) {
            this.textRenderer.setValue(object, false);
            this.validate();
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window != null) {
                window.repaint();
            } else {
                this.repaint();
            }
        }
    }

    protected Renderer createDefaultTextRenderer() {
        return new TextTableRenderer();
    }

    public static class TextCell
    implements Cloneable {
        public int x = 0;
        public int y = 0;
        public int colspan = 1;
        public int rowspan = 1;
        public String text = "";

        public TextCell() {
        }

        public TextCell(TextCell textCell) {
            this.x = textCell.x;
            this.y = textCell.y;
            this.colspan = textCell.colspan;
            this.rowspan = textCell.rowspan;
            this.text = textCell.text;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error("Assertion Failure");
            }
        }
    }

    private static class TextTableRenderer
    extends JPanel
    implements Renderer {
        public static final int DEFAULT_ANCHOR = 18;
        public static final int DEFAULT_CELL_SPACING = 4;
        private static final Insets INSETS_ZERO = new Insets(0, 0, 0, 0);
        private static final Insets INSETS_CELL_SPACE = new Insets(0, 0, 0, 4);

        public TextTableRenderer() {
            GUIFactory.configureComponentForPlatform(this);
            this.setBackground(AquaInformationPanel.BOX_COLOR);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            this.add((Component)this.createTextPane(""), gridBagConstraints);
        }

        public Component getComponent() {
            return this;
        }

        public void setValue(Object object, boolean bl) {
            if (object == null) {
                throw new NullPointerException("value cannot be null");
            }
            if (!(object instanceof String) && !(object instanceof Object[])) {
                throw new IllegalArgumentException("value must be a String or Collection; got " + object.getClass());
            }
            if (object instanceof String) {
                if (this.getComponentCount() == 1) {
                    JTextPane jTextPane = (JTextPane)this.getComponent(0);
                    jTextPane.setText(object + "");
                } else {
                    this.removeAll();
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.anchor = 18;
                    gridBagConstraints.fill = 1;
                    this.add((Component)this.createTextPane(object + ""), gridBagConstraints);
                    this.invalidate();
                }
            } else {
                this.removeAll();
                this.addCells((Object[])object);
                this.invalidate();
            }
        }

        private void addCells(Object[] objectArray) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (!(object instanceof TextCell)) {
                    throw new ClassCastException(object.getClass() + " not a TextCell object");
                }
                TextCell textCell = (TextCell)object;
                gridBagConstraints.gridx = textCell.x;
                gridBagConstraints.gridy = textCell.y;
                gridBagConstraints.gridwidth = textCell.colspan;
                gridBagConstraints.gridheight = textCell.rowspan;
                gridBagConstraints.weightx = textCell.colspan > 1 ? 1 : 0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.anchor = textCell.x == 0 && textCell.colspan == 1 ? 12 : 18;
                gridBagConstraints.fill = 3;
                gridBagConstraints.ipadx = 0;
                gridBagConstraints.ipady = 0;
                gridBagConstraints.insets = textCell.colspan > 1 ? INSETS_ZERO : INSETS_CELL_SPACE;
                this.add((Component)this.createTextPane(textCell.text), gridBagConstraints);
            }
        }

        private JTextPane createTextPane(String string) {
            JTextPane jTextPane = GUIFactory.newTextPane();
            jTextPane.setFont(GUIFactory.FONT_SMALL);
            jTextPane.setEditable(false);
            jTextPane.setBorder(null);
            jTextPane.setBackground(AquaInformationPanel.BOX_COLOR);
            jTextPane.setText(string);
            return jTextPane;
        }
    }
}

