/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.util.CapacityConverter;
import com.apple.util.StringUtilities;
import com.apple.xsr.DriveInformationPanel;
import com.apple.xsr.DrivePanel;
import com.apple.xsr.DrivePanelEvent;
import com.apple.xsr.DrivePanelListener;
import com.apple.xsr.Resources;
import com.apple.xsr.SOMLocalizer;
import com.apple.xsr.som.Disk;
import com.apple.xsr.som.RaidSet;
import com.apple.xsr.som.RaidSystem;

public class DriveInfoPanelController
implements DrivePanelListener {
    DriveInformationPanel infoPanel;

    public DriveInfoPanelController(DriveInformationPanel driveInformationPanel) {
        this.infoPanel = driveInformationPanel;
    }

    public void driveIconEntered(DrivePanelEvent drivePanelEvent) {
        Object object = this.getExplanation(((DrivePanel)drivePanelEvent.getSource()).getRaidSystem(), drivePanelEvent.getFirstID());
        if (this.infoPanel != null && object != null) {
            this.infoPanel.setText(object);
        }
    }

    public void driveIconExited(DrivePanelEvent drivePanelEvent) {
        if (this.infoPanel != null) {
            this.infoPanel.setText(Resources.getString("management.driveInfo.note"));
        }
    }

    public void driveIconClicked(DrivePanelEvent drivePanelEvent) {
    }

    public void valueChanged(DrivePanelEvent drivePanelEvent) {
    }

    public Object getExplanation(RaidSystem raidSystem, int n) {
        DriveInformationPanel.TextCell[] textCellArray = null;
        Disk disk = raidSystem.getDisk(n);
        if (disk != null) {
            DriveInformationPanel.TextCell[] textCellArray2 = "";
            int n2 = disk.getState();
            int n3 = disk.getType();
            if (n2 == -2) {
                textCellArray2 = StringUtilities.replaceAll(Resources.getString("management.driveInfo.empty"), "{number}", "" + n);
            } else if (n2 == 0) {
                textCellArray2 = StringUtilities.replaceAll(Resources.getString("management.driveInfo.offline"), "{number}", "" + n);
            } else if (n2 == 1) {
                if (n3 == 1) {
                    RaidSet raidSet = disk.getRaidSet();
                    textCellArray2 = StringUtilities.replaceAll(Resources.getString("management.driveInfo.assigned"), "{number}", "" + n);
                    textCellArray2 = StringUtilities.replaceAll((String)textCellArray2, "{index}", "" + raidSet.getId());
                    textCellArray2 = StringUtilities.replaceAll((String)textCellArray2, "{description}", SOMLocalizer.getRaidSetLevelAndCapacity(raidSet));
                } else if (n3 == 3) {
                    textCellArray2 = StringUtilities.replaceAll(Resources.getString("management.driveInfo.jbod"), "{number}", "" + n);
                    textCellArray2 = StringUtilities.replaceAll((String)textCellArray2, "{capacity}", this.createCapacityString(disk.getCapacityBytes()));
                } else if (n3 == 4) {
                    DriveInformationPanel.TextCell textCell = new DriveInformationPanel.TextCell();
                    DriveInformationPanel.TextCell[] textCellArray3 = new DriveInformationPanel.TextCell[9];
                    int n4 = 0;
                    textCell.x = 0;
                    textCell.y = 0;
                    textCell.colspan = 2;
                    textCell.text = StringUtilities.replaceAll(Resources.getString("management.driveInfo.orphan.note"), "{number}", n + "");
                    textCellArray3[n4++] = new DriveInformationPanel.TextCell(textCell);
                    textCell.colspan = 1;
                    textCell.x = 0;
                    ++textCell.y;
                    textCell.text = Resources.getString("management.driveInfo.orphan.raidSet");
                    textCellArray3[n4++] = new DriveInformationPanel.TextCell(textCell);
                    textCell.x = 1;
                    textCell.text = disk.getOrphanRaidSetId() + "";
                    textCellArray3[n4++] = new DriveInformationPanel.TextCell(textCell);
                    textCell.x = 0;
                    ++textCell.y;
                    textCell.text = Resources.getString("management.driveInfo.orphan.raidLevel");
                    textCellArray3[n4++] = new DriveInformationPanel.TextCell(textCell);
                    textCell.x = 1;
                    textCell.text = disk.getOrphanRaidLevel() + "";
                    textCellArray3[n4++] = new DriveInformationPanel.TextCell(textCell);
                    textCell.x = 0;
                    ++textCell.y;
                    textCell.text = Resources.getString("management.driveInfo.orphan.memberIndexLabel");
                    textCellArray3[n4++] = new DriveInformationPanel.TextCell(textCell);
                    textCell.x = 1;
                    textCell.text = StringUtilities.replaceAll(Resources.getString("management.driveInfo.orphan.memberIndex"), "{index}", disk.getOrphanRaidMemberIndex() + 1 + "");
                    textCell.text = StringUtilities.replaceAll(textCell.text, "{count}", disk.getOrphanRaidMemberCount() + "");
                    textCellArray3[n4++] = new DriveInformationPanel.TextCell(textCell);
                    textCell.x = 0;
                    ++textCell.y;
                    textCell.text = Resources.getString("management.driveInfo.orphan.serialNumber");
                    textCellArray3[n4++] = new DriveInformationPanel.TextCell(textCell);
                    textCell.x = 1;
                    textCell.text = disk.getRaidControllerSerialNumber() + "";
                    textCellArray3[n4++] = new DriveInformationPanel.TextCell(textCell);
                    if (n4 != 9) {
                        throw new Error("Assert: cellIndex (" + n4 + ") != CELL_COUNT (" + 9 + ")");
                    }
                    textCellArray = textCellArray3;
                } else if (n3 == 0) {
                    textCellArray2 = StringUtilities.replaceAll(Resources.getString("management.driveInfo.unassigned"), "{number}", "" + n);
                    textCellArray2 = StringUtilities.replaceAll((String)textCellArray2, "{capacity}", this.createCapacityString(disk.getCapacityBytes()));
                }
            }
            if (!textCellArray2.equals("")) {
                textCellArray = textCellArray2;
            }
        }
        return textCellArray;
    }

    private String createCapacityString(long l) {
        String string;
        int n = (int)CapacityConverter.toGigabytes(l);
        if (n < 1024) {
            string = Resources.getString("management.create.capacity.gb");
            string = StringUtilities.replaceAll(string, "{number}", "" + n);
        } else {
            string = Resources.getString("management.create.capacity.tb");
            string = StringUtilities.replaceAll(string, "{number}", "" + (double)((int)((double)n / 1024.0 * 100.0)) / 100.0);
        }
        return string;
    }
}

