/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.xsr.AbstractManagementPane;
import com.apple.xsr.ArraySelectionPanel;
import com.apple.xsr.DataModel;
import com.apple.xsr.DeleteArrayModel;
import com.apple.xsr.DriveInformationPanel;
import com.apple.xsr.DriveSelectionPanel;
import com.apple.xsr.Resources;
import com.apple.xsr.RestartRequiredLabel;
import com.apple.xsr.StepByStepPanel;
import com.apple.xsr.som.RaidSet;
import com.apple.xsr.som.RaidSystem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;

public class DeleteArrayPane
extends AbstractManagementPane {
    private static final Insets zeroInsets = new Insets(0, 0, 0, 0);
    private final int LEFT_INDENT_1 = 20;
    private final int LEFT_INDENT_2 = 22;
    private final int STEP_VSPACE = 15;
    static final int DRIVE_EMPTY = -3;
    static final int DRIVE_OFFLINE = -2;
    static final int DRIVE_SELECTED = -1;
    static final int DRIVE_AVAILABLE = 0;
    static final int RAID_0 = 0;
    static final int RAID_1 = 1;
    static final int RAID_3 = 2;
    static final int RAID_5 = 3;
    static final int RAID_01 = 4;
    static final int[] levels = new int[]{0, 1, 2, 3, 4};
    static String[] levelNames = new String[]{Resources.getString("management.create.raid0"), Resources.getString("management.create.raid1"), Resources.getString("management.create.raid3"), Resources.getString("management.create.raid5"), Resources.getString("management.create.raid01")};
    static String[] levelDescriptions = new String[]{Resources.getString("management.create.raid0.note"), Resources.getString("management.create.raid1.note"), Resources.getString("management.create.raid3.note"), Resources.getString("management.create.raid5.note"), Resources.getString("management.create.raid01.note")};
    int[] driveAssignments = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    int[] driveCapacities = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    DriveSelectionPanel drivePanel;
    JLabel legendLabel;
    ArraySelectionPanel legend;
    StepByStepPanel summaryHeader;
    JTextPane summaryLabel;
    JCheckBox confirmCheckBox;
    JButton deleteButton;
    RestartRequiredLabel restartLabel;
    private RaidSystem system;
    private static final int preferredWidth = 664;
    private static final int preferredHeight = 474;
    static /* synthetic */ Class class$com$apple$xsr$DeleteArrayModel;

    public DeleteArrayPane() {
        super(664, 474);
        GUIFactory.configureComponentForPlatform(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        boolean bl = false;
        StepByStepPanel stepByStepPanel = new StepByStepPanel(Resources.getImage("icon.step.five"), Resources.getString("management.delete.summary"));
        this.summaryLabel = GUIFactory.newTextPane(Resources.getString("management.delete.summary.cannot"), 2);
        this.deleteButton = GUIFactory.newButton(Resources.getString("management.delete.deleteButton"));
        this.deleteButton.setEnabled(false);
        StepByStepPanel stepByStepPanel2 = new StepByStepPanel(Resources.getImage("icon.step.one"), Resources.getString("management.delete.selectArray"));
        this.add((Component)stepByStepPanel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        DriveInformationPanel driveInformationPanel = new DriveInformationPanel(null, Resources.getString("management.driveInfo.note"));
        JPanel jPanel = GUIFactory.newPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 6, 0);
        gridBagConstraints2.weightx = 1.0;
        jPanel.add((Component)driveInformationPanel, gridBagConstraints2);
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = zeroInsets;
        gridBagConstraints2.fill = 0;
        this.drivePanel = new DriveSelectionPanel(2, driveInformationPanel, stepByStepPanel, this.summaryLabel, this.deleteButton);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 20);
        jPanel.add((Component)this.drivePanel, gridBagConstraints2);
        gridBagConstraints2.insets = zeroInsets;
        gridBagConstraints.insets = new Insets(0, 20, 15, 0);
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.insets = zeroInsets;
        ++gridBagConstraints.gridy;
        this.legendLabel = new JLabel(Resources.getString("management.delete.legendNote"));
        this.legendLabel.setVisible(false);
        this.legendLabel.setFont(GUIFactory.FONT_SMALL);
        gridBagConstraints.insets = new Insets(0, 22, 0, 0);
        this.add((Component)this.legendLabel, gridBagConstraints);
        gridBagConstraints.insets = zeroInsets;
        ++gridBagConstraints.gridy;
        this.legend = new ArraySelectionPanel(1);
        gridBagConstraints.insets = new Insets(0, 20, 15, 0);
        gridBagConstraints.fill = 0;
        this.add((Component)this.legend, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = zeroInsets;
        ++gridBagConstraints.gridy;
        this.legend.addPropertyChangeListener("ArrayIndex", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                DeleteArrayPane.this.setArrayIndex(DeleteArrayPane.this.legend, n);
            }
        });
        this.drivePanel.addPropertyChangeListener("ArrayIndex", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                DeleteArrayPane.this.setArrayIndex(DeleteArrayPane.this.drivePanel, n);
            }
        });
        StepByStepPanel stepByStepPanel3 = new StepByStepPanel(Resources.getImage("icon.step.two"), Resources.getString("management.delete.confirmation"));
        this.add((Component)stepByStepPanel3, gridBagConstraints);
        ++gridBagConstraints.gridy;
        JPanel jPanel2 = GUIFactory.newPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridwidth = 1;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.fill = 2;
        int n = 0;
        this.confirmCheckBox = GUIFactory.newCheckBox(Resources.getString("management.delete.iUnderstand"));
        this.confirmCheckBox.setFont(GUIFactory.FONT_SMALL);
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = n++;
        jPanel2.add((Component)this.confirmCheckBox, gridBagConstraints3);
        this.confirmCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = DeleteArrayPane.this.confirmCheckBox.isSelected();
                DeleteArrayPane.this.drivePanel.setConfirmed(bl);
            }
        });
        gridBagConstraints.insets = new Insets(0, 20, 15, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        this.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.insets = zeroInsets;
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridy;
        this.add((Component)stepByStepPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.summaryLabel.setFont(GUIFactory.FONT_SMALL);
        this.summaryLabel.setEditable(false);
        this.summaryLabel.setOpaque(false);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 15, 0);
        this.add((Component)this.summaryLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = zeroInsets;
        ++gridBagConstraints.gridy;
        JPanel jPanel3 = GUIFactory.newPanel();
        jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.gridwidth = 1;
        gridBagConstraints4.gridheight = 1;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.fill = 1;
        this.restartLabel = new RestartRequiredLabel();
        this.restartLabel.setVisible(false);
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.insets = new Insets(0, 3, 0, 0);
        jPanel3.add((Component)this.restartLabel, gridBagConstraints4);
        gridBagConstraints4.weightx = 0.0;
        gridBagConstraints4.insets = new Insets(0, 0, 0, 0);
        ++gridBagConstraints4.gridx;
        JButton jButton = GUIFactory.newCancelButton();
        jPanel3.add((Component)jButton, gridBagConstraints4);
        ++gridBagConstraints4.gridx;
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionEvent actionEvent2 = new ActionEvent(DeleteArrayPane.this, 1001, "CANCEL");
                DeleteArrayPane.this.fireActionPerformed(actionEvent2);
            }
        });
        jPanel3.add(Box.createHorizontalStrut(10), gridBagConstraints4);
        ++gridBagConstraints4.gridx;
        jPanel3.add((Component)this.deleteButton, gridBagConstraints4);
        ++gridBagConstraints4.gridx;
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionEvent actionEvent2 = new ActionEvent(DeleteArrayPane.this, 1001, "APPLY");
                DeleteArrayPane.this.fireActionPerformed(actionEvent2);
            }
        });
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 2;
        this.add((Component)jPanel3, gridBagConstraints);
        ++gridBagConstraints.gridy;
    }

    public void populateUI(DataModel dataModel) {
        if (dataModel.getClass() != (class$com$apple$xsr$DeleteArrayModel == null ? (class$com$apple$xsr$DeleteArrayModel = DeleteArrayPane.class$("com.apple.xsr.DeleteArrayModel")) : class$com$apple$xsr$DeleteArrayModel)) {
            throw new IllegalArgumentException("illegal data model type " + dataModel.getClass());
        }
        if (dataModel != null) {
            DeleteArrayModel deleteArrayModel = (DeleteArrayModel)dataModel;
            this.system = new RaidSystem(deleteArrayModel.getRaidSystem());
            this.drivePanel.configureForRaidSystem(this.system);
            this.legend.configureForRaidSystem(this.system);
            this.legendLabel.setVisible(this.system.hasRaidOrJbodDisks());
        }
        this.validateUI((DataModel)null);
    }

    public boolean validateUI(DataModel dataModel) {
        if (dataModel != null) {
            DeleteArrayModel deleteArrayModel = (DeleteArrayModel)dataModel;
            deleteArrayModel.setArrayIndex(this.drivePanel.getArrayIndex());
        }
        return true;
    }

    private void setArrayIndex(Component component, int n) {
        boolean bl = false;
        if (component == this.drivePanel) {
            this.legend.setArrayIndex(n);
        } else if (component == this.legend) {
            this.drivePanel.setArrayIndex(n);
        }
        if (n > 0) {
            RaidSet raidSet = this.system.getRaidSet(n);
            if (raidSet != null) {
                bl = raidSet.getController().getRaidSets().size() == 1;
            }
        } else if (DriveSelectionPanel.isJbod(n)) {
            bl = true;
        }
        this.restartLabel.setVisible(bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

