/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.xsr.som.RaidSystem;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DataModel {
    private RaidSystem system;
    private static int INITIAL_CAPACITY = 20;
    private Map data = new HashMap(INITIAL_CAPACITY);
    private boolean modelChanged = false;

    public DataModel() {
    }

    public DataModel(RaidSystem raidSystem) {
        this.system = raidSystem;
    }

    public void setRaidSystem(RaidSystem raidSystem) {
        this.system = raidSystem;
    }

    public RaidSystem getRaidSystem() {
        return this.system;
    }

    public void reset() {
        this.data = new HashMap(INITIAL_CAPACITY);
        this.modelChanged = false;
    }

    public void putField(String string, Object object, Class clazz) {
        Field field = (Field)this.data.get(string);
        if (field == null) {
            this.data.put(string, new Field(object));
        } else if (object == null || field.value == null) {
            if (object != null || field.value != null) {
                field.value = object;
                field.changed = true;
                this.modelChanged = true;
            }
        } else if (!field.value.equals(object)) {
            field.value = object;
            field.changed = true;
            this.modelChanged = true;
        }
    }

    public Object getField(String string) {
        Field field = (Field)this.data.get(string);
        if (field != null) {
            return field.value;
        }
        return null;
    }

    public boolean modelChanged() {
        return this.modelChanged;
    }

    public boolean fieldChanged(String string) {
        Field field = (Field)this.data.get(string);
        if (field != null) {
            return field.changed;
        }
        return false;
    }

    public Set keySet() {
        return this.data.keySet();
    }

    public Collection fieldSet() {
        return this.data.values();
    }

    public Set changedKeySet() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.data.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Field field = (Field)entry.getValue();
            if (!field.changed) continue;
            hashSet.add(entry.getKey());
        }
        return hashSet;
    }

    public Set changedFieldSet() {
        HashSet<Field> hashSet = new HashSet<Field>();
        Iterator iterator = this.data.values().iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (!field.changed) continue;
            hashSet.add(field);
        }
        return hashSet;
    }

    public static class Field {
        Object value;
        boolean changed;

        public Field(Object object) {
            this.value = object;
        }
    }
}

