/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.util.Gestalt;
import com.apple.xsr.AbstractManagementPane;
import com.apple.xsr.AquaInformationPanel;
import com.apple.xsr.ArraySelectionPanel;
import com.apple.xsr.CreateArrayModel;
import com.apple.xsr.DataModel;
import com.apple.xsr.DriveInformationPanel;
import com.apple.xsr.DriveSelectionPanel;
import com.apple.xsr.RadioButtonGroup;
import com.apple.xsr.Resources;
import com.apple.xsr.RestartRequiredLabel;
import com.apple.xsr.StepByStepPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextPane;

public class CreateArrayPane
extends AbstractManagementPane {
    private static final Insets zeroInsets = new Insets(0, 0, 0, 0);
    private final int LEFT_INDENT_1 = 20;
    private final int LEFT_INDENT_2 = 22;
    private final int STEP_VSPACE = 15;
    static final int DRIVE_EMPTY = -4;
    static final int DRIVE_OFFLINE = -3;
    static final int DRIVE_ASSIGNED = -2;
    static final int DRIVE_SELECTED = -1;
    static final int DRIVE_AVAILABLE = 0;
    static final int RAID_0 = 0;
    static final int RAID_1 = 1;
    static final int RAID_3 = 2;
    static final int RAID_5 = 3;
    static final int RAID_01 = 4;
    static final int JBOD = 255;
    static final int[] levels = new int[]{0, 1, 2, 3, 4, 255};
    static String[] levelNames = new String[]{Resources.getString("management.create.raid0"), Resources.getString("management.create.raid1"), Resources.getString("management.create.raid3"), Resources.getString("management.create.raid5"), Resources.getString("management.create.raid01"), Resources.getString("management.create.jbod")};
    static String[] levelDescriptions = new String[]{Resources.getString("management.create.raid0.note"), Resources.getString("management.create.raid1.note"), Resources.getString("management.create.raid3.note"), Resources.getString("management.create.raid5.note"), Resources.getString("management.create.raid01.note"), Resources.getString("management.create.jbod.note")};
    static ImageIcon[] levelIcons = new ImageIcon[]{new ImageIcon(Resources.getImage("icon.raid0")), new ImageIcon(Resources.getImage("icon.raid1")), new ImageIcon(Resources.getImage("icon.raid3")), new ImageIcon(Resources.getImage("icon.raid5")), new ImageIcon(Resources.getImage("icon.raid01")), new ImageIcon(Resources.getImage("icon.jbod"))};
    int[] driveAssignments = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    int[] driveCapacities = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    String[] arrayDescriptions = new String[0];
    RadioButtonGroup levelButtonGroup;
    AquaInformationPanel levelInfo;
    DriveSelectionPanel drivePanel;
    JLabel legendLabel;
    ArraySelectionPanel legend;
    StepByStepPanel summaryHeader;
    JTextPane summaryLabel;
    JButton createButton;
    JCheckBox backgroundCheckBox;
    JTextArea backgroundLabel;
    private static final int preferredWidth = 664;
    private static final int preferredHeight = Gestalt.isAquaLookAndFeel ? 644 : 678;
    static /* synthetic */ Class class$com$apple$xsr$CreateArrayModel;

    public CreateArrayPane() {
        super(664, preferredHeight);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        boolean bl = false;
        StepByStepPanel stepByStepPanel = new StepByStepPanel(Resources.getImage("icon.step.four"), Resources.getString("management.create.summary"));
        this.summaryLabel = GUIFactory.newTextPane("", 2);
        this.createButton = GUIFactory.newButton(Resources.getString("management.create.createButton"));
        StepByStepPanel stepByStepPanel2 = new StepByStepPanel(Resources.getImage("icon.step.one"), Resources.getString("management.create.selectLevel"));
        this.add((Component)stepByStepPanel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.levelInfo = new AquaInformationPanel(null, levelDescriptions[0]);
        DriveInformationPanel driveInformationPanel = new DriveInformationPanel(null, Resources.getString("management.driveInfo.note"));
        JPanel jPanel = GUIFactory.newPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        this.levelButtonGroup = new RadioButtonGroup();
        JRadioButton[] jRadioButtonArray = new JRadioButton[levelNames.length];
        for (int i = 0; i < levelNames.length; ++i) {
            jRadioButtonArray[i] = GUIFactory.newRadioButton(levelNames[i], true);
            jRadioButtonArray[i].setFont(GUIFactory.FONT_SMALL);
            this.levelButtonGroup.add(jRadioButtonArray[i]);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = i;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 20);
            gridBagConstraints2.anchor = 11;
            gridBagConstraints2.fill = 1;
            jPanel.add((Component)jRadioButtonArray[i], gridBagConstraints2);
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = zeroInsets;
            gridBagConstraints2.fill = 0;
            jRadioButtonArray[i].addActionListener(new RaidLevelGroupActionListener(levels[i]));
        }
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridheight = 6;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        jPanel.add((Component)this.levelInfo, gridBagConstraints2);
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.fill = 0;
        gridBagConstraints.insets = new Insets(0, 20, 15, 0);
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.insets = zeroInsets;
        ++gridBagConstraints.gridy;
        StepByStepPanel stepByStepPanel3 = new StepByStepPanel(Resources.getImage("icon.step.two"), Resources.getString("management.create.selectDrives"));
        this.add((Component)stepByStepPanel3, gridBagConstraints);
        ++gridBagConstraints.gridy;
        JPanel jPanel2 = GUIFactory.newPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.insets = new Insets(0, 0, 6, 0);
        gridBagConstraints3.weightx = 1.0;
        jPanel2.add((Component)driveInformationPanel, gridBagConstraints3);
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.insets = zeroInsets;
        gridBagConstraints3.fill = 0;
        this.drivePanel = new DriveSelectionPanel(1, driveInformationPanel, stepByStepPanel, this.summaryLabel, this.createButton);
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = new Insets(0, 0, 0, 20);
        jPanel2.add((Component)this.drivePanel, gridBagConstraints3);
        gridBagConstraints3.insets = zeroInsets;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.insets = zeroInsets;
        ++gridBagConstraints.gridy;
        this.legendLabel = new JLabel(Resources.getString("management.create.legendNote"));
        this.legendLabel.setVisible(false);
        this.legendLabel.setFont(GUIFactory.FONT_SMALL);
        gridBagConstraints.insets = new Insets(0, 22, 0, 0);
        this.add((Component)this.legendLabel, gridBagConstraints);
        gridBagConstraints.insets = zeroInsets;
        ++gridBagConstraints.gridy;
        this.legend = new ArraySelectionPanel(0);
        gridBagConstraints.insets = new Insets(0, 21, 15, 0);
        this.add((Component)this.legend, gridBagConstraints);
        gridBagConstraints.insets = zeroInsets;
        ++gridBagConstraints.gridy;
        StepByStepPanel stepByStepPanel4 = new StepByStepPanel(Resources.getImage("icon.step.three"), Resources.getString("management.create.options"));
        this.add((Component)stepByStepPanel4, gridBagConstraints);
        ++gridBagConstraints.gridy;
        JPanel jPanel3 = GUIFactory.newPanel();
        jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridwidth = 1;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.fill = 2;
        int n = 0;
        this.backgroundCheckBox = GUIFactory.newCheckBox(Resources.getString("management.create.background"));
        this.backgroundCheckBox.setFont(GUIFactory.FONT_SMALL);
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = n++;
        jPanel3.add((Component)this.backgroundCheckBox, gridBagConstraints4);
        this.backgroundLabel = new JTextArea(Resources.getString("management.create.background.note"));
        this.backgroundLabel.setEditable(false);
        this.backgroundLabel.setOpaque(false);
        this.backgroundLabel.setHighlighter(null);
        this.backgroundLabel.setFont(GUIFactory.FONT_SMALL);
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = n++;
        gridBagConstraints4.insets = new Insets(2, 22, 6, 0);
        jPanel3.add((Component)this.backgroundLabel, gridBagConstraints4);
        gridBagConstraints4.insets = zeroInsets;
        gridBagConstraints.insets = new Insets(0, 20, 15, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        this.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.insets = zeroInsets;
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridy;
        this.add((Component)stepByStepPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        JPanel jPanel4 = GUIFactory.newPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel4.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.fill = 2;
        this.summaryLabel.setFont(GUIFactory.FONT_SMALL);
        this.summaryLabel.setEditable(false);
        this.summaryLabel.setOpaque(false);
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.weighty = 1.0;
        gridBagConstraints5.fill = 1;
        jPanel4.add((Component)this.summaryLabel, gridBagConstraints5);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 15, 0);
        this.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = zeroInsets;
        ++gridBagConstraints.gridy;
        JPanel jPanel5 = GUIFactory.newPanel();
        jPanel5.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 0;
        gridBagConstraints6.gridwidth = 1;
        gridBagConstraints6.gridheight = 1;
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.fill = 1;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.insets = new Insets(0, 3, 0, 0);
        jPanel5.add((Component)new RestartRequiredLabel(), gridBagConstraints6);
        gridBagConstraints6.weightx = 0.0;
        gridBagConstraints6.insets = new Insets(0, 0, 0, 0);
        ++gridBagConstraints6.gridx;
        JButton jButton = GUIFactory.newButton(Resources.getString("management.cancelButton"));
        jPanel5.add((Component)jButton, gridBagConstraints6);
        ++gridBagConstraints6.gridx;
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionEvent actionEvent2 = new ActionEvent(CreateArrayPane.this, 1001, "CANCEL");
                CreateArrayPane.this.fireActionPerformed(actionEvent2);
            }
        });
        jPanel5.add(Box.createHorizontalStrut(10), gridBagConstraints6);
        ++gridBagConstraints6.gridx;
        jPanel5.add((Component)this.createButton, gridBagConstraints6);
        ++gridBagConstraints6.gridx;
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionEvent actionEvent2 = new ActionEvent(CreateArrayPane.this, 1001, "APPLY");
                CreateArrayPane.this.fireActionPerformed(actionEvent2);
            }
        });
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 2;
        this.add((Component)jPanel5, gridBagConstraints);
        ++gridBagConstraints.gridy;
    }

    public void populateUI(DataModel dataModel) throws IllegalArgumentException {
        if (dataModel != null) {
            if (dataModel.getClass() != (class$com$apple$xsr$CreateArrayModel == null ? (class$com$apple$xsr$CreateArrayModel = CreateArrayPane.class$("com.apple.xsr.CreateArrayModel")) : class$com$apple$xsr$CreateArrayModel)) {
                throw new IllegalArgumentException("illegal data model type " + dataModel.getClass());
            }
            CreateArrayModel createArrayModel = (CreateArrayModel)dataModel;
            this.levelButtonGroup.setSelectedIndex(createArrayModel.getLevel());
            this.drivePanel.setRaidSystem(createArrayModel.getRaidSystem());
            this.legend.setRaidSystem(createArrayModel.getRaidSystem());
            this.legendLabel.setVisible(createArrayModel.getRaidSystem().hasRaidOrJbodDisks());
            this.backgroundCheckBox.setSelected(createArrayModel.getBackgroundInitEnabled());
        }
        this.validateUI((DataModel)null);
    }

    public boolean validateUI(DataModel dataModel) {
        if (dataModel != null) {
            CreateArrayModel createArrayModel = (CreateArrayModel)dataModel;
            createArrayModel.setLevel(this.drivePanel.getLevel());
            createArrayModel.setDriveStates(this.drivePanel.getDriveStates());
            createArrayModel.setDriveArrays(this.drivePanel.getDriveArrays());
            createArrayModel.setBackgroundInitEnabled(this.backgroundCheckBox.isSelected());
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class RaidLevelGroupActionListener
    implements ActionListener {
        int level;

        RaidLevelGroupActionListener(int n) {
            this.level = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = CreateArrayPane.this.levelButtonGroup.getSelectedIndex();
            if (n == -1) {
                return;
            }
            CreateArrayPane.this.levelInfo.setIcon(levelIcons[n]);
            CreateArrayPane.this.levelInfo.setText(levelDescriptions[n]);
            CreateArrayPane.this.drivePanel.setLevel(this.level);
            CreateArrayPane.this.drivePanel.syncSummary();
            String string = Resources.getString(this.level != 255 ? "management.create.createButton" : "management.create.createButton.jbod");
            CreateArrayPane.this.createButton.setText(string);
            boolean bl = this.level != 255;
            CreateArrayPane.this.backgroundCheckBox.setEnabled(bl);
            CreateArrayPane.this.backgroundLabel.setEnabled(bl);
        }
    }
}

