/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.util.Gestalt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class AquaToolBar
extends JToolBar {
    private static final Insets MARGIN = new Insets(0, 10, 0, 10);
    private static final Insets BUTTON_MARGIN = new Insets(0, 1, 0, 1);
    private static final Color LIGHT_LINE = Color.getHSBColor(0.0f, 0.0f, 0.969f);
    private static final Color DARK_LINE = Color.getHSBColor(0.0f, 0.0f, 0.957f);
    private static final Color LAST_LINE = Color.getHSBColor(0.0f, 0.0f, 0.67f);
    private static final Color SEPARATOR_COLOR = Color.getHSBColor(0.0f, 0.0f, 0.54f);
    private static int SEPARATOR_MARGIN = 8;
    private boolean macLookAndFeel = false;

    public AquaToolBar() {
        super(null, 0);
        this.setOpaque(false);
        this.setFloatable(false);
        this.setMargin(MARGIN);
        if (Gestalt.isMacLookAndFeel) {
            this.setBorderPainted(true);
        }
    }

    public void addButton(AbstractButton abstractButton) {
        abstractButton.setBorderPainted(false);
        abstractButton.setHorizontalTextPosition(0);
        abstractButton.setVerticalTextPosition(3);
        abstractButton.setContentAreaFilled(false);
        abstractButton.setFont(GUIFactory.FONT_SMALL);
        abstractButton.setMargin(BUTTON_MARGIN);
        this.add(abstractButton);
    }

    public void addSeparator() {
        this.add(this.makeSeparator(null));
    }

    public void addSeparator(Dimension dimension) {
        this.add(this.makeSeparator(dimension));
    }

    private Component makeSeparator(Dimension dimension) {
        JComponent jComponent = Gestalt.isMacLookAndFeel ? new AquaToolBarSeparator() : (dimension != null ? new JToolBar.Separator(dimension) : new JToolBar.Separator());
        return jComponent;
    }

    protected void paintBorder(Graphics graphics) {
        if (this.isBorderPainted()) {
            if (Gestalt.isMacLookAndFeel) {
                int n = this.getWidth();
                int n2 = this.getHeight();
                graphics.setColor(LAST_LINE);
                graphics.drawLine(0, n2 - 1, n, n2 - 1);
            } else {
                super.paintBorder(graphics);
            }
        }
    }

    protected void paintComponent(Graphics graphics) {
        if (Gestalt.isMacLookAndFeel) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            for (int i = 0; i < n2 - 1; ++i) {
                graphics.setColor(LIGHT_LINE);
                graphics.drawLine(0, i, n, i++);
                graphics.drawLine(0, i, n, i++);
                graphics.setColor(DARK_LINE);
                graphics.drawLine(0, i, n, i++);
                graphics.drawLine(0, i, n, i);
            }
        }
        super.paintComponent(graphics);
    }

    class AquaToolBarSeparator
    extends JPanel {
        AquaToolBarSeparator() {
        }

        public void paint(Graphics graphics) {
            int n = 1 + this.getWidth() / 2;
            int n2 = this.getHeight();
            graphics.setColor(SEPARATOR_COLOR);
            for (int i = 1; i < n2 - 1; i += 3) {
                graphics.fillRect(n, i, 1, 1);
            }
        }

        public Dimension getMaximumSize() {
            return new Dimension(1 + SEPARATOR_MARGIN * 2, 128);
        }
    }
}

