/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import javax.swing.JComponent;
import javax.swing.Timer;

class AquaProgressClock
extends JComponent {
    public static final int FRAME_INTERVAL = 66;
    private static final Dimension dimensions = new Dimension(20, 20);
    private static final double innerRadius = 5.0;
    private static final double outerRadius = 8.5;
    private static final Line2D.Double[] line = new Line2D.Double[12];
    private static final Color[] colorTableNormal = new Color[12];
    private static final Color[] colorTableSelected = new Color[12];
    private static final Stroke stroke = new BasicStroke(1.5f, 2, 1);
    private int frame = 0;
    private Timer timer = null;
    private boolean selected = false;

    AquaProgressClock() {
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Stroke stroke = ((Graphics2D)graphics).getStroke();
        ((Graphics2D)graphics).setStroke(AquaProgressClock.stroke);
        if (this.selected) {
            for (int i = 0; i < 12; ++i) {
                graphics.setColor(colorTableSelected[(i + this.frame) % 12]);
                ((Graphics2D)graphics).draw(line[i]);
            }
        } else {
            for (int i = 0; i < 12; ++i) {
                graphics.setColor(colorTableNormal[(i + this.frame) % 12]);
                ((Graphics2D)graphics).draw(line[i]);
            }
        }
        ((Graphics2D)graphics).setStroke(stroke);
    }

    public void startAnimation() {
        if (this.timer == null) {
            this.timer = new Timer(66, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AquaProgressClock.this.frame = AquaProgressClock.this.frame == 0 ? 11 : AquaProgressClock.this.frame - 1;
                    AquaProgressClock.this.repaint();
                }
            });
            this.timer.setRepeats(true);
            this.timer.start();
        }
    }

    public void stopAnimation() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public void advanceFrame() {
        this.frame = this.frame == 0 ? 11 : this.frame - 1;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public Dimension getMinimumSize() {
        return dimensions;
    }

    public Dimension getPreferredSize() {
        return dimensions;
    }

    public Dimension getMaximumSize() {
        return dimensions;
    }

    static {
        for (int i = 0; i < 12; ++i) {
            double d = (double)i / 6.0 * Math.PI;
            double d2 = 9.25 + (double)((int)(5.0 * Math.cos(d)));
            double d3 = 9.25 + (double)((int)(5.0 * Math.sin(d)));
            double d4 = 9.25 + (double)((int)(8.5 * Math.cos(d)));
            double d5 = 9.25 + (double)((int)(8.5 * Math.sin(d)));
            AquaProgressClock.line[i] = new Line2D.Double(d2, d3, d4, d5);
            AquaProgressClock.colorTableNormal[i] = Color.getHSBColor(0.0f, 0.0f, 0.7f - (float)i / 11.0f * 0.55f);
            AquaProgressClock.colorTableSelected[i] = Color.getHSBColor(0.5972222f, 0.73f - (float)i / 11.0f * 0.73f, 1.0f - (float)i / 11.0f * 0.13f);
        }
    }
}

