/*
 * Decompiled with CFR 0.152.
 */
package com.apple.util.prefs;

import com.apple.util.plist.PropertyListUtilities;
import com.apple.util.prefs.PreferencesFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class Preferences {
    public final Object lock = new Object();
    protected String identifier;
    protected Map dictionary;
    protected Map defaults = new HashMap();
    protected boolean loaded;
    protected int changeCount;
    protected ArrayList preferenceChangeListeners = new ArrayList();

    public static Preferences getPreferences(String string) {
        return PreferencesFactory.getPreferences(string);
    }

    public Preferences() {
    }

    public Preferences(String string) {
        this.identifier = string;
    }

    public ArrayList getArray(String string, ArrayList arrayList) {
        return (ArrayList)this.get(string, arrayList);
    }

    public void setArray(String string, ArrayList arrayList) {
        this.set(string, arrayList);
    }

    public boolean getBoolean(String string, boolean bl) {
        Boolean bl2 = (Boolean)this.get(string, null);
        return bl2 != null ? bl2 : bl;
    }

    public void setBoolean(String string, boolean bl) {
        this.set(string, new Boolean(bl));
    }

    public byte[] getData(String string, byte[] byArray) {
        return (byte[])this.get(string, byArray);
    }

    public void setData(String string, byte[] byArray) {
        this.set(string, byArray);
    }

    public Date getDate(String string, Date date) {
        return (Date)this.get(string, date);
    }

    public void setDate(String string, Date date) {
        this.set(string, date);
    }

    public Map getDictionary(String string, Map map) {
        return (Map)this.get(string, map);
    }

    public void setDictionary(String string, Map map) {
        this.set(string, map);
    }

    public byte getByte(String string, byte by) {
        Number number = (Number)this.get(string, null);
        return number != null ? number.byteValue() : by;
    }

    public void setByte(String string, byte by) {
        this.set(string, new Long(by));
    }

    public short getShort(String string, short s) {
        Number number = (Number)this.get(string, null);
        return number != null ? number.shortValue() : s;
    }

    public void setShort(String string, short s) {
        this.set(string, new Long(s));
    }

    public int getInteger(String string, int n) {
        Number number = (Number)this.get(string, null);
        return number != null ? number.intValue() : n;
    }

    public void setInteger(String string, int n) {
        this.set(string, new Long(n));
    }

    public long getLong(String string, long l) {
        Number number = (Number)this.get(string, null);
        return number != null ? number.longValue() : l;
    }

    public void setLong(String string, long l) {
        this.set(string, new Long(l));
    }

    public float getFloat(String string, float f) {
        Number number = (Number)this.get(string, null);
        return number != null ? number.floatValue() : f;
    }

    public void setFloat(String string, float f) {
        this.set(string, new Double(f));
    }

    public double getDouble(String string, double d) {
        Number number = (Number)this.get(string, null);
        return number != null ? number.doubleValue() : d;
    }

    public void setDouble(String string, double d) {
        this.set(string, new Double(d));
    }

    public String getString(String string, String string2) {
        return (String)this.get(string, string2);
    }

    public void setString(String string, String string2) {
        this.set(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.prepare();
            return this.dictionary.get(string) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String string, Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            this.prepare();
            Object object3 = this.dictionary.get(string);
            if (object3 == null && (object3 = this.defaults.get(string)) == null) {
                object3 = object;
            }
            if (object3 != null) {
                object3 = PropertyListUtilities.deepCopy(object3);
            }
            return object3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(String string, Object object) {
        Object object2;
        Object object3;
        boolean bl = false;
        Object object4 = this.lock;
        synchronized (object4) {
            this.prepare();
            if (object != null) {
                if (!PropertyListUtilities.isCompatibleObject(object)) {
                    throw new IllegalArgumentException("object is not plist compatible (" + object.getClass().toString() + ")");
                }
                object3 = this.dictionary.get(string);
                if (object3 == null || !object3.equals(object)) {
                    object2 = PropertyListUtilities.deepCopy(object);
                    object3 = this.dictionary.put(string, object2);
                    ++this.changeCount;
                    bl = true;
                } else {
                    object2 = null;
                }
            } else {
                object3 = this.dictionary.remove(string);
                if (object3 != null) {
                    object2 = null;
                    ++this.changeCount;
                    bl = true;
                } else {
                    object2 = null;
                }
            }
        }
        if (bl) {
            this.fireChangeEvent(string, object3, object2);
        }
        return object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(String string) {
        Object v;
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            this.prepare();
            v = this.dictionary.remove(string);
            if (v != null) {
                ++this.changeCount;
                bl = true;
            }
        }
        if (bl) {
            this.fireChangeEvent(string, v, null);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronize() {
        Object object = this.lock;
        synchronized (object) {
            if (this.changeCount > 0) {
                this.store();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaults(Map map) {
        Object object = this.lock;
        synchronized (object) {
            this.defaults = (Map)PropertyListUtilities.deepCopy(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepare() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.loaded) {
                this.load();
                this.loaded = true;
            }
        }
    }

    public abstract void load();

    public abstract void store();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        Object object = this.lock;
        synchronized (object) {
            this.preferenceChangeListeners.add(preferenceChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        Object object = this.lock;
        synchronized (object) {
            this.preferenceChangeListeners.remove(preferenceChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChangeEvent(String string, Object object, Object object2) {
        ArrayList arrayList;
        PreferenceChangeEvent preferenceChangeEvent = new PreferenceChangeEvent(this, string, object, object2);
        Object object3 = this.lock;
        synchronized (object3) {
            arrayList = (ArrayList)this.preferenceChangeListeners.clone();
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object3 = (PreferenceChangeListener)iterator.next();
            object3.preferenceChanged(preferenceChangeEvent);
        }
    }

    public static interface PreferenceChangeListener
    extends EventListener {
        public void preferenceChanged(PreferenceChangeEvent var1);
    }

    public static class PreferenceChangeEvent
    extends EventObject {
        protected String key;
        protected Object oldValue;
        protected Object newValue;

        public PreferenceChangeEvent(Preferences preferences, String string, Object object, Object object2) {
            super(preferences);
            this.key = string;
            this.oldValue = object;
            this.newValue = object2;
        }

        public String getKey() {
            return this.key;
        }

        public Object getOldValue() {
            return this.oldValue;
        }

        public Object getNewValue() {
            return this.newValue;
        }
    }
}

