/*
 * Decompiled with CFR 0.152.
 */
package com.apple.util.plist;

import com.apple.util.plist.PropertyListException;
import com.apple.util.plist.PropertyListUtilities;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class PropertyList {
    private Object rootElement;
    private static final Logger logger = Logger.getLogger(class$com$apple$util$plist$PropertyList == null ? (class$com$apple$util$plist$PropertyList = PropertyList.class$("com.apple.util.plist.PropertyList")) : class$com$apple$util$plist$PropertyList);
    static /* synthetic */ Class class$com$apple$util$plist$PropertyList;

    public PropertyList(InputStream inputStream) throws IOException, PropertyListException {
        if (inputStream == null) {
            throw new NullPointerException("in cannot be null");
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            this.rootElement = PropertyListUtilities.readXML(bufferedReader);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PropertyListException("Error reading XML: " + unsupportedEncodingException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new PropertyListException("Error configuring XML parser: " + sAXException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new PropertyListException("Error configuring XML parser: " + parserConfigurationException.getMessage());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new PropertyListException("Error configuring XML parser: " + factoryConfigurationError.getMessage());
        }
        catch (ParseException parseException) {
            throw new PropertyListException("Error parsing XML: " + parseException.getMessage());
        }
    }

    public PropertyList(Reader reader) throws IOException, PropertyListException {
        if (reader == null) {
            throw new NullPointerException("in cannot be null");
        }
        try {
            this.rootElement = PropertyListUtilities.readXML(reader);
        }
        catch (SAXException sAXException) {
            throw new PropertyListException("Error configuring XML parser: " + sAXException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new PropertyListException("Error configuring XML parser: " + parserConfigurationException.getMessage());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new PropertyListException("Error configuring XML parser: " + factoryConfigurationError.getMessage());
        }
        catch (ParseException parseException) {
            throw new PropertyListException("Error parsing XML: " + parseException.getMessage());
        }
    }

    public PropertyList(Object object) {
        if (object == null) {
            throw new NullPointerException("root cannot be null");
        }
        if (!PropertyList.isValidElement(object)) {
            throw new IllegalArgumentException("illegal plist element " + object.getClass());
        }
        this.rootElement = object;
    }

    public PropertyList(PropertyList propertyList) {
        if (propertyList == null) {
            throw new NullPointerException("plist cannot be null");
        }
        if (propertyList.rootElement != null) {
            this.rootElement = PropertyListUtilities.deepCopy(propertyList.rootElement);
        }
    }

    public Object getRootElement() {
        return this.rootElement;
    }

    public void writeTo(OutputStream outputStream) throws PropertyListException, IOException {
        if (outputStream == null) {
            throw new NullPointerException("out cannot be null");
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        this.writeTo(bufferedWriter);
        ((Writer)bufferedWriter).flush();
    }

    public void writeTo(Writer writer) throws PropertyListException, IOException {
        if (writer == null) {
            throw new NullPointerException("writer cannot be null");
        }
        if (this.rootElement == null) {
            throw new NullPointerException("root element is null");
        }
        PropertyListUtilities.writeXML(this.rootElement, writer);
    }

    public static boolean isValidElement(Object object) {
        return object != null && (object instanceof Map || object instanceof List || object instanceof String || object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof byte[] || object instanceof Date || object instanceof Boolean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        StringWriter stringWriter = new StringWriter();
        String string = null;
        PropertyListUtilities.writeXML(this.rootElement, stringWriter);
        string = stringWriter.toString();
        Object var5_3 = null;
        if (stringWriter == null) return string;
        try {
            stringWriter.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
        {
            catch (IOException iOException) {
                Object var5_4 = null;
                if (stringWriter == null) return string;
                try {
                    stringWriter.close();
                    return string;
                }
                catch (IOException iOException2) {}
                return string;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (stringWriter == null) throw throwable;
            try {
                stringWriter.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

