/*
 * Decompiled with CFR 0.152.
 */
package com.apple.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Random;

public class SortedArrayList
implements Collection {
    private ArrayList mInternalArrayList = null;

    public SortedArrayList() {
        this.mInternalArrayList = new ArrayList();
    }

    public SortedArrayList(int n) {
        this.mInternalArrayList = new ArrayList(n);
    }

    public void add(Comparable comparable) {
        int n = this.mInternalArrayList.size() - 1;
        if (n < 0 || comparable.compareTo(this.mInternalArrayList.get(n)) >= 0) {
            this.mInternalArrayList.add(comparable);
        } else if (comparable.compareTo(this.mInternalArrayList.get(0)) <= 0) {
            this.mInternalArrayList.add(0, comparable);
        } else {
            int n2 = 0;
            boolean bl = false;
            while (!bl) {
                int n3 = (n - n2) / 2 + n2;
                int n4 = comparable.compareTo(this.mInternalArrayList.get(n3));
                if (n4 == 0 || n - n2 <= 1) {
                    this.mInternalArrayList.add(n3 + 1, comparable);
                    bl = true;
                    continue;
                }
                if (n4 < 0) {
                    n = n3;
                    continue;
                }
                n2 = n3;
            }
        }
    }

    public boolean add(Object object) {
        if (!(object instanceof Comparable)) {
            throw new IllegalArgumentException("Object o must implement Comparable interface");
        }
        this.add((Comparable)object);
        return true;
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException("SortedArrayList does not support the addAll method.");
    }

    public void clear() {
        this.mInternalArrayList.clear();
    }

    public boolean contains(Object object) {
        return this.mInternalArrayList.contains(object);
    }

    public boolean containsAll(Collection collection) {
        return this.mInternalArrayList.containsAll(collection);
    }

    public int fastIndexOf(Comparable comparable) {
        int n = -1;
        boolean bl = false;
        int n2 = 0;
        int n3 = this.mInternalArrayList.size() - 1;
        while (!bl) {
            int n4 = (n3 - n2) / 2 + n2;
            int n5 = comparable.compareTo(this.mInternalArrayList.get(n4));
            if (n5 == 0) {
                n = n4;
                bl = true;
                continue;
            }
            if (n3 - n2 <= 0) {
                bl = true;
                continue;
            }
            if (n5 < 0) {
                n3 = n4 - 1;
                continue;
            }
            n2 = n4 + 1;
        }
        return n;
    }

    public Comparable get(int n) {
        return (Comparable)this.mInternalArrayList.get(n);
    }

    public int hashCode() {
        return this.mInternalArrayList.hashCode();
    }

    public boolean isEmpty() {
        return this.mInternalArrayList.isEmpty();
    }

    public Iterator iterator() {
        return this.mInternalArrayList.iterator();
    }

    public int indexOf(Comparable comparable) {
        return this.mInternalArrayList.indexOf(comparable);
    }

    public Comparable remove(int n) {
        return (Comparable)this.mInternalArrayList.remove(n);
    }

    public boolean remove(Object object) {
        return this.mInternalArrayList.remove(object);
    }

    public boolean removeAll(Collection collection) {
        return this.mInternalArrayList.removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.mInternalArrayList.retainAll(collection);
    }

    public int size() {
        return this.mInternalArrayList.size();
    }

    public Object[] toArray() {
        return this.mInternalArrayList.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.mInternalArrayList.toArray(objectArray);
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        Random random = new Random(new Date().getTime());
        ArrayList<Integer> arrayList = new ArrayList<Integer>(10000);
        SortedArrayList sortedArrayList = new SortedArrayList(10000);
        boolean bl = true;
        Date date = new Date();
        for (int i = 0; i < 10000; ++i) {
            Integer n3 = new Integer(random.nextInt());
            arrayList.add(n3);
            sortedArrayList.add(n3);
        }
        Date date2 = new Date();
        long l = date2.getTime() - date.getTime();
        System.out.println("The UNSORTED array is: ");
        for (n2 = 0; n2 < 10000; ++n2) {
            System.out.println(arrayList.get(n2));
        }
        System.out.println("\n\nThe SORTED array is: ");
        for (n2 = 0; n2 < 10000; ++n2) {
            System.out.println(sortedArrayList.get(n2));
            if (n2 == 0 || sortedArrayList.get(n2).compareTo(sortedArrayList.get(n2 - 1)) >= 0) continue;
            bl = false;
        }
        if (bl) {
            System.out.println("\n\nInteger sorting SUCCEEDED!\nSorting time = " + l + " ms");
        } else {
            System.out.println("\n\nInteger sorting FAILED!\nSorting time = " + l + " ms");
        }
        n2 = 1;
        int n4 = 5000;
        for (n = 0; n < n4; ++n) {
            Integer n5;
            int n6;
            int n7 = random.nextInt(10000);
            int n8 = sortedArrayList.fastIndexOf(sortedArrayList.get(n7));
            if (n8 != n7) {
                System.out.println("\n\nfastIndexOf() FAILED!!!\nfastIndexOfIndex SHOULD BE: " + n7 + "\nfastIndexOfIndex actually is: " + n8);
                n2 = 0;
            }
            if ((n6 = sortedArrayList.indexOf(n5 = new Integer(random.nextInt()))) == (n8 = sortedArrayList.fastIndexOf(n5))) continue;
            System.out.println("\n\nfastIndexOf() FAILED!!! Searches returned different results!\nindexOfIndex = " + n6 + " fastIndexOfIndex = " + n8);
            n2 = 0;
        }
        n = 2 * n4;
        if (n2 != 0) {
            System.out.println("\n\nAll " + n + " calls to fastIndexOf() SUCCEEDED!");
        } else {
            System.out.println("\n\nOne or more of the " + n + " calls to fastIndexOf() FAILED!");
        }
    }
}

