/*
 * Decompiled with CFR 0.152.
 */
package com.apple.net.acp;

import com.apple.net.acp.SimpleCryptCoder;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SimpleCryptOutputStream
extends FilterOutputStream {
    private int keyIndex = 0;
    private int byteCount = 0;

    public SimpleCryptOutputStream(OutputStream outputStream) {
        super(outputStream);
        if (outputStream == null) {
            throw new NullPointerException("out cannot be null");
        }
    }

    public void write(int n) throws IOException {
        if (this.keyIndex >= SimpleCryptCoder.KEY.length) {
            this.keyIndex = 0;
        }
        this.out.write((n ^ SimpleCryptCoder.KEY[this.keyIndex] ^ 85 + this.byteCount) & 0xFF);
        ++this.keyIndex;
        ++this.byteCount;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("Buffer cannot be null.");
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            String string = "buffer length=" + byArray.length + ", off=" + n + ", len=" + n2;
            throw new IndexOutOfBoundsException(string);
        }
        for (int i = n; i < n2; ++i) {
            if (this.keyIndex >= SimpleCryptCoder.KEY.length) {
                this.keyIndex = 0;
            }
            byArray[i] = (byte)(byArray[i] ^ SimpleCryptCoder.KEY[this.keyIndex] ^ 85 + this.byteCount);
            ++this.keyIndex;
            ++this.byteCount;
        }
        this.out.write(byArray, n, n2);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void newBlock() {
        this.keyIndex = 0;
        this.byteCount = 0;
    }
}

