/*
 * Decompiled with CFR 0.152.
 */
package com.apple.net.acp;

import com.apple.util.plist.PropertyListUtilities;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;

public class AcpEventLog {
    public static final boolean DEBUG = false;
    protected ArrayList events = new ArrayList();

    public AcpEventLog() {
    }

    public AcpEventLog(String string) throws Exception {
        this(string, -1);
    }

    public AcpEventLog(String string, int n) throws Exception {
        ArrayList arrayList = (ArrayList)PropertyListUtilities.readXML(new StringReader(string));
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Event event = new Event((String)iterator.next());
            this.events.add(event);
        }
    }

    public AcpEventLog(Iterator iterator) throws Exception {
        this.appendEvents(iterator);
    }

    public AcpEventLog(Iterator iterator, int n) throws Exception {
        this.appendEvents(iterator, n);
    }

    public synchronized void appendEvents(Iterator iterator) throws Exception {
        while (iterator.hasNext()) {
            Event event = new Event((String)iterator.next());
            this.events.add(event);
        }
    }

    public synchronized void appendEvents(Iterator iterator, int n) throws Exception {
        while (iterator.hasNext()) {
            Event event = new Event((String)iterator.next(), n);
            this.events.add(event);
        }
    }

    public synchronized void clearEvents() {
        this.events.clear();
    }

    public synchronized int getEventCount() {
        return this.events.size();
    }

    public synchronized Event getEvent(int n) {
        if (n < 0 || n >= this.events.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + n);
        }
        return (Event)this.events.get(n);
    }

    public synchronized Iterator getEvents() {
        return Collections.unmodifiableList(this.events).iterator();
    }

    public synchronized Iterator getEvents(int n) {
        return Collections.unmodifiableList(this.events).listIterator(n);
    }

    public synchronized Event getFirstEvent() {
        if (this.events.isEmpty()) {
            return null;
        }
        return (Event)this.events.get(0);
    }

    public synchronized Event getLastEvent() {
        if (this.events.isEmpty()) {
            return null;
        }
        return (Event)this.events.get(this.events.size() - 1);
    }

    public static void main(String[] stringArray) {
    }

    public static class Event
    implements Comparable {
        public static final int CONTROLLER_ID_NONE = -1;
        protected static final String DATA_FORMAT = "yyyy-MM-dd HH:mm:ss";
        protected Date time;
        protected int sequenceId;
        protected int priority;
        protected int type;
        protected String message;
        protected String localizedMessage;
        protected int controllerId = -1;
        protected String description;

        public Event(String string) throws Exception {
            this.parse(string);
        }

        public Event(String string, int n) throws Exception {
            this.parse(string);
            this.controllerId = n;
        }

        protected void parse(String string) throws Exception {
            int n = string.indexOf(44);
            if (n < 0) {
                throw new StringIndexOutOfBoundsException("invalid event log time");
            }
            String string2 = string.substring(0, n);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATA_FORMAT);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.time = simpleDateFormat.parse(string2);
            int n2 = string.indexOf(44, ++n);
            if (n2 < 0) {
                throw new StringIndexOutOfBoundsException("invalid event log sequence ID");
            }
            string2 = string.substring(n, n2);
            this.sequenceId = Integer.parseInt(string2);
            n = n2 + 1;
            if ((n2 = string.indexOf(44, n)) < 0) {
                throw new StringIndexOutOfBoundsException("invalid event log priority");
            }
            string2 = string.substring(n, n2);
            this.priority = Integer.parseInt(string2);
            n = n2 + 1;
            if ((n2 = string.indexOf(44, n)) < 0) {
                throw new StringIndexOutOfBoundsException("invalid event log type");
            }
            string2 = string.substring(n, n2);
            this.type = Integer.parseInt(string2);
            n = n2 + 1;
            this.message = string.substring(n);
        }

        public Date getTime() {
            return this.time;
        }

        public int getSequenceId() {
            return this.sequenceId;
        }

        public int getPriority() {
            return this.priority;
        }

        public int getType() {
            return this.type;
        }

        public String getMessage() {
            return this.message;
        }

        public String getLocalizedMessage() {
            return this.localizedMessage != null ? this.localizedMessage : this.message;
        }

        public int getControllerId() {
            return this.controllerId;
        }

        public String getDescription() {
            return this.description;
        }

        public void setLocalizedMessage(String string) {
            this.localizedMessage = string;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Event)) {
                return false;
            }
            Event event = (Event)object;
            return event.controllerId == this.controllerId && event.time.equals(this.time) && event.sequenceId == this.sequenceId && event.priority == this.priority && event.message.equals(this.message);
        }

        public int compareTo(Object object) {
            Event event = (Event)object;
            int n = this.time.compareTo(event.time);
            if (n != 0) {
                return n * -1;
            }
            if (this.controllerId < event.controllerId) {
                return -1;
            }
            if (this.controllerId > event.controllerId) {
                return 1;
            }
            if (this.sequenceId < event.sequenceId) {
                return -1;
            }
            if (this.sequenceId > event.sequenceId) {
                return 1;
            }
            if (this.priority < event.priority) {
                return -1;
            }
            if (this.priority > event.priority) {
                return 1;
            }
            int n2 = this.message.compareToIgnoreCase(event.message);
            if (n2 != 0) {
                return n2;
            }
            return 0;
        }

        public String paramString() {
            String string = "";
            string = string + "sequenceId=" + this.sequenceId + ",";
            string = string + "time=" + this.time + ",";
            string = string + "controllerId=" + this.controllerId + ",";
            string = string + "type=" + this.type + ",";
            string = string + "priority=" + this.priority + ",";
            string = string + "message=" + this.message + ",";
            string = string + "localizedMessage=" + this.localizedMessage + ",";
            string = string + "description=" + this.description;
            return string;
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.paramString() + "]";
        }
    }
}

