/*
 * Decompiled with CFR 0.152.
 */
package com.apple.gui.text;

import java.awt.Toolkit;
import java.io.UnsupportedEncodingException;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class RestrictedDocument
extends PlainDocument {
    public static final int LENGTH_UNLIMITED = 0;
    public static final int LOWERCASE_CAPITALIZATION = -1;
    public static final int NORMAL_CAPITALIZATION = 0;
    public static final int UPPERCASE_CAPITALIZATION = 1;
    public static final String ENCODING = "UTF-8";
    private int maxLength = 0;
    private int maxBytes = 0;
    private String allowedCharacters = null;
    private int capitalizationMode = 0;
    private boolean errorFeedbackEnabled = true;

    public RestrictedDocument() {
        this(null, 0);
    }

    public RestrictedDocument(String string, int n) {
        this.allowedCharacters = string;
        this.maxLength = n;
    }

    public void setAllowedCharacters(String string) {
        this.allowedCharacters = string;
    }

    public void setMaxLength(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("maximum length must be positive (" + n + ")");
        }
        this.maxLength = n;
    }

    public void setMaxLengthBytes(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("maximum bytes must be positive (" + n + ")");
        }
        this.maxBytes = n;
    }

    public void setCapitalizationMode(int n) {
        if (n != 0 && n != -1 && n != 1) {
            throw new IllegalArgumentException("illegal capitalization mode (" + n + ")");
        }
        this.capitalizationMode = n;
    }

    public void setErrorFeedbackEnabled(boolean bl) {
        this.errorFeedbackEnabled = bl;
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.allowedCharacters != null) {
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (this.allowedCharacters.indexOf(cArray[i]) != -1) continue;
                this.rejectInsert();
                return;
            }
        }
        if (!(this.maxBytes == 0 && this.maxLength == 0 || this.lengthPermitted(string))) {
            this.rejectInsert();
            return;
        }
        if (this.capitalizationMode == 1) {
            string = string.toUpperCase();
        } else if (this.capitalizationMode == -1) {
            string = string.toLowerCase();
        }
        super.insertString(n, string, attributeSet);
    }

    private void rejectInsert() {
        if (this.errorFeedbackEnabled) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private boolean lengthPermitted(String string) throws BadLocationException {
        int n;
        String string2;
        if (this.maxBytes != 0 && (string2 = this.getText(0, this.getLength())) != null) {
            int n2;
            try {
                n2 = string2.getBytes(ENCODING).length + string.getBytes(ENCODING).length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                n2 = string2.getBytes().length + string.getBytes().length;
            }
            if (n2 > this.maxBytes) {
                return false;
            }
        }
        return this.maxLength == 0 || (n = this.getLength() + string.length()) <= this.maxLength;
    }
}

