/*
 * Decompiled with CFR 0.152.
 */
package com.apple.gui.menu;

import com.apple.gui.menu.Menu;
import com.apple.gui.menu.MenuItem;
import com.apple.xsr.Resources;
import com.apple.xsr.SystemMonitorWindow;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class WindowMenu
extends Menu {
    private final int STATIC_ITEM_COUNT;
    protected JMenuItem minimizeItem = new MenuItem(new MinimizeAction(this));
    protected JMenuItem toolbarItem = new MenuItem(new ToolbarAction(this));
    protected JMenuItem bringAllToFrontItem = new MenuItem(new BringAllToFrontAction());

    public WindowMenu() {
        this.add(this.minimizeItem);
        this.addSeparator();
        this.add(this.toolbarItem);
        this.addSeparator();
        this.add(this.bringAllToFrontItem);
        this.addSeparator();
        this.STATIC_ITEM_COUNT = this.getItemCount();
    }

    public void setEnabled(boolean bl) {
        this.menuEnabled = bl;
    }

    protected void fireMenuSelected() {
        this.updateMenu();
        super.fireMenuSelected();
    }

    protected void updateMenu() {
        Container container = this.getTopLevelAncestor();
        if (this.isMenuEnabled()) {
            if (container != null && container instanceof Frame) {
                this.minimizeItem.setEnabled(((Frame)container).getState() == 0);
            }
            this.toolbarItem.setEnabled(container != null && container instanceof SystemMonitorWindow);
        } else {
            this.minimizeItem.setEnabled(false);
            this.toolbarItem.setEnabled(false);
        }
        this.removeDynamicItems();
        Frame[] frameArray = Frame.getFrames();
        if (frameArray != null) {
            ArrayList<WindowMenuItem> arrayList = new ArrayList<WindowMenuItem>();
            for (int i = 0; i < frameArray.length; ++i) {
                if (!frameArray[i].isShowing()) continue;
                boolean bl = false;
                if (container != null) {
                    bl = container.equals(frameArray[i]);
                }
                WindowMenuItem windowMenuItem = new WindowMenuItem(frameArray[i], bl);
                windowMenuItem.setEnabled(this.isMenuEnabled());
                arrayList.add(windowMenuItem);
            }
            if (arrayList.size() > 0) {
                Collections.sort(arrayList);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    this.add((WindowMenuItem)iterator.next());
                }
            }
        }
    }

    protected void removeDynamicItems() {
        for (int i = this.getItemCount() - 1; i > this.STATIC_ITEM_COUNT - 1; --i) {
            this.remove(i);
        }
    }

    protected JMenuBar getParentMenuBar() {
        Container container = this.getParent();
        if (container != null && container instanceof JMenuBar) {
            return (JMenuBar)container;
        }
        return null;
    }

    static class ToolbarAction
    extends AbstractAction {
        public static final String COMMAND_KEY = "toolbar";
        protected JMenu parentMenu;

        public ToolbarAction(JMenu jMenu) {
            this.parentMenu = jMenu;
            this.putValue("Name", Resources.getString("application.menu.window.toolbar.hide"));
            this.putValue("ActionCommandKey", COMMAND_KEY);
            this.putValue("AcceleratorKey", Resources.getKeyStroke("application.menu.window.toolbar.accelerator"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Container container;
            if (this.parentMenu != null && (container = this.parentMenu.getTopLevelAncestor()) != null && container instanceof SystemMonitorWindow) {
                ((SystemMonitorWindow)container).toggleToolbar();
                if (((SystemMonitorWindow)container).isToolbarVisible()) {
                    this.putValue("Name", Resources.getString("application.menu.window.toolbar.hide"));
                } else {
                    this.putValue("Name", Resources.getString("application.menu.window.toolbar.show"));
                }
            }
        }
    }

    static class BringAllToFrontAction
    extends AbstractAction {
        public static final String COMMAND_KEY = "bringalltofront";

        public BringAllToFrontAction() {
            this.putValue("Name", Resources.getString("application.menu.window.bringAllToFront"));
            this.putValue("ActionCommandKey", COMMAND_KEY);
            this.putValue("AcceleratorKey", Resources.getKeyStroke("application.menu.window.bringAllToFront.accelerator"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Frame[] frameArray = Frame.getFrames();
            if (frameArray != null) {
                for (int i = 0; i < frameArray.length; ++i) {
                    if (!frameArray[i].isShowing()) continue;
                    frameArray[i].toFront();
                }
            }
        }
    }

    static class MinimizeAction
    extends AbstractAction {
        public static final String COMMAND_KEY = "minimize";
        protected JMenu parentMenu;

        public MinimizeAction(JMenu jMenu) {
            this.parentMenu = jMenu;
            this.putValue("Name", Resources.getString("application.menu.window.minimize"));
            this.putValue("ActionCommandKey", COMMAND_KEY);
            this.putValue("AcceleratorKey", Resources.getKeyStroke("application.menu.window.minimize.accelerator"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Container container;
            if (this.parentMenu != null && (container = this.parentMenu.getTopLevelAncestor()) != null && container instanceof Frame) {
                ((Frame)container).setState(1);
            }
        }
    }

    static class WindowMenuItem
    extends JRadioButtonMenuItem
    implements Comparable {
        protected Frame frame;

        public WindowMenuItem(Frame frame, boolean bl) {
            super(frame.getTitle(), bl);
            this.frame = frame;
        }

        protected void fireActionPerformed(ActionEvent actionEvent) {
            this.frame.toFront();
            super.fireActionPerformed(actionEvent);
        }

        public int compareTo(Object object) {
            return this.frame.getTitle().compareTo(((WindowMenuItem)object).frame.getTitle());
        }
    }
}

