/*
 * Decompiled with CFR 0.152.
 */
package com.apple.gui;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;

public class TextField
extends JTextField {
    public TextField() {
        this(null, null, 0);
    }

    public TextField(int n) {
        this(null, null, n);
    }

    public TextField(String string) {
        this(null, string, 0);
    }

    public TextField(String string, int n) {
        this(null, string, n);
    }

    public TextField(Document document, String string, int n) {
        super(document, string, n);
        new TextSelector(this);
    }

    public boolean isFocusTraversable() {
        return this.isEditable();
    }

    static class TextSelector
    extends MouseAdapter
    implements FocusListener,
    CaretListener {
        JTextField textField;
        boolean mouseDown = false;

        public TextSelector(JTextField jTextField) {
            this.textField = jTextField;
            jTextField.addMouseListener(this);
            jTextField.addFocusListener(this);
            jTextField.addCaretListener(this);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseDown = true;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mouseDown = false;
        }

        public void focusGained(FocusEvent focusEvent) {
            if (!this.mouseDown && this.textField.getText() != null) {
                this.textField.setCaretPosition(0);
                this.textField.moveCaretPosition(this.textField.getText().length());
            }
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public void caretUpdate(CaretEvent caretEvent) {
            if (caretEvent.getDot() != caretEvent.getMark()) {
                if (this.textField.isEditable()) {
                    this.textField.getCaret().setVisible(false);
                }
            } else if (this.textField.hasFocus() && this.textField.isEditable()) {
                this.textField.getCaret().setVisible(true);
            }
        }
    }
}

