/*
 * Decompiled with CFR 0.152.
 */
package com.apple.gui;

import com.apple.gui.GUIFactory;
import com.apple.gui.menu.Menu;
import com.apple.util.plist.PropertyListUtilities;
import com.apple.xsr.Resources;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.MissingResourceException;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class MenuManager {
    public static final String DEFAULT_RESOURCE_PLIST = "com.apple.xsr.resources.UIResources";
    public static final String DEFAULT_MENU_BAR_ID = "default";
    public static final String MENU_ELEMENT_ID = "MENU_ELEMENT_ID";
    private static final Logger logger = Logger.getLogger(class$com$apple$gui$MenuManager == null ? (class$com$apple$gui$MenuManager = MenuManager.class$("com.apple.gui.MenuManager")) : class$com$apple$gui$MenuManager);
    private static final MenuManager INSTANCE = new MenuManager();
    private Map menuBarResources;
    private Map registry = new HashMap();
    static /* synthetic */ Class class$com$apple$gui$MenuManager;
    static /* synthetic */ Class class$com$apple$xsr$Resources;

    private MenuManager() {
        String string = DEFAULT_RESOURCE_PLIST;
        Object object = MenuManager.loadPropertyList(MenuManager.getLoader(this.getClass()), string);
        if (object != null) {
            this.parseCommonProperties(object);
            try {
                this.menuBarResources = (Map)PropertyListUtilities.extractWithPath(object, "/menu-bars");
            }
            catch (Exception exception) {
                logger.error("\"menu-bars\" dictionary not found in " + string + ". " + exception);
            }
        } else {
            logger.error("Failed to load resource plist " + string);
        }
    }

    public static MenuManager getInstance() {
        return INSTANCE;
    }

    public void register(String string, Action action) {
        if (string == null) {
            throw new NullPointerException("ID cannot be null");
        }
        this.registry.put(string, action);
    }

    public void register(String string, ActionListener actionListener) {
        if (string == null) {
            throw new NullPointerException("ID cannot be null");
        }
        this.registry.put(string, actionListener);
    }

    public void register(String string, MenuListener menuListener) {
        if (string == null) {
            throw new NullPointerException("ID cannot be null");
        }
        this.registry.put(string, menuListener);
    }

    public JMenuBar newMenuBar() {
        return this.createMenuBar(DEFAULT_MENU_BAR_ID);
    }

    public JMenuBar newMenuBar(String string) {
        return this.createMenuBar(string);
    }

    public EditMenuListener newEditMenuListener(String string, String string2, String string3, String string4) {
        return new EditMenuListener(string, string2, string3, string4);
    }

    public CloseWindowListener newCloseWindowListener() {
        return new CloseWindowListener();
    }

    public String getHelpMenuId() {
        return "application.menu.help";
    }

    public static JMenu getMenu(JMenuBar jMenuBar, String string) {
        if (jMenuBar == null) {
            throw new NullPointerException("menu bar cannot be null");
        }
        if (string == null) {
            throw new NullPointerException("menu ID cannot be null");
        }
        MenuElement[] menuElementArray = jMenuBar.getSubElements();
        for (int i = 0; i < menuElementArray.length; ++i) {
            JMenu jMenu;
            if (!(menuElementArray[i] instanceof JMenu) || !(jMenu = (JMenu)menuElementArray[i]).getClientProperty(MENU_ELEMENT_ID).equals(string)) continue;
            return jMenu;
        }
        return null;
    }

    public static JMenuItem getMenuItem(JMenu jMenu, String string) {
        if (jMenu == null) {
            throw new NullPointerException("menu cannot be null");
        }
        if (string == null) {
            throw new NullPointerException("menu item ID cannot be null");
        }
        Component[] componentArray = jMenu.getMenuComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JMenuItem jMenuItem;
            if (!(componentArray[i] instanceof JMenuItem ? (jMenuItem = (JMenuItem)componentArray[i]).getClientProperty(MENU_ELEMENT_ID).equals(string) : componentArray[i] instanceof JMenu && (jMenuItem = MenuManager.getMenuItem((JMenu)componentArray[i], string)) != null)) continue;
            return jMenuItem;
        }
        return null;
    }

    public static void setMenuEnabled(JMenu jMenu, boolean bl) {
        if (jMenu == null) {
            throw new NullPointerException("menu cannot be null");
        }
        if (jMenu instanceof Menu) {
            jMenu.setEnabled(bl);
        } else {
            MenuManager.setMenuEnabledImpl(jMenu, bl);
        }
    }

    public static void setMenuEnabledImpl(JMenu jMenu, boolean bl) {
        Component[] componentArray = jMenu.getMenuComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof JMenu) {
                MenuManager.setMenuEnabled((JMenu)componentArray[i], bl);
                continue;
            }
            if (componentArray[i] instanceof JMenuItem) {
                Action action = ((JMenuItem)componentArray[i]).getAction();
                if (action != null) {
                    action.setEnabled(bl);
                    continue;
                }
                componentArray[i].setEnabled(bl);
                continue;
            }
            if (componentArray[i] instanceof JSeparator) continue;
            componentArray[i].setEnabled(bl);
        }
    }

    public static void setMenuEnabled(JMenuBar jMenuBar, String string, boolean bl) {
        JMenu jMenu = MenuManager.getMenu(jMenuBar, string);
        if (jMenu != null) {
            MenuManager.setMenuEnabled(jMenu, bl);
        }
    }

    public static void removeActions(JMenu jMenu) {
        Component[] componentArray = jMenu.getMenuComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JMenuItem jMenuItem;
            if (componentArray[i] instanceof JMenu) {
                MenuManager.removeActions((JMenu)componentArray[i]);
                continue;
            }
            if (!(componentArray[i] instanceof JMenuItem) || (jMenuItem = (JMenuItem)componentArray[i]).getAction() == null) continue;
            jMenuItem.setAction(null);
        }
    }

    private void parseCommonProperties(Object object) {
        try {
            String string = (String)PropertyListUtilities.extractWithPath(object, "/gui-factory");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JMenuBar createMenuBar(String string) {
        Map map = (Map)this.menuBarResources.get(string);
        if (map == null) {
            logger.error("No resources found for menu bar ID \"" + string + "\"");
            return this.newMenuBarInstance();
        }
        String string2 = null;
        try {
            string2 = (String)PropertyListUtilities.extractWithPath(map, "/class");
        }
        catch (Exception exception) {
            // empty catch block
        }
        JMenuBar jMenuBar = this.newMenuBarInstance(string2);
        try {
            List list = (List)PropertyListUtilities.extractWithPath(map, "/menus");
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                Map map2 = (Map)listIterator.next();
                JMenu jMenu = this.createMenu(map2);
                jMenuBar.add(jMenu);
            }
        }
        catch (Exception exception) {
            logger.error("\"menus\" dictionary not found for menu bar ID \"" + string + "\". " + exception);
        }
        return jMenuBar;
    }

    private JMenu createMenu(Map map) {
        Object object;
        if (map == null) {
            throw new NullPointerException("properties map cannot be null");
        }
        String string = null;
        try {
            string = (String)PropertyListUtilities.extractWithPath(map, "/class");
        }
        catch (Exception exception) {
            // empty catch block
        }
        JMenu jMenu = this.newMenuInstance(string);
        this.initGenericMenuItemProperties(jMenu, map);
        try {
            object = (String)PropertyListUtilities.extractWithPath(map, "/mnemonic-resource-key");
            jMenu.setMnemonic(Resources.getInt((String)object));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object = (Boolean)PropertyListUtilities.extractWithPath(map, "/is-tear-off");
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = null;
        try {
            object = (List)PropertyListUtilities.extractWithPath(map, "/items");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object != null) {
            ListIterator listIterator = object.listIterator();
            while (listIterator.hasNext()) {
                try {
                    JMenuItem jMenuItem;
                    Map map2 = (Map)listIterator.next();
                    String string2 = (String)PropertyListUtilities.extractWithPath(map2, "/type");
                    if (string2.equals("menu-item")) {
                        jMenuItem = this.createMenuItem(map2);
                        if (this.isExcluded(map2)) continue;
                        jMenu.add(jMenuItem);
                        continue;
                    }
                    if (string2.equals("menu")) {
                        jMenuItem = this.createMenu(map2);
                        if (this.isExcluded(map2)) continue;
                        jMenu.add(jMenuItem);
                        continue;
                    }
                    if (string2.equals("separator")) {
                        if (this.isExcluded(map2)) continue;
                        jMenu.addSeparator();
                        continue;
                    }
                    logger.warn("Unrecognized menu object type \"" + string2 + "\"");
                }
                catch (Exception exception) {
                    logger.error("Error adding item to menu " + jMenu.getClientProperty(MENU_ELEMENT_ID) + ": " + exception);
                }
            }
        }
        return jMenu;
    }

    private JMenuItem createMenuItem(Map map) {
        if (map == null) {
            throw new NullPointerException("properties map cannot be null");
        }
        String string = null;
        try {
            string = (String)PropertyListUtilities.extractWithPath(map, "/class");
        }
        catch (Exception exception) {
            // empty catch block
        }
        JMenuItem jMenuItem = this.newMenuItemInstance(string);
        this.initGenericMenuItemProperties(jMenuItem, map);
        try {
            String string2 = (String)PropertyListUtilities.extractWithPath(map, "/accelerator-resource-key");
            KeyStroke keyStroke = Resources.getKeyStroke(string2);
            if (keyStroke != null) {
                jMenuItem.setAccelerator(keyStroke);
            } else {
                logger.warn("Accelerator key stroke for menu item \"" + jMenuItem.getClientProperty(MENU_ELEMENT_ID) + "\" with resource \"" + string2 + "\" was null");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jMenuItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initGenericMenuItemProperties(JMenuItem jMenuItem, Map map) {
        Object v;
        if (jMenuItem == null) {
            throw new NullPointerException("item cannot be null");
        }
        if (map == null) {
            throw new NullPointerException("property map cannot be null");
        }
        String string = null;
        try {
            string = (String)PropertyListUtilities.extractWithPath(map, "/name-resource-key");
            if (string == null || string.length() <= 0) {
                throw new MissingResourceException("Resource content empty", (class$com$apple$xsr$Resources == null ? (class$com$apple$xsr$Resources = MenuManager.class$("com.apple.xsr.Resources")) : class$com$apple$xsr$Resources).getName(), string);
            }
            jMenuItem.setText(Resources.getString(string));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            logger.error("name-resource-key not found for " + jMenuItem.getClientProperty(MENU_ELEMENT_ID) + " in menu item dictionary. " + noSuchFieldException);
        }
        catch (MissingResourceException missingResourceException) {
            logger.error("Resource not found for \"" + string + "\"");
        }
        catch (Exception exception) {
            logger.error(exception);
        }
        try {
            String string2 = (String)PropertyListUtilities.extractWithPath(map, "/action-command-key");
            jMenuItem.setActionCommand(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = true;
        try {
            bl = (Boolean)PropertyListUtilities.extractWithPath(map, "/enabled");
        }
        catch (Exception exception) {
            // empty catch block
        }
        jMenuItem.setEnabled(bl);
        String string3 = null;
        try {
            try {
                string3 = (String)PropertyListUtilities.extractWithPath(map, "/id");
            }
            catch (Exception exception) {
                Object var8_13 = null;
                if (string3 == null || string3.length() == 0) {
                    string3 = string;
                }
            }
            Object var8_12 = null;
            if (string3 == null || string3.length() == 0) {
                string3 = string;
            }
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            if (string3 == null || string3.length() == 0) {
                string3 = string;
            }
            throw throwable;
        }
        jMenuItem.putClientProperty(MENU_ELEMENT_ID, string3);
        if (string3 != null && string3.length() > 0 && (v = this.registry.get(string3)) != null) {
            if (v instanceof Action) {
                jMenuItem.setAction((Action)v);
            } else if (v instanceof ActionListener) {
                jMenuItem.addActionListener((ActionListener)v);
            } else if (v instanceof MenuListener) {
                if (jMenuItem instanceof JMenu) {
                    ((JMenu)jMenuItem).addMenuListener((MenuListener)v);
                } else {
                    logger.error("Attempt to add MenuListener (" + v.getClass() + ") to a non-menu object " + "(" + jMenuItem.getClass() + ")");
                }
            } else {
                logger.error("Registered object for \"" + string3 + "\" is not an Action or valid listener object \"" + v.getClass() + "\"");
            }
        }
    }

    private boolean isExcluded(Map map) {
        List list = null;
        try {
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            list = (List)PropertyListUtilities.extractWithPath(map, "/excluded-lafs");
            if (list != null && lookAndFeel != null && list.contains(lookAndFeel.getID())) {
                return true;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (Exception exception) {
            logger.error(exception);
        }
        return false;
    }

    private JMenuBar newMenuBarInstance() {
        JMenuBar jMenuBar = null;
        jMenuBar = GUIFactory.newMenuBar();
        if (jMenuBar == null) {
            logger.warn("GUI factory returned a null menu bar. Using JMenuBar instead.");
            jMenuBar = new JMenuBar();
        }
        return jMenuBar;
    }

    private JMenuBar newMenuBarInstance(String string) {
        JMenuBar jMenuBar = null;
        if (string != null && string.length() > 0) {
            try {
                Class<?> clazz = Class.forName(string);
                jMenuBar = (JMenuBar)clazz.newInstance();
            }
            catch (Exception exception) {
                jMenuBar = null;
                logger.warn("Failed to instantiate menu bar class " + string + ": " + exception);
            }
        }
        if (jMenuBar == null) {
            jMenuBar = this.newMenuBarInstance();
        }
        return jMenuBar;
    }

    private JMenu newMenuInstance() {
        JMenu jMenu = null;
        jMenu = GUIFactory.newMenu();
        if (jMenu == null) {
            logger.warn("GUI factory returned a null menu. Using JMenu instead.");
            jMenu = new JMenu();
        }
        return jMenu;
    }

    private JMenu newMenuInstance(String string) {
        JMenu jMenu = null;
        if (string != null && string.length() > 0) {
            try {
                Class<?> clazz = Class.forName(string);
                jMenu = (JMenu)clazz.newInstance();
            }
            catch (Exception exception) {
                jMenu = null;
                logger.warn("Failed to instantiate class " + string + ": " + exception);
            }
        }
        if (jMenu == null) {
            jMenu = this.newMenuInstance();
        }
        return jMenu;
    }

    private JMenuItem newMenuItemInstance() {
        JMenuItem jMenuItem = null;
        jMenuItem = GUIFactory.newMenuItem();
        if (jMenuItem == null) {
            logger.warn("GUI factory returned a null menu item. Using JMenuItem instead.");
            jMenuItem = new JMenuItem();
        }
        return jMenuItem;
    }

    private JMenuItem newMenuItemInstance(String string) {
        JMenuItem jMenuItem = null;
        if (string != null && string.length() > 0) {
            try {
                Class<?> clazz = Class.forName(string);
                jMenuItem = (JMenuItem)clazz.newInstance();
            }
            catch (Exception exception) {
                jMenuItem = null;
                logger.warn("Failed to instantiate class " + string + ": " + exception);
            }
        }
        if (jMenuItem == null) {
            jMenuItem = this.newMenuItemInstance();
        }
        return jMenuItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object loadPropertyList(final ClassLoader classLoader, String string) {
        final String string2 = string.replace('.', '/') + ".plist";
        InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (classLoader != null) {
                    return classLoader.getResourceAsStream(string2);
                }
                return ClassLoader.getSystemResourceAsStream(string2);
            }
        });
        if (inputStream == null) return null;
        BufferedReader bufferedReader = null;
        bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        Object object = PropertyListUtilities.readXML(bufferedReader);
        Object var7_7 = null;
        if (bufferedReader == null) return object;
        try {
            bufferedReader.close();
            return object;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return object;
        catch (Exception exception) {
            try {
                logger.error("Error loading " + string + ". " + exception);
                Object var7_8 = null;
                if (bufferedReader == null) return null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (bufferedReader == null) throw throwable;
                try {
                    bufferedReader.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                bufferedReader.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
    }

    private static ClassLoader getLoader(Class clazz) {
        ClassLoader classLoader;
        ClassLoader classLoader2 = classLoader = clazz == null ? null : clazz.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class CloseWindowListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Component component;
            Container container;
            Window window = null;
            Object object = actionEvent.getSource();
            if (object != null && object instanceof JMenuItem && (container = ((JMenuItem)object).getParent()) != null && container instanceof JPopupMenu && (component = ((JPopupMenu)container).getInvoker()) != null) {
                window = SwingUtilities.getWindowAncestor(component);
            }
            if (window != null) {
                window.dispose();
            }
        }
    }

    public static class EditMenuListener
    implements MenuListener {
        protected String cutItemId;
        protected String copyItemId;
        protected String pasteItemId;
        protected String selectAllItemId;
        private Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();

        public EditMenuListener() {
        }

        public EditMenuListener(String string, String string2, String string3, String string4) {
            this.cutItemId = string;
            this.copyItemId = string2;
            this.pasteItemId = string3;
            this.selectAllItemId = string4;
        }

        public synchronized void setCutId(String string) {
            this.cutItemId = string;
        }

        public synchronized void setCopyId(String string) {
            this.copyItemId = string;
        }

        public synchronized void setPasteId(String string) {
            this.pasteItemId = string;
        }

        public synchronized void setSelectAllId(String string) {
            this.selectAllItemId = string;
        }

        public void menuSelected(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)menuEvent.getSource();
            this.updateMenu(jMenu);
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }

        protected synchronized void updateMenu(JMenu jMenu) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            JTextComponent jTextComponent = this.getFocusedTextComponent(jMenu);
            if (jTextComponent != null) {
                boolean bl5;
                boolean bl6 = jTextComponent.getSelectionStart() != jTextComponent.getSelectionEnd();
                boolean bl7 = jTextComponent.isEditable();
                boolean bl8 = bl5 = jTextComponent.getText().length() > 0;
                if (bl7) {
                    bl3 = true;
                }
                if (bl6) {
                    if (!(jTextComponent instanceof JPasswordField)) {
                        bl2 = true;
                        if (bl7) {
                            bl = true;
                        }
                    } else {
                        bl2 = false;
                        bl = false;
                    }
                    bl4 = true;
                } else if (bl5) {
                    bl4 = true;
                }
            }
            JMenuItem jMenuItem = MenuManager.getMenuItem(jMenu, this.cutItemId);
            JMenuItem jMenuItem2 = MenuManager.getMenuItem(jMenu, this.copyItemId);
            JMenuItem jMenuItem3 = MenuManager.getMenuItem(jMenu, this.pasteItemId);
            JMenuItem jMenuItem4 = MenuManager.getMenuItem(jMenu, this.selectAllItemId);
            if (jMenuItem != null) {
                jMenuItem.setEnabled(bl);
            }
            if (jMenuItem2 != null) {
                jMenuItem2.setEnabled(bl2);
            }
            if (jMenuItem3 != null) {
                jMenuItem3.setEnabled(bl3);
            }
            if (jMenuItem4 != null) {
                jMenuItem4.setEnabled(bl4);
            }
        }

        protected JTextComponent getFocusedTextComponent(JComponent jComponent) {
            Component component;
            Window window = SwingUtilities.getWindowAncestor(jComponent);
            if (window != null && (component = window.getFocusOwner()) != null && component instanceof JTextComponent) {
                return (JTextComponent)component;
            }
            return null;
        }

        private boolean clipboardHasContents() {
            if (this.systemClipboard != null) {
                return this.systemClipboard.getContents(null) != null;
            }
            return true;
        }
    }
}

