/*
 * Decompiled with CFR 0.152.
 */
package com.apple.gui;

import com.apple.gui.IndeterminateProgressBar;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.MemoryImageSource;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ProgressBarUI;

class IndeterminateProgressBarUI
extends ProgressBarUI {
    private static final int IMAGE_HEIGHT = 20;
    private static final int SCAN_LINE_STRIDE = 32;
    private static final int CAP_WIDTH = 4;
    private static final int NUM_FRAMES = 32;
    private static final Dimension PREFERRED_HORIZONTAL = new Dimension(146, 20);
    private JProgressBar progressBar;
    private int cachedWidth;
    private int[] pixels;
    private MemoryImageSource imageSource;
    private Image barberPoleImage;
    private Image rightCapImage;
    private Image leftCapImage;
    private Animator animator;
    private int animationIndex;
    private int repaintInterval;
    private static final Color c04 = new Color(0.0f, 0.0f, 0.0f, 0.04f);
    private static final Color c10 = new Color(0.0f, 0.0f, 0.0f, 0.1f);
    private static final Color c20 = new Color(0.0f, 0.0f, 0.0f, 0.2f);
    private static final Color c26 = new Color(0.0f, 0.0f, 0.0f, 0.26f);
    private static final short[][] BARBER_POLE_PIXELS = new short[][]{{36, 35, 35, 36, 37, 40, 44, 51, 61, 74, 87, 100, 110, 117, 121, 124, 125, 126, 126, 125, 124, 121, 117, 110, 100, 87, 74, 61, 51, 44, 40, 37, 90, 89, 88, 88, 89, 90, 93, 98, 106, 117, 130, 146, 159, 170, 178, 183, 186, 187, 188, 188, 187, 186, 183, 178, 170, 159, 146, 130, 117, 106, 98, 93, 138, 136, 135, 135, 134, 135, 136, 138, 142, 148, 156, 167, 178, 189, 197, 203, 207, 209, 210, 211, 211, 210, 209, 207, 203, 197, 189, 178, 167, 156, 148, 142, 149, 145, 143, 142, 141, 141, 142, 143, 145, 149, 155, 163, 174, 185, 196, 204, 210, 214, 216, 217, 218, 218, 217, 216, 214, 210, 204, 196, 185, 174, 163, 155, 143, 136, 132, 129, 128, 127, 127, 128, 129, 132, 136, 143, 153, 166, 179, 192, 202, 209, 213, 216, 217, 218, 218, 217, 216, 213, 209, 202, 192, 179, 166, 153, 134, 123, 115, 109, 106, 105, 104, 104, 105, 106, 109, 115, 123, 134, 148, 165, 179, 190, 198, 204, 207, 208, 209, 209, 208, 207, 204, 198, 190, 179, 165, 148, 127, 109, 95, 85, 79, 75, 73, 73, 73, 73, 75, 79, 85, 95, 109, 127, 146, 164, 178, 188, 194, 198, 200, 200, 200, 200, 198, 194, 188, 178, 164, 146, 134, 107, 84, 65, 52, 43, 37, 35, 35, 35, 35, 37, 43, 52, 65, 84, 107, 134, 157, 176, 189, 198, 204, 206, 206, 206, 206, 204, 198, 189, 176, 157, 158, 132, 103, 77, 56, 41, 31, 25, 23, 22, 22, 23, 25, 31, 41, 56, 77, 103, 132, 158, 179, 194, 204, 210, 212, 213, 213, 212, 210, 204, 194, 179, 189, 167, 141, 112, 86, 64, 49, 39, 33, 31, 39, 30, 31, 33, 39, 49, 64, 86, 112, 141, 167, 189, 204, 214, 220, 222, 223, 223, 222, 220, 214, 204, 216, 201, 179, 153, 123, 47, 75, 60, 50, 44, 42, 41, 41, 42, 44, 50, 60, 75, 97, 123, 153, 179, 201, 216, 226, 232, 234, 235, 235, 234, 232, 226, 242, 232, 216, 194, 167, 136, 109, 87, 71, 61, 55, 53, 52, 52, 53, 55, 61, 71, 87, 109, 136, 167, 194, 216, 232, 242, 248, 250, 251, 251, 250, 248, 251, 245, 235, 220, 199, 173, 143, 117, 96, 81, 71, 65, 63, 62, 62, 63, 65, 71, 81, 96, 117, 143, 173, 199, 220, 235, 245, 251, 253, 254, 254, 253, 254, 251, 246, 236, 222, 201, 177, 148, 124, 103, 89, 79, 74, 71, 71, 71, 71, 74, 79, 89, 103, 124, 148, 177, 201, 222, 236, 246, 251, 254, 254, 254, 254, 254, 251, 246, 236, 222, 202, 178, 150, 126, 106, 92, 82, 77, 74, 74, 74, 74, 77, 82, 92, 106, 126, 150, 178, 202, 222, 236, 246, 251, 254, 254, 235, 235, 235, 233, 228, 219, 206, 188, 167, 141, 120, 102, 89, 80, 75, 73, 73, 73, 73, 75, 80, 89, 102, 120, 141, 167, 188, 206, 219, 228, 233, 235}, {54, 53, 53, 54, 54, 57, 60, 66, 74, 84, 95, 105, 113, 119, 122, 125, 125, 126, 126, 125, 125, 122, 119, 113, 105, 95, 84, 74, 66, 60, 57, 54, 112, 111, 110, 110, 111, 112, 114, 118, 124, 133, 143, 155, 165, 174, 180, 184, 186, 187, 188, 188, 187, 186, 184, 180, 174, 165, 155, 143, 133, 124, 118, 114, 161, 159, 158, 158, 158, 158, 159, 161, 163, 168, 173, 180, 189, 196, 201, 206, 208, 210, 211, 211, 211, 211, 210, 208, 206, 201, 196, 189, 180, 173, 168, 163, 175, 172, 171, 170, 170, 170, 170, 171, 172, 175, 179, 184, 190, 198, 204, 209, 213, 216, 217, 218, 218, 218, 218, 217, 216, 213, 209, 204, 198, 190, 184, 179, 177, 173, 171, 169, 168, 168, 168, 168, 169, 171, 173, 177, 183, 189, 197, 203, 209, 213, 215, 217, 218, 218, 218, 218, 217, 215, 213, 209, 203, 197, 189, 183, 172, 166, 162, 160, 158, 157, 157, 157, 157, 158, 160, 162, 166, 172, 179, 187, 194, 200, 204, 206, 208, 209, 209, 209, 209, 208, 206, 204, 200, 194, 187, 179, 165, 157, 150, 145, 142, 140, 139, 139, 139, 139, 140, 142, 145, 150, 157, 165, 175, 183, 190, 195, 198, 200, 201, 201, 201, 201, 200, 198, 195, 190, 183, 175, 168, 155, 142, 132, 125, 121, 118, 117, 116, 116, 117, 118, 121, 125, 132, 142, 155, 168, 181, 191, 198, 202, 205, 206, 207, 207, 206, 205, 202, 198, 191, 181, 183, 169, 153, 139, 127, 119, 113, 110, 109, 108, 108, 109, 110, 113, 119, 127, 139, 153, 169, 183, 195, 203, 209, 212, 213, 214, 214, 213, 212, 209, 203, 195, 205, 193, 179, 162, 148, 136, 128, 122, 119, 118, 117, 117, 118, 119, 122, 128, 136, 148, 162, 179, 193, 205, 213, 219, 222, 223, 224, 224, 223, 222, 219, 213, 225, 217, 206, 192, 175, 161, 150, 142, 136, 133, 132, 131, 131, 132, 133, 136, 142, 150, 161, 175, 192, 206, 217, 225, 231, 234, 235, 236, 236, 235, 234, 231, 246, 241, 232, 220, 206, 189, 175, 163, 154, 149, 145, 144, 143, 143, 144, 145, 149, 154, 163, 175, 189, 206, 220, 232, 241, 246, 250, 251, 252, 252, 251, 250, 253, 250, 245, 237, 225, 212, 196, 183, 171, 163, 158, 155, 154, 153, 153, 154, 155, 158, 163, 171, 183, 196, 212, 225, 237, 245, 250, 253, 254, 255, 255, 254, 254, 253, 250, 246, 239, 229, 217, 203, 191, 181, 174, 170, 167, 166, 165, 165, 166, 167, 170, 174, 181, 191, 203, 217, 229, 239, 246, 250, 253, 254, 255, 255, 255, 254, 253, 251, 246, 239, 229, 218, 204, 193, 183, 176, 171, 169, 168, 167, 167, 168, 169, 171, 176, 183, 193, 204, 218, 229, 239, 246, 251, 253, 254, 255, 236, 236, 235, 235, 232, 228, 222, 214, 204, 192, 182, 174, 168, 164, 161, 161, 160, 160, 161, 161, 164, 168, 174, 182, 192, 204, 214, 222, 228, 232, 235, 235}, {167, 167, 167, 167, 166, 165, 163, 160, 155, 150, 143, 138, 133, 130, 128, 127, 126, 126, 126, 126, 127, 128, 130, 133, 138, 143, 150, 155, 160, 163, 165, 166, 194, 194, 194, 194, 194, 194, 194, 193, 193, 192, 191, 191, 190, 189, 189, 188, 188, 188, 188, 188, 188, 188, 188, 189, 189, 190, 191, 191, 192, 193, 193, 194, 217, 217, 217, 217, 217, 217, 217, 217, 216, 216, 215, 214, 214, 213, 212, 212, 211, 211, 211, 211, 211, 211, 211, 211, 212, 212, 213, 214, 214, 215, 216, 216, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 221, 221, 220, 220, 219, 219, 218, 218, 218, 218, 218, 218, 218, 218, 218, 218, 219, 219, 220, 220, 221, 221, 220, 221, 221, 221, 221, 221, 221, 221, 221, 221, 221, 220, 220, 220, 219, 219, 219, 218, 218, 218, 218, 218, 218, 218, 218, 218, 218, 219, 219, 219, 220, 220, 216, 217, 218, 218, 219, 219, 219, 219, 219, 219, 218, 218, 217, 216, 215, 213, 212, 211, 210, 210, 209, 209, 209, 209, 209, 209, 210, 210, 211, 212, 213, 215, 208, 210, 212, 213, 213, 214, 214, 214, 214, 214, 214, 213, 213, 212, 210, 208, 207, 205, 203, 202, 202, 201, 201, 201, 201, 201, 201, 202, 202, 203, 205, 207, 209, 209, 210, 210, 211, 211, 211, 211, 211, 211, 211, 211, 211, 211, 210, 210, 209, 209, 208, 208, 207, 207, 207, 207, 207, 207, 207, 207, 207, 207, 208, 208, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 236, 236, 237, 237, 237, 237, 238, 238, 238, 238, 238, 238, 238, 238, 238, 238, 238, 238, 237, 237, 237, 237, 236, 236, 236, 236, 236, 236, 236, 236, 236, 236, 252, 252, 252, 252, 252, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 255, 255, 255, 255, 255, 255, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 236, 236, 236, 236, 237, 238, 239, 242, 244, 247, 249, 252, 253, 254, 255, 255, 255, 255, 255, 255, 254, 253, 252, 249, 247, 244, 242, 239, 238, 237, 236, 236}};
    private static final int[] LEFT_CAP_PIXELS = new int[]{0x2000000, 0x2000000, 0, 0, 0x5000000, 0xA000000, 0, 0, 0x5000000, 0x14000000, 0, 0, 0x7000000, 0x1A000000, 0, 0, 0xA000000, 0x1C000000, 0, 0, 0xA000000, 0x1C000000, 0, 0, 0xA000000, 0x1C000000, 0, 0, 0xA000000, 0x1C000000, 0, 0, 0xA000000, 0x1C000000, 0, 0, 0xA000000, 0x1C000000, 0, 0, 0xA000000, 0x1C000000, 0, 0, 0xA000000, 0x1C000000, 0, 0, 0xA000000, 0x1C000000, 0, 0, 0xA000000, 0x1C000000, 0, 0, 0xA000000, 0x1C000000, 0, 0, 0xA000000, 0x1C000000, 0, 0, 0x7000000, 0x1A000000, 0x33000000, 0x42000000, 0x7000000, 0x14000000, 0x26000000, 0x33000000, 0x2000000, 0xA000000, 0x11000000, 0x1A000000, 0x2000000, 0x2000000, 0x5000000, 0xA000000};
    private static final int[] RIGHT_CAP_PIXELS = new int[]{0, 0, 0x2000000, 0x2000000, 0, 0, 0xA000000, 0x5000000, 0, 0, 0x14000000, 0x5000000, 0, 0, 0x1A000000, 0x7000000, 0, 0, 0x1C000000, 0xA000000, 0, 0, 0x1C000000, 0xA000000, 0, 0, 0x1C000000, 0xA000000, 0, 0, 0x1C000000, 0xA000000, 0, 0, 0x1C000000, 0xA000000, 0, 0, 0x1C000000, 0xA000000, 0, 0, 0x1C000000, 0xA000000, 0, 0, 0x1C000000, 0xA000000, 0, 0, 0x1C000000, 0xA000000, 0, 0, 0x1C000000, 0xA000000, 0, 0, 0x1C000000, 0xA000000, 0, 0, 0x1C000000, 0xA000000, 0x42000000, 0x33000000, 0x1A000000, 0x7000000, 0x33000000, 0x26000000, 0x14000000, 0x7000000, 0x1A000000, 0x11000000, 0xA000000, 0x2000000, 0xA000000, 0x5000000, 0x2000000, 0x2000000};

    IndeterminateProgressBarUI() {
        this.cachedWidth = IndeterminateProgressBarUI.PREFERRED_HORIZONTAL.width;
        this.repaintInterval = 15;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new IndeterminateProgressBarUI();
    }

    public void installUI(JComponent jComponent) {
        this.progressBar = (IndeterminateProgressBar)jComponent;
        this.leftCapImage = this.progressBar.createImage(new MemoryImageSource(4, 20, LEFT_CAP_PIXELS, 0, 4));
        this.rightCapImage = this.progressBar.createImage(new MemoryImageSource(4, 20, RIGHT_CAP_PIXELS, 0, 4));
        this.installDefaults();
        this.installListeners();
        this.startAnimationTimer();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.stopAnimationTimer();
        this.progressBar = null;
    }

    protected void installDefaults() {
        this.progressBar.setOpaque(false);
    }

    protected void uninstallDefaults() {
        if (this.rightCapImage != null) {
            this.rightCapImage.flush();
        }
        if (this.leftCapImage != null) {
            this.leftCapImage.flush();
        }
        if (this.barberPoleImage != null) {
            this.barberPoleImage.flush();
        }
        this.rightCapImage = null;
        this.leftCapImage = null;
        this.barberPoleImage = null;
        this.pixels = null;
    }

    protected void installListeners() {
    }

    protected void uninstallListeners() {
    }

    protected void startAnimationTimer() {
        if (this.animator == null) {
            this.animator = new Animator();
        }
        this.animator.start(this.getRepaintInterval());
    }

    protected void stopAnimationTimer() {
        if (this.animator != null) {
            this.animator.stop();
        }
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Dimension dimension = this.getInteriorSize();
        if (this.barberPoleImage == null || dimension.width != this.cachedWidth) {
            this.updatePixels(this.animationIndex);
        }
        int n = this.cachedWidth;
        int n2 = dimension.height;
        int n3 = 0;
        int n4 = 0;
        Color color = graphics.getColor();
        graphics.drawImage(this.leftCapImage, n3, n4, jComponent);
        graphics.drawImage(this.rightCapImage, n - 4, n4, jComponent);
        int n5 = n3 + 4;
        int n6 = n4 + 20;
        int n7 = n - 8;
        graphics.setColor(c26);
        graphics.fillRect(n5, n6 - 4, n7, 1);
        graphics.setColor(c20);
        graphics.fillRect(n5, n6 - 3, n7, 1);
        graphics.setColor(c10);
        graphics.fillRect(n5, n6 - 2, n7, 1);
        graphics.setColor(c04);
        graphics.fillRect(n5, n6 - 1, n7, 1);
        graphics.drawImage(this.barberPoleImage, n3 + 2, n4, jComponent);
        graphics.setColor(color);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Insets insets = this.progressBar.getInsets();
        Dimension dimension = PREFERRED_HORIZONTAL;
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        dimension.height = 20;
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        dimension.width = Short.MAX_VALUE;
        return dimension;
    }

    protected int getAnimationIndex() {
        return this.animationIndex;
    }

    protected void setAnimationIndex(int n) {
        if (n != this.animationIndex) {
            this.animationIndex = n;
        }
    }

    protected void incrementAnimationIndex() {
        int n = this.getAnimationIndex() - 1;
        if (n >= 0 && n < 32) {
            this.setAnimationIndex(n);
        } else if (n < 0) {
            this.setAnimationIndex(31);
        } else {
            this.setAnimationIndex(0);
        }
    }

    private Dimension getInteriorSize() {
        Dimension dimension = new Dimension();
        Insets insets = this.progressBar.getInsets();
        dimension.width = this.progressBar.getWidth() - (insets.right + insets.left);
        dimension.height = this.progressBar.getHeight() - (insets.top + insets.bottom);
        return dimension;
    }

    private int getRepaintInterval() {
        return this.repaintInterval;
    }

    private int[] updatePixels(int n) {
        Dimension dimension = this.getInteriorSize();
        int n2 = dimension.width - 4;
        int n3 = n2 > 32 ? n2 : IndeterminateProgressBarUI.PREFERRED_HORIZONTAL.width - 4;
        boolean bl = false;
        if (this.cachedWidth != dimension.width) {
            this.pixels = new int[n3 * 20];
            bl = true;
        }
        int n4 = BARBER_POLE_PIXELS[0].length;
        int n5 = 0;
        for (int i = 0; i < n4 / 32; ++i) {
            for (int j = n; j < n3 + n; ++j) {
                int n6 = i * 32 + (j - j / 32 * 32);
                this.pixels[n5++] = 0xFF000000 | BARBER_POLE_PIXELS[0][n6] << 16 | BARBER_POLE_PIXELS[1][n6] << 8 | BARBER_POLE_PIXELS[2][n6];
            }
        }
        if (this.cachedWidth != dimension.width || this.imageSource == null || this.barberPoleImage == null) {
            this.imageSource = new MemoryImageSource(n3, 20, this.pixels, 0, n3);
            this.imageSource.setAnimated(true);
            this.imageSource.setFullBufferUpdates(true);
            this.barberPoleImage = this.progressBar.createImage(this.imageSource);
            this.cachedWidth = dimension.width;
        }
        return this.pixels;
    }

    private class Animator
    implements ActionListener {
        private Timer timer;
        private int interval;

        private Animator() {
        }

        private void start(int n) {
            if (this.timer == null) {
                this.timer = new Timer(n, this);
            } else {
                this.timer.setDelay(n);
            }
            this.timer.start();
        }

        private void stop() {
            this.timer.stop();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            IndeterminateProgressBarUI.this.incrementAnimationIndex();
            IndeterminateProgressBarUI.this.updatePixels(IndeterminateProgressBarUI.this.getAnimationIndex());
            IndeterminateProgressBarUI.this.imageSource.newPixels();
        }
    }
}

