/*
 * Decompiled with CFR 0.152.
 */
package com.apple.gui;

import com.apple.gui.IndeterminateProgressBarUI;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.plaf.ProgressBarUI;

public class IndeterminateProgressBar
extends JProgressBar {
    private static final boolean DEBUG = false;
    protected boolean indeterminate = true;

    public IndeterminateProgressBar() {
        if (this.indeterminate) {
            this.updateUI();
        }
    }

    public void setIndeterminate(boolean bl) {
        if (this.indeterminate != bl) {
            boolean bl2 = this.indeterminate;
            this.indeterminate = bl;
            this.firePropertyChange("indeterminate", bl2, this.indeterminate);
            this.updateUI();
        }
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    public void setWidth(int n) {
        Dimension dimension = new Dimension(n, 20);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.setMaximumSize(dimension);
    }

    public void updateUI() {
        if (this.indeterminate) {
            this.setUI(IndeterminateProgressBarUI.createUI(this));
        } else {
            this.setUI((ProgressBarUI)UIManager.getUI(this));
        }
    }

    protected void paintBorder(Graphics graphics) {
        if (!this.indeterminate) {
            super.paintBorder(graphics);
        }
    }

    protected String paramString() {
        String string = this.indeterminate ? "true" : "false";
        return super.paramString() + ",indeterminate=" + string;
    }

    public static void main(String[] stringArray) {
    }
}

