/*
 * Decompiled with CFR 0.152.
 */
package com.apple.gui;

import com.apple.gui.GUIFactory;
import com.apple.gui.table.DefaultTableHeaderRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.ViewportUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class AlternatingTable
extends JTable {
    public static final int DEFAULT_ROW_HEIGHT = 20;
    private JScrollPane scrollPane;
    private MouseAdapter scrollPaneMouseListener;
    static /* synthetic */ Class class$java$lang$Object;

    public AlternatingTable() {
        this.init();
    }

    public AlternatingTable(TableModel tableModel) {
        super(tableModel);
        this.init();
    }

    public AlternatingTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.init();
    }

    public AlternatingTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.init();
    }

    public AlternatingTable(int n, int n2) {
        super(n, n2);
        this.init();
    }

    public AlternatingTable(Vector vector, Vector vector2) {
        super(vector, vector2);
        this.init();
    }

    public AlternatingTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.init();
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        super.columnMoved(tableColumnModelEvent);
        if (this.scrollPane != null) {
            this.scrollPane.repaint();
        }
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
        super.columnMarginChanged(changeEvent);
        if (this.scrollPane != null) {
            this.scrollPane.repaint();
        }
    }

    protected void init() {
        this.setRowHeight(20);
        this.setAutoResizeMode(0);
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.getSelectionModel().setSelectionMode(2);
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setDefaultRenderer(new DefaultTableHeaderRenderer());
        jTableHeader.setFont(GUIFactory.FONT_SMALL);
        this.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = AlternatingTable.class$("java.lang.Object")) : class$java$lang$Object, new StringRenderer());
        if (this.getRowCount() > 0) {
            this.setRowSelectionInterval(0, 0);
        }
    }

    protected void configureEnclosingScrollPane() {
        Container container;
        super.configureEnclosingScrollPane();
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            this.scrollPane = (JScrollPane)container;
            JViewport jViewport = this.scrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            JPanel jPanel = new JPanel();
            jPanel.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.scrollPane.setCorner("UPPER_RIGHT_CORNER", jPanel);
            JPanel jPanel2 = new JPanel();
            jPanel2.setBackground(UIManager.getColor("TableHeader.background"));
            this.scrollPane.setCorner("LOWER_RIGHT_CORNER", jPanel2);
            this.scrollPane.setBorder(BorderFactory.createLineBorder(Color.getHSBColor(0.0f, 0.0f, 0.67f), 1));
            this.scrollPane.getViewport().setUI(new LinedViewportUI(this, this.scrollPane));
            if (this.scrollPaneMouseListener == null) {
                this.scrollPaneMouseListener = new MouseAdapter(){

                    public void mousePressed(MouseEvent mouseEvent) {
                        if (AlternatingTable.this.rowAtPoint(mouseEvent.getPoint()) == -1) {
                            AlternatingTable.this.clearSelection();
                            if (AlternatingTable.this.getEditingRow() != -1) {
                                AlternatingTable.this.getCellEditor().stopCellEditing();
                            }
                        }
                    }
                };
            }
            this.scrollPane.addMouseListener(this.scrollPaneMouseListener);
        }
    }

    protected void unconfigureEnclosingScrollPane() {
        Container container;
        super.unconfigureEnclosingScrollPane();
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            jScrollPane.getViewport().updateUI();
            if (this.scrollPaneMouseListener != null) {
                jScrollPane.removeMouseListener(this.scrollPaneMouseListener);
            }
        }
        this.scrollPane = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class AlternatingTableUI
    extends TableUI {
        private static final Color darkBlue = new Color(0.239f, 0.502f, 0.875f);
        private static final Color darkGray = new Color(0.753f, 0.753f, 0.753f);
        private static final Color lightBlue = new Color(0.929f, 0.953f, 0.996f);
        private static final Color blueHLine = new Color(0.49f, 0.667f, 0.918f);
        private static final Color grayHLine = new Color(0.878f, 0.878f, 0.878f);
        private static final Color blueVLine = new Color(0.204f, 0.427f, 0.745f);
        private static final Color grayVLine = new Color(0.851f, 0.851f, 0.851f);
        protected TableUI tableUI;
        protected JTable table;

        public AlternatingTableUI(TableUI tableUI) {
            if (tableUI == null) {
                throw new NullPointerException("UI cannot be null");
            }
            this.tableUI = tableUI;
        }

        public void installUI(JComponent jComponent) {
            System.out.println("installUI called (table = " + jComponent);
            this.tableUI.installUI(jComponent);
            this.table = (JTable)jComponent;
        }

        public void uninstallUI(JComponent jComponent) {
            System.out.println("uninstallUI called (table = " + jComponent);
            this.tableUI.uninstallUI(jComponent);
            this.table = null;
        }

        public void paint(Graphics graphics, JComponent jComponent) {
            if (this.table != null) {
                if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0) {
                    return;
                }
                Rectangle rectangle = graphics.getClipBounds();
                Point point = rectangle.getLocation();
                Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
                int n = this.table.rowAtPoint(point);
                int n2 = this.table.rowAtPoint(point2);
                if (n == -1) {
                    n = 0;
                }
                if (n2 == -1) {
                    n2 = this.table.getRowCount() - 1;
                }
                int n3 = this.table.columnAtPoint(point);
                int n4 = this.table.columnAtPoint(point2);
                if (n3 == -1) {
                    n3 = 0;
                }
                if (n4 == -1) {
                    n4 = this.table.getColumnCount() - 1;
                }
                this.paintCells(graphics, n, n2, n3, n4);
            }
            this.tableUI.paint(graphics, jComponent);
        }

        public void update(Graphics graphics, JComponent jComponent) {
            this.paint(graphics, jComponent);
        }

        public Dimension getPreferredSize(JComponent jComponent) {
            return this.tableUI.getPreferredSize(jComponent);
        }

        public Dimension getMinimumSize(JComponent jComponent) {
            return this.tableUI.getMinimumSize(jComponent);
        }

        public Dimension getMaximumSize(JComponent jComponent) {
            return this.tableUI.getMaximumSize(jComponent);
        }

        public boolean contains(JComponent jComponent, int n, int n2) {
            return this.tableUI.contains(jComponent, n, n2);
        }

        public int getAccessibleChildrenCount(JComponent jComponent) {
            return this.tableUI.getAccessibleChildrenCount(jComponent);
        }

        public Accessible getAccessibleChild(JComponent jComponent, int n) {
            return this.tableUI.getAccessibleChild(jComponent, n);
        }

        private void paintCells(Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            JTableHeader jTableHeader = this.table.getTableHeader();
            TableColumn tableColumn = jTableHeader == null ? null : jTableHeader.getDraggedColumn();
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            int n5 = tableColumnModel.getColumnMargin();
            for (int i = n; i <= n2; ++i) {
                Rectangle rectangle = this.table.getCellRect(i, n3, false);
                for (int j = n3; j <= n4; ++j) {
                    TableColumn tableColumn2 = tableColumnModel.getColumn(j);
                    int n6 = tableColumn2.getWidth();
                    rectangle.width = n6 - n5;
                    if (tableColumn2 != tableColumn) {
                        this.paintCell(graphics, rectangle, i, j);
                    }
                    rectangle.x += n6;
                }
            }
            if (tableColumn != null) {
                this.paintDraggedArea(graphics, n, n2, tableColumn, jTableHeader.getDraggedDistance());
            }
            graphics.setColor(color);
        }

        private void paintDraggedArea(Graphics graphics, int n, int n2, TableColumn tableColumn, int n3) {
            int n4 = this.viewIndexForColumn(tableColumn);
            Rectangle rectangle = this.table.getCellRect(n, n4, true);
            Rectangle rectangle2 = this.table.getCellRect(n2, n4, true);
            Rectangle rectangle3 = rectangle.union(rectangle2);
            rectangle3.x += n3;
            for (int i = n; i <= n2; ++i) {
                Rectangle rectangle4 = this.table.getCellRect(i, n4, true);
                rectangle4.x += n3;
                this.paintCell(graphics, rectangle4, i, n4);
            }
        }

        private void paintCell(Graphics graphics, Rectangle rectangle, int n, int n2) {
            if (!this.table.isEditing() || this.table.getEditingRow() != n || this.table.getEditingColumn() != n2) {
                boolean bl = (n & 1) > 0;
                boolean bl2 = this.table.isCellSelected(n, n2);
                int n3 = rectangle.x;
                int n4 = rectangle.y;
                int n5 = rectangle.width;
                int n6 = rectangle.height;
                graphics.setColor(darkBlue);
                graphics.fillRect(n3, n4, n5, n6);
                graphics.setColor(bl2 ? blueVLine : grayVLine);
                graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6 - 1);
                if (bl2) {
                    graphics.setColor(blueHLine);
                    graphics.drawLine(n3, n4 + n6 - 1, n3 + n5, n4 + n6 - 1);
                }
            }
        }

        private int viewIndexForColumn(TableColumn tableColumn) {
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                if (tableColumnModel.getColumn(i) != tableColumn) continue;
                return i;
            }
            return -1;
        }
    }

    static class LinedViewportUI
    extends ViewportUI {
        static final Color lightBlue = new Color(0.929f, 0.953f, 0.996f);
        static final Color grayVLine = new Color(0.851f, 0.851f, 0.851f);
        JTable table;
        JScrollPane scrollpane;

        LinedViewportUI(JTable jTable, JScrollPane jScrollPane) {
            this.table = jTable;
            this.scrollpane = jScrollPane;
        }

        public void paint(Graphics graphics, JComponent jComponent) {
            int n = this.table.getRowHeight();
            int n2 = jComponent.getWidth();
            int n3 = jComponent.getHeight();
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            int n4 = tableColumnModel.getColumnCount();
            Point point = this.scrollpane.getViewport().getViewPosition();
            int n5 = 0;
            for (int i = -point.y; i < n3; i += n) {
                graphics.setColor(n5 % 2 == 0 ? lightBlue : Color.white);
                graphics.fillRect(0, i, n2, n);
                ++n5;
            }
            graphics.setColor(grayVLine);
            int n6 = -point.x;
            for (n5 = 0; n5 < n4; ++n5) {
                graphics.drawLine((n6 += tableColumnModel.getColumn(n5).getWidth()) - 1, 0, n6 - 1, n3);
            }
        }
    }

    static class StringRenderer
    extends JPanel
    implements TableCellRenderer {
        CellBorder border;
        JLabel label;

        public StringRenderer() {
            this.setLayout(new BoxLayout(this, 0));
            this.border = new CellBorder();
            this.setBorder(this.border);
            this.setOpaque(false);
            this.label = new JLabel();
            this.label.setFont(GUIFactory.FONT_SMALL);
            this.label.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
            this.add(this.label);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return this;
            }
            this.border.setAttributes(bl, jTable.hasFocus(), n);
            this.label.setText((String)object);
            this.label.setForeground(bl ? Color.white : Color.black);
            return this;
        }
    }

    public static class CellBorder
    implements Border {
        static final Insets INSETS = new Insets(1, 1, 1, 1);
        static final Color darkBlue = new Color(0.239f, 0.502f, 0.875f);
        static final Color darkGray = new Color(0.753f, 0.753f, 0.753f);
        static final Color lightBlue = new Color(0.929f, 0.953f, 0.996f);
        static final Color blueHLine = new Color(0.49f, 0.667f, 0.918f);
        static final Color grayHLine = new Color(0.878f, 0.878f, 0.878f);
        static final Color blueVLine = new Color(0.204f, 0.427f, 0.745f);
        static final Color grayVLine = new Color(0.851f, 0.851f, 0.851f);
        boolean selected = false;
        boolean focus = false;
        boolean rowStyle = false;

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(this.selected ? darkBlue : (this.rowStyle ? Color.white : lightBlue));
            graphics.fillRect(n, n2, n3, n4);
            graphics.setColor(this.selected ? blueVLine : grayVLine);
            graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
            if (this.selected) {
                graphics.setColor(blueHLine);
                graphics.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
            }
        }

        public void setAttributes(boolean bl, boolean bl2, int n) {
            this.selected = bl;
            this.focus = bl2;
            this.rowStyle = (n & 1) > 0;
        }
    }
}

